/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeStrategiesTestBase;
import org.apache.flink.table.types.inference.strategies.SpecificTypeStrategies;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.utils.TypeConversions;

class RowtimeTypeStrategyTest
extends TypeStrategiesTestBase {
    RowtimeTypeStrategyTest() {
    }

    @Override
    protected Stream<TypeStrategiesTestBase.TestSpec> testData() {
        return Stream.of(TypeStrategiesTestBase.TestSpec.forStrategy("TIMESTAMP(3) *ROWTIME*", SpecificTypeStrategies.ROWTIME).inputTypes((DataType)RowtimeTypeStrategyTest.createRowtimeType(TimestampKind.ROWTIME, 3).notNull()).expectDataType((DataType)RowtimeTypeStrategyTest.createRowtimeType(TimestampKind.ROWTIME, 3).notNull()), TypeStrategiesTestBase.TestSpec.forStrategy("TIMESTAMP_LTZ(3) *ROWTIME*", SpecificTypeStrategies.ROWTIME).inputTypes((DataType)RowtimeTypeStrategyTest.createRowtimeLtzType(TimestampKind.ROWTIME, 3).notNull()).expectDataType((DataType)RowtimeTypeStrategyTest.createRowtimeLtzType(TimestampKind.ROWTIME, 3).notNull()), TypeStrategiesTestBase.TestSpec.forStrategy("BIGINT", SpecificTypeStrategies.ROWTIME).inputTypes((DataType)DataTypes.BIGINT().notNull()).expectDataType((DataType)DataTypes.TIMESTAMP((int)3).notNull()));
    }

    static DataType createRowtimeType(TimestampKind kind, int precision) {
        return TypeConversions.fromLogicalToDataType((LogicalType)new TimestampType(false, kind, precision));
    }

    static DataType createRowtimeLtzType(TimestampKind kind, int precision) {
        return TypeConversions.fromLogicalToDataType((LogicalType)new LocalZonedTimestampType(false, kind, precision));
    }
}

