/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.bridge.scala;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@PublicEvolving
@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u0006\r\u0001mA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\u0006o\u0001!\t\u0001\u000f\u0005\u0006y\u0001!\t!\u0010\u0005\u0006y\u0001!\ta\u0012\u0005\u0006\u001d\u0002!\ta\u0014\u0005\u0006\u001d\u0002!\t!\u0019\u0005\u0006K\u0002!\tA\u001a\u0005\u0006K\u0002!\t\u0001\u001b\u0005\u0006K\u0002!\ta\u001b\u0005\u0006y\u0001!\tA\u001e\u0002\u0016\t\u0006$\u0018m\u0015;sK\u0006l7i\u001c8wKJ\u001c\u0018n\u001c8t\u0015\tia\"A\u0003tG\u0006d\u0017M\u0003\u0002\u0010!\u00051!M]5eO\u0016T!!\u0005\n\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0014)\u0005)A/\u00192mK*\u0011QCF\u0001\u0006M2Lgn\u001b\u0006\u0003/a\ta!\u00199bG\",'\"A\r\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005qq3C\u0001\u0001\u001e!\tq\u0002%D\u0001 \u0015\u0005i\u0011BA\u0011 \u0005\u0019\te.\u001f*fM\u0006QA-\u0019;b'R\u0014X-Y7\u0011\u0007\u0011RC&D\u0001&\u0015\t1s%\u0001\u0006eCR\f7\u000f\u001e:fC6T!!\u0005\u0015\u000b\u0005%\"\u0012!C:ue\u0016\fW.\u001b8h\u0013\tYSE\u0001\u0006ECR\f7\u000b\u001e:fC6\u0004\"!\f\u0018\r\u0001\u0011)q\u0006\u0001b\u0001a\t\tA+\u0005\u00022iA\u0011aDM\u0005\u0003g}\u0011qAT8uQ&tw\r\u0005\u0002\u001fk%\u0011ag\b\u0002\u0004\u0003:L\u0018A\u0002\u001fj]&$h\b\u0006\u0002:wA\u0019!\b\u0001\u0017\u000e\u00031AQA\t\u0002A\u0002\r\nq\u0001^8UC\ndW\r\u0006\u0002?\u0005B\u0011q\bQ\u0007\u0002!%\u0011\u0011\t\u0005\u0002\u0006)\u0006\u0014G.\u001a\u0005\u0006\u0007\u000e\u0001\r\u0001R\u0001\ti\u0006\u0014G.Z#omB\u0011!(R\u0005\u0003\r2\u0011ac\u0015;sK\u0006lG+\u00192mK\u0016sg/\u001b:p]6,g\u000e\u001e\u000b\u0004}!K\u0005\"B\"\u0005\u0001\u0004!\u0005\"\u0002&\u0005\u0001\u0004Y\u0015AB:dQ\u0016l\u0017\r\u0005\u0002@\u0019&\u0011Q\n\u0005\u0002\u0007'\u000eDW-\\1\u0002'\r\u0014X-\u0019;f)\u0016l\u0007o\u001c:bef4\u0016.Z<\u0015\u0007A\u001bF\u000b\u0005\u0002\u001f#&\u0011!k\b\u0002\u0005+:LG\u000fC\u0003D\u000b\u0001\u0007A\tC\u0003V\u000b\u0001\u0007a+\u0001\u0003qCRD\u0007CA,_\u001d\tAF\f\u0005\u0002Z?5\t!L\u0003\u0002\\5\u00051AH]8pizJ!!X\u0010\u0002\rA\u0013X\rZ3g\u0013\ty\u0006M\u0001\u0004TiJLgn\u001a\u0006\u0003;~!B\u0001\u00152dI\")1I\u0002a\u0001\t\")QK\u0002a\u0001-\")!J\u0002a\u0001\u0017\u0006\u0001Bo\\\"iC:<W\r\\8h)\u0006\u0014G.\u001a\u000b\u0003}\u001dDQaQ\u0004A\u0002\u0011#2AP5k\u0011\u0015\u0019\u0005\u00021\u0001E\u0011\u0015Q\u0005\u00021\u0001L)\u0011qD.\u001c8\t\u000b\rK\u0001\u0019\u0001#\t\u000b)K\u0001\u0019A&\t\u000b=L\u0001\u0019\u00019\u0002\u001b\rD\u0017M\\4fY><Wj\u001c3f!\t\tH/D\u0001s\u0015\t\u0019(#A\u0005d_:tWm\u0019;pe&\u0011QO\u001d\u0002\u000e\u0007\"\fgnZ3m_\u001elu\u000eZ3\u0015\u0007y:\b\u0010C\u0003D\u0015\u0001\u0007A\tC\u0003z\u0015\u0001\u0007!0\u0001\u0004gS\u0016dGm\u001d\t\u0004=ml\u0018B\u0001? \u0005)a$/\u001a9fCR,GM\u0010\t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005!#A\u0006fqB\u0014Xm]:j_:\u001c\u0018bAA\u0003\u007f\nQQ\t\u001f9sKN\u001c\u0018n\u001c8)\u0007\u0001\tI\u0001\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\ty\u0001F\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\n\u0003\u001b\u0011a\u0002U;cY&\u001cWI^8mm&tw\rK\u0004\u0001\u0003/\ti\"a\u0013\u0011\u0007y\tI\"C\u0002\u0002\u001c}\u0011!\u0002Z3qe\u0016\u001c\u0017\r^3ec!\u0019c+a\b\u0002(\u0005\u0005\u0012\u0002BA\u0011\u0003G\t\u0001C\u0012'J!~\u0013d'N0X\u0003Js\u0015JT$\u000b\u0007\u0005\u0015\u0002#A\u0004qC\u000e\\\u0017mZ32\u0013\r\nI#a\u0010\u0002B\u0005\u0015b\u0002BA\u0016\u0003\u007fqA!!\f\u0002>9!\u0011qFA\u001e\u001d\u0011\t\t$!\u000f\u000f\t\u0005M\u0012q\u0007\b\u00043\u0006U\u0012\"A\r\n\u0005]A\u0012BA\u000b\u0017\u0013\t\u0019B#\u0003\u0002\u0012%%\u0019\u0011Q\u0005\t2\u0011\r\nY#!\u0010\u0002DE\t\u0004bIA\u0017\u0003w\t)eE\u0019\tG\u0005=\u0012\u0011HA$+EB1%!\r\u00028\u0005%s#\r\u0004%\u0003g\t)$G\u0011\u0003\u0003\u001b\na!\r\u00182q9\u0002\u0004")
public class DataStreamConversions<T> {
    private final DataStream<T> dataStream;

    public Table toTable(StreamTableEnvironment tableEnv) {
        Preconditions.checkNotNull((Object)tableEnv, (String)"Table environment must not be null.");
        return tableEnv.fromDataStream(this.dataStream);
    }

    public Table toTable(StreamTableEnvironment tableEnv, Schema schema) {
        Preconditions.checkNotNull((Object)tableEnv, (String)"Table environment must not be null.");
        return tableEnv.fromDataStream(this.dataStream, schema);
    }

    public void createTemporaryView(StreamTableEnvironment tableEnv, String path) {
        Preconditions.checkNotNull((Object)tableEnv, (String)"Table environment must not be null.");
        tableEnv.createTemporaryView(path, this.dataStream);
    }

    public void createTemporaryView(StreamTableEnvironment tableEnv, String path, Schema schema) {
        Preconditions.checkNotNull((Object)tableEnv, (String)"Table environment must not be null.");
        tableEnv.createTemporaryView(path, this.dataStream, schema);
    }

    public Table toChangelogTable(StreamTableEnvironment tableEnv) {
        Preconditions.checkNotNull((Object)tableEnv, (String)"Table environment must not be null.");
        Class clazz = this.dataStream.getType().getTypeClass();
        Class<Row> clazz2 = Row.class;
        if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
            throw new ValidationException("DataStream cannot be converted to a Table. It must contain instances of Row.");
        }
        return tableEnv.fromChangelogStream(this.dataStream);
    }

    public Table toChangelogTable(StreamTableEnvironment tableEnv, Schema schema) {
        Preconditions.checkNotNull((Object)tableEnv, (String)"Table environment must not be null.");
        Class clazz = this.dataStream.getType().getTypeClass();
        Class<Row> clazz2 = Row.class;
        if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
            throw new ValidationException("DataStream cannot be converted to a Table. It must contain instances of Row.");
        }
        return tableEnv.fromChangelogStream(this.dataStream, schema);
    }

    public Table toChangelogTable(StreamTableEnvironment tableEnv, Schema schema, ChangelogMode changelogMode) {
        Preconditions.checkNotNull((Object)tableEnv, (String)"Table environment must not be null.");
        Class clazz = this.dataStream.getType().getTypeClass();
        Class<Row> clazz2 = Row.class;
        if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
            throw new ValidationException("DataStream cannot be converted to a Table. It must contain instances of Row.");
        }
        return tableEnv.fromChangelogStream(this.dataStream, schema, changelogMode);
    }

    public Table toTable(StreamTableEnvironment tableEnv, Seq<Expression> fields) {
        if (fields.isEmpty()) {
            return this.toTable(tableEnv);
        }
        return tableEnv.fromDataStream(this.dataStream, fields);
    }

    public DataStreamConversions(DataStream<T> dataStream) {
        this.dataStream = dataStream;
    }
}

