/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.test.program;

import java.util.function.Function;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.test.program.TestStep;
import org.apache.flink.table.types.AbstractDataType;

public class TableApiTestStep
implements TestStep {
    private final Function<TableEnvAccessor, Table> tableQuery;
    private final String sinkName;

    TableApiTestStep(Function<TableEnvAccessor, Table> tableQuery, String sinkName) {
        this.tableQuery = tableQuery;
        this.sinkName = sinkName;
    }

    @Override
    public TestStep.TestKind getKind() {
        return TestStep.TestKind.TABLE_API;
    }

    public Table toTable(final TableEnvironment env) {
        return this.tableQuery.apply(new TableEnvAccessor(){

            @Override
            public Table from(String path) {
                return env.from(path);
            }

            @Override
            public Table fromValues(Object ... values) {
                return env.fromValues(values);
            }

            @Override
            public Table fromValues(AbstractDataType<?> dataType, Object ... values) {
                return env.fromValues(dataType, values);
            }

            @Override
            public Table sqlQuery(String query) {
                return env.sqlQuery(query);
            }
        });
    }

    public TableResult apply(TableEnvironment env) {
        Table table = this.toTable(env);
        return table.executeInsert(this.sinkName);
    }

    public TableResult applyAsSql(TableEnvironment env) {
        Table table = this.toTable(env);
        String query = table.getQueryOperation().asSerializableString();
        return env.executeSql(String.format("INSERT INTO %s %s", this.sinkName, query));
    }

    public static interface TableEnvAccessor {
        public Table from(String var1);

        public Table fromValues(Object ... var1);

        public Table fromValues(AbstractDataType<?> var1, Object ... var2);

        public Table sqlQuery(String var1);
    }
}

