/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.operations.SourceQueryOperation;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.utils.TableEnvironmentMock;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class TableEnvironmentTest {
    private static final Schema TEST_SCHEMA = Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.INT()).build();
    private static final TableDescriptor TEST_DESCRIPTOR = TableDescriptor.forConnector((String)"fake").schema(TEST_SCHEMA).option("a", "Test").build();

    TableEnvironmentTest() {
    }

    @Test
    void testCreateTemporaryTableFromDescriptor() {
        TableEnvironmentMock tEnv = TableEnvironmentMock.getStreamingInstance();
        TableEnvironmentTest.assertTemporaryCreateTableFromDescriptor(tEnv, TEST_SCHEMA, false);
    }

    @Test
    void testCreateTemporaryTableIfNotExistsFromDescriptor() {
        TableEnvironmentMock tEnv = TableEnvironmentMock.getStreamingInstance();
        TableEnvironmentTest.assertTemporaryCreateTableFromDescriptor(tEnv, TEST_SCHEMA, true);
        Assertions.assertThatNoException().isThrownBy(() -> tEnv.createTemporaryTable("T", TEST_DESCRIPTOR, true));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> tEnv.createTemporaryTable("T", TEST_DESCRIPTOR, false)).isInstanceOf(ValidationException.class)).hasMessageContaining("Temporary table '`default_catalog`.`default_database`.`T`' already exists");
    }

    @Test
    void testCreateTableFromDescriptor() throws Exception {
        TableEnvironmentMock tEnv = TableEnvironmentMock.getStreamingInstance();
        TableEnvironmentTest.assertCreateTableFromDescriptor(tEnv, TEST_SCHEMA, false);
    }

    @ParameterizedTest(name="{index}: ignoreIfExists ({0})")
    @ValueSource(booleans={true, false})
    void testCreateViewFromTable(boolean ignoreIfExists) throws Exception {
        TableEnvironmentMock tEnv = TableEnvironmentMock.getStreamingInstance();
        String catalog = tEnv.getCurrentCatalog();
        String database = tEnv.getCurrentDatabase();
        tEnv.createTable("T", TEST_DESCRIPTOR);
        Assertions.assertThat((boolean)tEnv.createView("V", tEnv.from("T"), ignoreIfExists)).isTrue();
        ObjectPath objectPath = new ObjectPath(database, "V");
        CatalogBaseTable catalogView = ((Catalog)tEnv.getCatalog(catalog).orElseThrow(AssertionError::new)).getTable(objectPath);
        Assertions.assertThat((Object)catalogView).isInstanceOf(CatalogView.class);
        Assertions.assertThat((Object)catalogView.getUnresolvedSchema()).isEqualTo((Object)TEST_SCHEMA);
    }

    @Test
    void testCreateViewWithSameNameIgnoreIfExists() {
        TableEnvironmentMock tEnv = TableEnvironmentMock.getStreamingInstance();
        tEnv.createTable("T", TEST_DESCRIPTOR);
        tEnv.createView("V", tEnv.from("T"));
        Assertions.assertThat((boolean)tEnv.createView("V", tEnv.from("T"), true)).isFalse();
    }

    @Test
    void testCreateViewWithSameName() {
        TableEnvironmentMock tEnv = TableEnvironmentMock.getStreamingInstance();
        tEnv.createTable("T", TEST_DESCRIPTOR);
        tEnv.createView("V", tEnv.from("T"));
        Assertions.assertThatThrownBy(() -> tEnv.createView("V", tEnv.from("T"), false)).hasCauseInstanceOf(TableAlreadyExistException.class).hasMessageContaining("Could not execute CreateTable in path `default_catalog`.`default_database`.`V`");
        Assertions.assertThatThrownBy(() -> tEnv.createView("V", tEnv.from("T"))).hasCauseInstanceOf(TableAlreadyExistException.class).hasMessageContaining("Could not execute CreateTable in path `default_catalog`.`default_database`.`V`");
    }

    @Test
    void testCreateTableIfNotExistsFromDescriptor() throws Exception {
        TableEnvironmentMock tEnv = TableEnvironmentMock.getStreamingInstance();
        TableEnvironmentTest.assertCreateTableFromDescriptor(tEnv, TEST_SCHEMA, true);
        Assertions.assertThatNoException().isThrownBy(() -> tEnv.createTable("T", TEST_DESCRIPTOR, true));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> tEnv.createTable("T", TEST_DESCRIPTOR, false)).isInstanceOf(ValidationException.class)).hasMessageContaining("Could not execute CreateTable in path `default_catalog`.`default_database`.`T`");
    }

    @Test
    void testTableFromDescriptor() {
        TableEnvironmentMock tEnv = TableEnvironmentMock.getStreamingInstance();
        Table table = tEnv.from(TEST_DESCRIPTOR);
        Assertions.assertThat((Object)Schema.newBuilder().fromResolvedSchema(table.getResolvedSchema()).build()).isEqualTo((Object)TEST_SCHEMA);
        ((ObjectAssert)Assertions.assertThat((Object)table.getQueryOperation()).asInstanceOf(InstanceOfAssertFactories.type(SourceQueryOperation.class))).extracting(SourceQueryOperation::getContextResolvedTable).satisfies(new ThrowingConsumer[]{crs -> {
            Assertions.assertThat((boolean)crs.isAnonymous()).isTrue();
            Assertions.assertThat((List)crs.getIdentifier().toList()).hasSize(1);
            Assertions.assertThat((Map)crs.getResolvedTable().getOptions()).containsEntry((Object)"connector", (Object)"fake");
        }});
        Assertions.assertThat((Collection)tEnv.getCatalogManager().listTables()).isEmpty();
    }

    private static void assertCreateTableFromDescriptor(TableEnvironmentMock tEnv, Schema schema, boolean ignoreIfExists) throws TableNotExistException {
        String catalog = tEnv.getCurrentCatalog();
        String database = tEnv.getCurrentDatabase();
        if (ignoreIfExists) {
            Assertions.assertThat((boolean)tEnv.createTable("T", TEST_DESCRIPTOR, true)).isTrue();
        } else {
            tEnv.createTable("T", TEST_DESCRIPTOR);
        }
        ObjectPath objectPath = new ObjectPath(database, "T");
        Assertions.assertThat((boolean)((Catalog)tEnv.getCatalog(catalog).orElseThrow(AssertionError::new)).tableExists(objectPath)).isTrue();
        CatalogBaseTable catalogTable = ((Catalog)tEnv.getCatalog(catalog).orElseThrow(AssertionError::new)).getTable(objectPath);
        Assertions.assertThat((Object)catalogTable).isInstanceOf(CatalogTable.class);
        Assertions.assertThat((Object)catalogTable.getUnresolvedSchema()).isEqualTo((Object)schema);
        Assertions.assertThat((Map)catalogTable.getOptions()).contains(new Map.Entry[]{Assertions.entry((Object)"connector", (Object)"fake"), Assertions.entry((Object)"a", (Object)"Test")});
    }

    private static void assertTemporaryCreateTableFromDescriptor(TableEnvironmentMock tEnv, Schema schema, boolean ignoreIfExists) {
        String catalog = tEnv.getCurrentCatalog();
        String database = tEnv.getCurrentDatabase();
        if (ignoreIfExists) {
            tEnv.createTemporaryTable("T", TEST_DESCRIPTOR, true);
        } else {
            tEnv.createTemporaryTable("T", TEST_DESCRIPTOR);
        }
        Assertions.assertThat((boolean)((Catalog)tEnv.getCatalog(catalog).orElseThrow(AssertionError::new)).tableExists(new ObjectPath(database, "T"))).isFalse();
        Optional lookupResult = tEnv.getCatalogManager().getTable(ObjectIdentifier.of((String)catalog, (String)database, (String)"T"));
        Assertions.assertThat((boolean)lookupResult.isPresent()).isTrue();
        ResolvedCatalogBaseTable catalogTable = ((ContextResolvedTable)lookupResult.get()).getResolvedTable();
        Assertions.assertThat((boolean)(catalogTable instanceof CatalogTable)).isTrue();
        Assertions.assertThat((Object)catalogTable.getUnresolvedSchema()).isEqualTo((Object)schema);
        Assertions.assertThat((String)((String)catalogTable.getOptions().get("connector"))).isEqualTo("fake");
        Assertions.assertThat((String)((String)catalogTable.getOptions().get("a"))).isEqualTo("Test");
    }
}

