/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeVisitor;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.inference.TypeTransformation;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeDefaultVisitor;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;
import org.apache.flink.table.types.utils.DataTypeDefaultVisitor;
import org.apache.flink.table.types.utils.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;

@Internal
public final class DataTypeUtils {
    @Deprecated
    public static DataType projectRow(DataType dataType, int[][] indexPaths) {
        return Projection.of(indexPaths).project(dataType);
    }

    @Deprecated
    public static DataType projectRow(DataType dataType, int[] indexPaths) {
        return Projection.of(indexPaths).project(dataType);
    }

    public static DataType stripRowPrefix(DataType dataType, String prefix) {
        Preconditions.checkArgument((boolean)dataType.getLogicalType().is(LogicalTypeRoot.ROW), (Object)"Row data type expected.");
        RowType rowType = (RowType)dataType.getLogicalType();
        List<String> newFieldNames = rowType.getFieldNames().stream().map(s -> {
            if (s.startsWith(prefix)) {
                return s.substring(prefix.length());
            }
            return s;
        }).collect(Collectors.toList());
        RowType newRowType = LogicalTypeUtils.renameRowFields(rowType, newFieldNames);
        return new FieldsDataType(newRowType, dataType.getConversionClass(), dataType.getChildren());
    }

    public static DataType appendRowFields(DataType dataType, List<DataTypes.Field> fields) {
        Preconditions.checkArgument((boolean)dataType.getLogicalType().is(LogicalTypeRoot.ROW), (Object)"Row data type expected.");
        if (fields.size() == 0) {
            return dataType;
        }
        DataType newRow = Stream.concat(DataType.getFields(dataType).stream(), fields.stream()).collect(Collectors.collectingAndThen(Collectors.toList(), DataTypes::ROW));
        if (!dataType.getLogicalType().isNullable()) {
            newRow = (DataType)newRow.notNull();
        }
        return newRow;
    }

    public static DataType toInternalDataType(LogicalType logicalType) {
        DataType defaultDataType = TypeConversions.fromLogicalToDataType(logicalType);
        return DataTypeUtils.toInternalDataType(defaultDataType);
    }

    public static DataType toInternalDataType(DataType dataType) {
        return (DataType)dataType.bridgedTo(LogicalTypeUtils.toInternalConversionClass(dataType.getLogicalType()));
    }

    public static boolean isInternal(DataType dataType) {
        return DataTypeUtils.isInternal(dataType, true);
    }

    public static boolean isInternal(DataType dataType, boolean autobox) {
        Class<?> clazz = autobox ? ExtractionUtils.primitiveToWrapper(dataType.getConversionClass()) : dataType.getConversionClass();
        return clazz == LogicalTypeUtils.toInternalConversionClass(dataType.getLogicalType());
    }

    public static DataType replaceLogicalType(DataType dataType, LogicalType replacement) {
        return (DataType)LogicalTypeDataTypeConverter.toDataType(replacement).bridgedTo(dataType.getConversionClass());
    }

    public static DataType removeTimeAttribute(DataType dataType) {
        LogicalType type = dataType.getLogicalType();
        if (type.is(LogicalTypeFamily.TIMESTAMP)) {
            return DataTypeUtils.replaceLogicalType(dataType, LogicalTypeUtils.removeTimeAttributes(type));
        }
        return dataType;
    }

    public static DataType transform(DataType typeToTransform, TypeTransformation ... transformations) {
        return DataTypeUtils.transform(null, typeToTransform, transformations);
    }

    public static DataType transform(@Nullable DataTypeFactory factory, DataType typeToTransform, TypeTransformation ... transformations) {
        Preconditions.checkArgument((transformations.length > 0 ? 1 : 0) != 0, (Object)"transformations should not be empty.");
        DataType newType = typeToTransform;
        for (TypeTransformation transformation : transformations) {
            newType = newType.accept(new DataTypeTransformer(factory, transformation));
        }
        return newType;
    }

    public static ResolvedSchema expandCompositeTypeToSchema(DataType dataType) {
        if (dataType instanceof FieldsDataType) {
            return DataTypeUtils.expandCompositeType((FieldsDataType)dataType);
        }
        if (dataType.getLogicalType() instanceof LegacyTypeInformationType && dataType.getLogicalType().getTypeRoot() == LogicalTypeRoot.STRUCTURED_TYPE) {
            return DataTypeUtils.expandLegacyCompositeType(dataType);
        }
        throw new IllegalArgumentException("Expected a composite type");
    }

    public static Optional<DataType> getField(DataType compositeType, int index) {
        ResolvedSchema tableSchema = DataTypeUtils.expandCompositeTypeToSchema(compositeType);
        return tableSchema.getColumn(index).map(Column::getDataType);
    }

    public static Optional<DataType> getField(DataType compositeType, String name) {
        ResolvedSchema resolvedSchema = DataTypeUtils.expandCompositeTypeToSchema(compositeType);
        return resolvedSchema.getColumn(name).map(Column::getDataType);
    }

    public static List<DataType> flattenToDataTypes(DataType dataType) {
        LogicalType type = dataType.getLogicalType();
        if (type.is(LogicalTypeRoot.DISTINCT_TYPE)) {
            return DataTypeUtils.flattenToDataTypes(dataType.getChildren().get(0));
        }
        if (LogicalTypeChecks.isCompositeType(type)) {
            return dataType.getChildren();
        }
        return Collections.singletonList(dataType);
    }

    public static List<String> flattenToNames(DataType dataType) {
        return DataTypeUtils.flattenToNames(dataType, Collections.emptyList());
    }

    public static List<String> flattenToNames(DataType dataType, List<String> existingNames) {
        LogicalType type = dataType.getLogicalType();
        if (type.is(LogicalTypeRoot.DISTINCT_TYPE)) {
            return DataTypeUtils.flattenToNames(dataType.getChildren().get(0), existingNames);
        }
        if (LogicalTypeChecks.isCompositeType(type)) {
            return LogicalTypeChecks.getFieldNames(type);
        }
        return Collections.singletonList(LogicalTypeUtils.getAtomicName(existingNames));
    }

    public static void validateInputDataType(DataType dataType) {
        dataType.accept(DataTypeInputClassValidator.INSTANCE);
    }

    public static void validateOutputDataType(DataType dataType) {
        dataType.accept(DataTypeOutputClassValidator.INSTANCE);
    }

    public static DataType createProctimeDataType() {
        return new AtomicDataType(new LocalZonedTimestampType(true, TimestampKind.PROCTIME, 3));
    }

    private DataTypeUtils() {
    }

    private static ResolvedSchema expandCompositeType(FieldsDataType dataType) {
        final DataType[] fieldDataTypes = dataType.getChildren().toArray(new DataType[0]);
        return dataType.getLogicalType().accept(new LogicalTypeDefaultVisitor<ResolvedSchema>(){

            @Override
            public ResolvedSchema visit(RowType rowType) {
                return DataTypeUtils.expandCompositeType(rowType, fieldDataTypes);
            }

            @Override
            public ResolvedSchema visit(StructuredType structuredType) {
                return DataTypeUtils.expandCompositeType(structuredType, fieldDataTypes);
            }

            @Override
            public ResolvedSchema visit(DistinctType distinctType) {
                return distinctType.getSourceType().accept(this);
            }

            @Override
            protected ResolvedSchema defaultMethod(LogicalType logicalType) {
                throw new IllegalArgumentException("Expected a composite type");
            }
        });
    }

    private static ResolvedSchema expandLegacyCompositeType(DataType dataType) {
        CompositeType compositeType = (CompositeType)((LegacyTypeInformationType)dataType.getLogicalType()).getTypeInformation();
        String[] fieldNames = compositeType.getFieldNames();
        DataType[] fieldTypes = (DataType[])Arrays.stream(fieldNames).map(arg_0 -> ((CompositeType)compositeType).getTypeAt(arg_0)).map(TypeConversions::fromLegacyInfoToDataType).toArray(DataType[]::new);
        return ResolvedSchema.physical(fieldNames, fieldTypes);
    }

    private static ResolvedSchema expandCompositeType(LogicalType compositeType, DataType[] fieldDataTypes) {
        String[] fieldNames = LogicalTypeChecks.getFieldNames(compositeType).toArray(new String[0]);
        return ResolvedSchema.physical(fieldNames, fieldDataTypes);
    }

    private static class DataTypeTransformer
    implements DataTypeVisitor<DataType> {
        @Nullable
        private final DataTypeFactory factory;
        private final TypeTransformation transformation;

        private DataTypeTransformer(@Nullable DataTypeFactory factory, TypeTransformation transformation) {
            this.factory = factory;
            this.transformation = transformation;
        }

        @Override
        public DataType visit(AtomicDataType atomicDataType) {
            return this.transformation.transform(this.factory, atomicDataType);
        }

        @Override
        public DataType visit(CollectionDataType collectionDataType) {
            LogicalType newLogicalType;
            DataType newElementType = collectionDataType.getElementDataType().accept(this);
            LogicalType logicalType = collectionDataType.getLogicalType();
            if (logicalType instanceof ArrayType) {
                newLogicalType = new ArrayType(logicalType.isNullable(), newElementType.getLogicalType());
            } else if (logicalType instanceof MultisetType) {
                newLogicalType = new MultisetType(logicalType.isNullable(), newElementType.getLogicalType());
            } else {
                throw new UnsupportedOperationException("Unsupported logical type : " + logicalType);
            }
            return this.transformation.transform(this.factory, new CollectionDataType(newLogicalType, collectionDataType.getConversionClass(), newElementType));
        }

        @Override
        public DataType visit(FieldsDataType fieldsDataType) {
            LogicalType newLogicalType;
            List<DataType> newDataTypes = fieldsDataType.getChildren().stream().map(dt -> dt.accept(this)).collect(Collectors.toList());
            LogicalType logicalType = fieldsDataType.getLogicalType();
            if (logicalType instanceof RowType) {
                List<RowType.RowField> oldFields = ((RowType)logicalType).getFields();
                List<RowType.RowField> newFields = IntStream.range(0, oldFields.size()).mapToObj(i -> new RowType.RowField(((RowType.RowField)oldFields.get(i)).getName(), ((DataType)newDataTypes.get(i)).getLogicalType(), ((RowType.RowField)oldFields.get(i)).getDescription().orElse(null))).collect(Collectors.toList());
                newLogicalType = new RowType(logicalType.isNullable(), newFields);
            } else if (logicalType instanceof StructuredType) {
                StructuredType structuredType = (StructuredType)logicalType;
                if (structuredType.getSuperType().isPresent()) {
                    throw new UnsupportedOperationException("Hierarchies of structured types are not supported yet.");
                }
                List<StructuredType.StructuredAttribute> oldAttributes = structuredType.getAttributes();
                List<StructuredType.StructuredAttribute> newAttributes = IntStream.range(0, oldAttributes.size()).mapToObj(i -> new StructuredType.StructuredAttribute(((StructuredType.StructuredAttribute)oldAttributes.get(i)).getName(), ((DataType)newDataTypes.get(i)).getLogicalType(), ((StructuredType.StructuredAttribute)oldAttributes.get(i)).getDescription().orElse(null))).collect(Collectors.toList());
                StructuredType.Builder builder = this.createStructuredBuilder(structuredType);
                builder.attributes(newAttributes);
                builder.setNullable(structuredType.isNullable());
                builder.setFinal(structuredType.isFinal());
                builder.setInstantiable(structuredType.isInstantiable());
                builder.comparison(structuredType.getComparison());
                structuredType.getDescription().ifPresent(builder::description);
                newLogicalType = builder.build();
            } else {
                throw new UnsupportedOperationException("Unsupported logical type : " + logicalType);
            }
            return this.transformation.transform(this.factory, new FieldsDataType(newLogicalType, fieldsDataType.getConversionClass(), newDataTypes));
        }

        @Override
        public DataType visit(KeyValueDataType keyValueDataType) {
            DataType newKeyType = keyValueDataType.getKeyDataType().accept(this);
            DataType newValueType = keyValueDataType.getValueDataType().accept(this);
            LogicalType logicalType = keyValueDataType.getLogicalType();
            if (!(logicalType instanceof MapType)) {
                throw new UnsupportedOperationException("Unsupported logical type : " + logicalType);
            }
            MapType newLogicalType = new MapType(logicalType.isNullable(), newKeyType.getLogicalType(), newValueType.getLogicalType());
            return this.transformation.transform(this.factory, new KeyValueDataType(newLogicalType, keyValueDataType.getConversionClass(), newKeyType, newValueType));
        }

        private StructuredType.Builder createStructuredBuilder(StructuredType structuredType) {
            Optional<ObjectIdentifier> identifier = structuredType.getObjectIdentifier();
            Optional<Class<?>> implementationClass = structuredType.getImplementationClass();
            if (identifier.isPresent() && implementationClass.isPresent()) {
                return StructuredType.newBuilder(identifier.get(), implementationClass.get());
            }
            if (identifier.isPresent()) {
                return StructuredType.newBuilder(identifier.get());
            }
            if (implementationClass.isPresent()) {
                return StructuredType.newBuilder(implementationClass.get());
            }
            throw new IllegalArgumentException("Invalid structured type.");
        }
    }

    private static class DataTypeInputClassValidator
    extends DataTypeDefaultVisitor<Void> {
        private static final DataTypeInputClassValidator INSTANCE = new DataTypeInputClassValidator();

        private DataTypeInputClassValidator() {
        }

        @Override
        protected Void defaultMethod(DataType dataType) {
            if (!dataType.getLogicalType().supportsInputConversion(dataType.getConversionClass())) {
                throw new ValidationException(String.format("Data type '%s' does not support an input conversion from class '%s'.", dataType, dataType.getConversionClass().getName()));
            }
            dataType.getChildren().forEach(child -> child.accept(this));
            return null;
        }
    }

    private static class DataTypeOutputClassValidator
    extends DataTypeDefaultVisitor<Void> {
        private static final DataTypeOutputClassValidator INSTANCE = new DataTypeOutputClassValidator();

        private DataTypeOutputClassValidator() {
        }

        @Override
        protected Void defaultMethod(DataType dataType) {
            if (!dataType.getLogicalType().supportsOutputConversion(dataType.getConversionClass())) {
                throw new ValidationException(String.format("Data type '%s' does not support an output conversion to class '%s'.", dataType, dataType.getConversionClass().getName()));
            }
            dataType.getChildren().forEach(child -> child.accept(this));
            return null;
        }
    }
}

