/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.shaded.asm9.org.objectweb.asm.ClassReader;
import org.apache.flink.shaded.asm9.org.objectweb.asm.ClassVisitor;
import org.apache.flink.shaded.asm9.org.objectweb.asm.Label;
import org.apache.flink.shaded.asm9.org.objectweb.asm.MethodVisitor;
import org.apache.flink.shaded.asm9.org.objectweb.asm.Type;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.StateHint;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.types.DataType;

@Internal
public final class ExtractionUtils {
    private static final Map<Class<?>, Class<?>> primitiveWrapperMap = new HashMap();
    private static final Map<Class<?>, Class<?>> wrapperPrimitiveMap;
    private static final Map<String, Class<?>> primitiveNameMap;

    public static List<Method> collectMethods(Class<?> function, String methodName) {
        return Arrays.stream(function.getMethods()).filter(method -> method.getName().equals(methodName)).sorted(Comparator.comparing(Method::toString)).collect(Collectors.toList());
    }

    public static boolean isInvokable(Autoboxing autoboxing, Executable executable, Class<?> ... classes) {
        int m = executable.getModifiers();
        if (!Modifier.isPublic(m)) {
            return false;
        }
        int paramCount = executable.getParameterCount();
        int classCount = classes.length;
        if (!executable.isVarArgs() && classCount != paramCount || executable.isVarArgs() && classCount < paramCount - 1) {
            return false;
        }
        int currentClass = 0;
        for (int currentParam = 0; currentParam < paramCount; ++currentParam) {
            Class<?> param = executable.getParameterTypes()[currentParam];
            if (currentParam == paramCount - 1 && executable.isVarArgs()) {
                Class<?> paramComponent = executable.getParameterTypes()[currentParam].getComponentType();
                if (classCount - currentClass > 1) {
                    while (currentClass < classCount && ExtractionUtils.isAssignable(classes[currentClass], paramComponent, autoboxing)) {
                        ++currentClass;
                    }
                    continue;
                }
                if (currentClass >= classCount || !ExtractionUtils.parameterMatches(autoboxing, classes[currentClass], param) && !ExtractionUtils.parameterMatches(autoboxing, classes[currentClass], paramComponent)) continue;
                ++currentClass;
                continue;
            }
            if (!ExtractionUtils.parameterMatches(autoboxing, classes[currentClass], param)) continue;
            ++currentClass;
        }
        return currentClass == classCount;
    }

    private static boolean parameterMatches(Autoboxing autoboxing, Class<?> clz, Class<?> param) {
        return clz == null || ExtractionUtils.isAssignable(clz, param, autoboxing);
    }

    public static String createMethodSignatureString(String methodName, Class<?>[] parameters, @Nullable Class<?> returnType) {
        StringBuilder builder = new StringBuilder();
        if (returnType != null) {
            builder.append(returnType.getCanonicalName()).append(" ");
        }
        builder.append(methodName).append(Stream.of(parameters).map(parameter -> {
            if (parameter == null) {
                return "_";
            }
            return parameter.getCanonicalName();
        }).collect(Collectors.joining(", ", "(", ")")));
        return builder.toString();
    }

    public static void validateStructuredClass(Class<?> clazz) {
        int m = clazz.getModifiers();
        if (Modifier.isAbstract(m)) {
            throw ExtractionUtils.extractionError("Class '%s' must not be abstract.", clazz.getName());
        }
        if (!Modifier.isPublic(m)) {
            throw ExtractionUtils.extractionError("Class '%s' is not public.", clazz.getName());
        }
        if (!(clazz.getEnclosingClass() == null || clazz.getDeclaringClass() != null && Modifier.isStatic(m))) {
            throw ExtractionUtils.extractionError("Class '%s' is a not a static, globally accessible class.", clazz.getName());
        }
    }

    public static Field getStructuredField(Class<?> clazz, String fieldName) {
        String normalizedFieldName = fieldName.toUpperCase();
        List<Field> fields = ExtractionUtils.collectStructuredFields(clazz);
        for (Field field : fields) {
            if (!field.getName().toUpperCase().equals(normalizedFieldName)) continue;
            return field;
        }
        throw ExtractionUtils.extractionError("Could not find a field named '%s' in class '%s' for structured type.", fieldName, clazz.getName());
    }

    public static Optional<Method> getStructuredFieldGetter(Class<?> clazz, Field field) {
        String normalizedFieldName = ExtractionUtils.normalizeAccessorName(field.getName());
        List<Method> methods = ExtractionUtils.collectStructuredMethods(clazz);
        for (Method method : methods) {
            boolean hasNoParameters;
            java.lang.reflect.Type returnType;
            boolean hasReturnType;
            String normalizedMethodName = ExtractionUtils.normalizeAccessorName(method.getName());
            boolean hasName = normalizedMethodName.equals("GET" + normalizedFieldName) || normalizedMethodName.equals("IS" + normalizedFieldName) || normalizedMethodName.equals(normalizedFieldName);
            if (!hasName || !(hasReturnType = (returnType = method.getGenericReturnType()).equals(field.getGenericType()))) continue;
            boolean bl = hasNoParameters = method.getParameterCount() == 0;
            if (!hasNoParameters) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }

    public static Optional<Method> getStructuredFieldSetter(Class<?> clazz, Field field) {
        String normalizedFieldName = ExtractionUtils.normalizeAccessorName(field.getName());
        List<Method> methods = ExtractionUtils.collectStructuredMethods(clazz);
        for (Method method : methods) {
            boolean hasParameter;
            Class<?> returnType;
            boolean hasReturnType;
            String normalizedMethodName = ExtractionUtils.normalizeAccessorName(method.getName());
            boolean hasName = normalizedMethodName.equals("SET" + normalizedFieldName) || normalizedMethodName.equals(normalizedFieldName) || normalizedMethodName.equals(normalizedFieldName + "$EQ");
            if (!hasName || !(hasReturnType = (returnType = method.getReturnType()) == Void.TYPE || returnType == clazz)) continue;
            boolean bl = hasParameter = method.getParameterCount() == 1 && (method.getGenericParameterTypes()[0].equals(field.getGenericType()) || ExtractionUtils.primitiveToWrapper(method.getGenericParameterTypes()[0]).equals(field.getGenericType()));
            if (!hasParameter) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }

    private static String normalizeAccessorName(String name) {
        return name.toUpperCase().replaceAll(Pattern.quote("_"), "");
    }

    public static boolean hasInvokableConstructor(Class<?> clazz, Class<?> ... classes) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (!ExtractionUtils.isInvokable(Autoboxing.JVM, constructor, classes)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStructuredFieldDirectlyReadable(Field field) {
        int m = field.getModifiers();
        return Modifier.isPublic(m);
    }

    public static boolean isStructuredFieldDirectlyWritable(Field field) {
        int m = field.getModifiers();
        if (Modifier.isFinal(m)) {
            return false;
        }
        return Modifier.isPublic(m);
    }

    public static Optional<Class<?>> extractSimpleGeneric(Class<?> baseClass, Class<?> clazz, int pos) {
        try {
            if (!baseClass.isAssignableFrom(clazz)) {
                return Optional.empty();
            }
            java.lang.reflect.Type t = ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments()[pos];
            return Optional.ofNullable(ExtractionUtils.toClass(t));
        }
        catch (Exception unused) {
            return Optional.empty();
        }
    }

    public static java.lang.reflect.Type resolveVariableWithClassContext(@Nullable java.lang.reflect.Type contextType, java.lang.reflect.Type type) {
        List<java.lang.reflect.Type> typeHierarchy = contextType != null ? ExtractionUtils.collectTypeHierarchy(contextType) : Collections.emptyList();
        if (!ExtractionUtils.containsTypeVariable(type)) {
            return type;
        }
        if (type instanceof TypeVariable) {
            return ExtractionUtils.resolveVariable(typeHierarchy, (TypeVariable)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            ArrayList<java.lang.reflect.Type> paramTypes = new ArrayList<java.lang.reflect.Type>();
            for (java.lang.reflect.Type paramType : parameterizedType.getActualTypeArguments()) {
                paramType = ExtractionUtils.resolveVariableWithClassContext(contextType, paramType);
                paramTypes.add(paramType);
            }
            return new ParameterizedTypeImpl(paramTypes.toArray(paramTypes.toArray(new java.lang.reflect.Type[0])), parameterizedType.getRawType(), parameterizedType.getOwnerType());
        }
        if (type instanceof GenericArrayType) {
            java.lang.reflect.Type componentType = ExtractionUtils.resolveVariableWithClassContext(contextType, ((GenericArrayType)type).getGenericComponentType());
            return new GenericArrayTypeImpl(componentType);
        }
        return type;
    }

    public static Class<?> getClassFromType(java.lang.reflect.Type type) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance((Class)((GenericArrayType)type).getGenericComponentType(), 0).getClass();
        }
        return (Class)type;
    }

    static ValidationException extractionError(String message, Object ... args) {
        return ExtractionUtils.extractionError(null, message, args);
    }

    static ValidationException extractionError(Throwable cause, String message, Object ... args) {
        return new ValidationException(String.format(message, args), cause);
    }

    static List<java.lang.reflect.Type> collectTypeHierarchy(java.lang.reflect.Type type) {
        java.lang.reflect.Type currentType = type;
        Class<?> currentClass = ExtractionUtils.toClass(type);
        ArrayList<java.lang.reflect.Type> typeHierarchy = new ArrayList<java.lang.reflect.Type>();
        while (currentClass != null) {
            typeHierarchy.add(currentType);
            for (java.lang.reflect.Type genericInterface : currentClass.getGenericInterfaces()) {
                Class<?> interfaceClass = ExtractionUtils.toClass(genericInterface);
                if (interfaceClass == null) continue;
                typeHierarchy.addAll(ExtractionUtils.collectTypeHierarchy(genericInterface));
            }
            currentType = currentClass.getGenericSuperclass();
            currentClass = ExtractionUtils.toClass(currentType);
        }
        return typeHierarchy;
    }

    @Nullable
    static Class<?> toClass(java.lang.reflect.Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return null;
    }

    static DataType createRawType(DataTypeFactory typeFactory, @Nullable Class<? extends TypeSerializer<?>> rawSerializer, @Nullable Class<?> conversionClass) {
        if (rawSerializer != null) {
            return DataTypes.RAW(ExtractionUtils.createConversionClass(conversionClass), ExtractionUtils.instantiateRawSerializer(rawSerializer));
        }
        return typeFactory.createRawDataType(ExtractionUtils.createConversionClass(conversionClass));
    }

    static Class<?> createConversionClass(@Nullable Class<?> conversionClass) {
        if (conversionClass != null) {
            return conversionClass;
        }
        return Object.class;
    }

    private static TypeSerializer<?> instantiateRawSerializer(Class<? extends TypeSerializer<?>> rawSerializer) {
        try {
            return rawSerializer.newInstance();
        }
        catch (Exception e) {
            throw ExtractionUtils.extractionError(e, "Cannot instantiate type serializer '%s' for RAW type. Make sure the class is publicly accessible and has a default constructor.", rawSerializer.getName());
        }
    }

    static java.lang.reflect.Type resolveVariable(List<java.lang.reflect.Type> typeHierarchy, TypeVariable<?> variable) {
        for (int i = typeHierarchy.size() - 1; i >= 0; --i) {
            java.lang.reflect.Type currentType = typeHierarchy.get(i);
            if (!(currentType instanceof ParameterizedType)) continue;
            java.lang.reflect.Type resolvedType = ExtractionUtils.resolveVariableInParameterizedType(variable, (ParameterizedType)currentType);
            if (resolvedType instanceof TypeVariable) {
                variable = (TypeVariable)resolvedType;
                continue;
            }
            if (resolvedType == null) continue;
            return resolvedType;
        }
        return variable;
    }

    @Nullable
    private static java.lang.reflect.Type resolveVariableInParameterizedType(TypeVariable<?> variable, ParameterizedType currentType) {
        Class currentRaw = (Class)currentType.getRawType();
        TypeVariable<Class<T>>[] currentVariables = currentRaw.getTypeParameters();
        for (int paramPos = 0; paramPos < currentVariables.length; ++paramPos) {
            if (!ExtractionUtils.typeVariableEquals(variable, currentVariables[paramPos])) continue;
            return currentType.getActualTypeArguments()[paramPos];
        }
        return null;
    }

    private static boolean typeVariableEquals(TypeVariable<?> variable, TypeVariable<?> currentVariable) {
        return currentVariable.getGenericDeclaration().equals(variable.getGenericDeclaration()) && currentVariable.getName().equals(variable.getName());
    }

    static void validateStructuredSelfReference(java.lang.reflect.Type t, List<java.lang.reflect.Type> typeHierarchy) {
        Class<?> clazz = ExtractionUtils.toClass(t);
        if (clazz != null && !clazz.isInterface() && clazz != Object.class && typeHierarchy.contains(t)) {
            throw ExtractionUtils.extractionError("Cyclic reference detected for class '%s'. Attributes of structured types must not (transitively) reference the structured type itself.", clazz.getName());
        }
    }

    static List<Field> collectStructuredFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != Object.class) {
            Field[] declaredFields = clazz.getDeclaredFields();
            Stream.of(declaredFields).filter(field -> {
                int m = field.getModifiers();
                return !Modifier.isStatic(m) && !Modifier.isTransient(m);
            }).forEach(fields::add);
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    static void validateStructuredFieldReadability(Class<?> clazz, Field field) {
        if (ExtractionUtils.isStructuredFieldDirectlyReadable(field)) {
            return;
        }
        if (!ExtractionUtils.getStructuredFieldGetter(clazz, field).isPresent()) {
            throw ExtractionUtils.extractionError("Field '%s' of class '%s' is neither publicly accessible nor does it have a corresponding getter method.", field.getName(), clazz.getName());
        }
    }

    static boolean isStructuredFieldMutable(Class<?> clazz, Field field) {
        int m = field.getModifiers();
        if (Modifier.isFinal(m)) {
            return false;
        }
        if (Modifier.isPublic(m)) {
            return true;
        }
        if (ExtractionUtils.getStructuredFieldSetter(clazz, field).isPresent()) {
            return true;
        }
        throw ExtractionUtils.extractionError("Field '%s' of class '%s' is mutable but is neither publicly accessible nor does it have a corresponding setter method.", field.getName(), clazz.getName());
    }

    static java.lang.reflect.Type primitiveToWrapper(java.lang.reflect.Type type) {
        if (type instanceof Class) {
            return ExtractionUtils.primitiveToWrapper((Class)type);
        }
        return type;
    }

    static List<Method> collectStructuredMethods(Class<?> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        while (clazz != Object.class) {
            Method[] declaredMethods = clazz.getDeclaredMethods();
            Stream.of(declaredMethods).filter(field -> {
                int m = field.getModifiers();
                return Modifier.isPublic(m) && !Modifier.isNative(m) && !Modifier.isAbstract(m);
            }).forEach(methods::add);
            clazz = clazz.getSuperclass();
        }
        return methods;
    }

    static <T extends Annotation> Set<T> collectAnnotationsOfClass(Class<T> annotation, Class<?> annotatedClass) {
        ArrayList classHierarchy = new ArrayList();
        for (Class<?> currentClass = annotatedClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            classHierarchy.add(currentClass);
        }
        Collections.reverse(classHierarchy);
        return classHierarchy.stream().flatMap(c -> Stream.of(c.getAnnotationsByType(annotation))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    static <T extends Annotation> Set<T> collectAnnotationsOfMethod(Class<T> annotation, Method annotatedMethod) {
        return new LinkedHashSet<Annotation>(Arrays.asList(annotatedMethod.getAnnotationsByType(annotation)));
    }

    @Nullable
    public static AssigningConstructor extractAssigningConstructor(Class<?> clazz, List<Field> fields) {
        AssigningConstructor foundConstructor = null;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            List<String> parameterNames;
            boolean qualifyingConstructor;
            boolean bl = qualifyingConstructor = Modifier.isPublic(constructor.getModifiers()) && constructor.getParameterCount() == fields.size();
            if (!qualifyingConstructor || (parameterNames = ExtractionUtils.extractConstructorParameterNames(constructor, fields)) == null) continue;
            if (foundConstructor != null) {
                throw ExtractionUtils.extractionError("Multiple constructors found that assign all fields for class '%s'.", clazz.getName());
            }
            foundConstructor = new AssigningConstructor(constructor, parameterNames);
        }
        return foundConstructor;
    }

    @Nullable
    static List<String> extractMethodParameterNames(Method method) {
        return ExtractionUtils.extractExecutableNames(method);
    }

    @Nullable
    private static List<String> extractConstructorParameterNames(Constructor<?> constructor, List<Field> fields) {
        java.lang.reflect.Type[] parameterTypes = constructor.getGenericParameterTypes();
        List<String> parameterNames = ExtractionUtils.extractExecutableNames(constructor);
        if (parameterNames == null) {
            return null;
        }
        Map fieldMap = fields.stream().collect(Collectors.toMap(f -> ExtractionUtils.normalizeAccessorName(f.getName()), Function.identity()));
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (int i = 0; i < parameterNames.size(); ++i) {
            String parameterName = ExtractionUtils.normalizeAccessorName(parameterNames.get(i));
            Field field = (Field)fieldMap.get(parameterName);
            if (field == null) {
                return null;
            }
            java.lang.reflect.Type fieldType = field.getGenericType();
            java.lang.reflect.Type parameterType = parameterTypes[i];
            if (!ExtractionUtils.primitiveToWrapper(parameterType).equals(ExtractionUtils.primitiveToWrapper(fieldType))) {
                return null;
            }
            fieldNames.add(field.getName());
        }
        return fieldNames;
    }

    @Nullable
    @VisibleForTesting
    static List<String> extractExecutableNames(Executable executable) {
        int offset = !Modifier.isStatic(executable.getModifiers()) ? 1 : 0;
        List<String> parameterNames = Stream.of(executable.getParameters()).map(parameter -> {
            StateHint stateHint = parameter.getAnnotation(StateHint.class);
            ArgumentHint argHint = parameter.getAnnotation(ArgumentHint.class);
            if (stateHint != null && !stateHint.name().isEmpty()) {
                return stateHint.name();
            }
            if (argHint != null && !argHint.name().isEmpty()) {
                return argHint.name();
            }
            return parameter.getName();
        }).collect(Collectors.toList());
        if (parameterNames.stream().allMatch(n -> n.startsWith("arg"))) {
            ParameterExtractor extractor = executable instanceof Constructor ? new ParameterExtractor((Constructor)executable) : new ParameterExtractor((Method)executable);
            ExtractionUtils.getClassReader(executable.getDeclaringClass()).accept((ClassVisitor)extractor, 0);
            List<String> extractedNames = extractor.getParameterNames();
            if (extractedNames.isEmpty()) {
                return null;
            }
            parameterNames = extractedNames.subList(offset, Math.min(executable.getParameterCount() + offset, extractedNames.size()));
        }
        if (parameterNames.size() != executable.getParameterCount()) {
            return null;
        }
        return parameterNames;
    }

    private static ClassReader getClassReader(Class<?> cls) {
        ClassReader classReader;
        block8: {
            String className = cls.getName().replaceFirst("^.*\\.", "") + ".class";
            InputStream i = cls.getResourceAsStream(className);
            try {
                classReader = new ClassReader(i);
                if (i == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (i != null) {
                        try {
                            i.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not instantiate ClassReader.", e);
                }
            }
            i.close();
        }
        return classReader;
    }

    public static boolean isAssignable(Class<?> cls, Class<?> toClass, Autoboxing autoboxing) {
        if (toClass == null) {
            return false;
        }
        if (cls == null) {
            return !toClass.isPrimitive();
        }
        if (autoboxing != Autoboxing.NONE) {
            if (cls.isPrimitive() && !toClass.isPrimitive() && (cls = ExtractionUtils.primitiveToWrapper(cls)) == null) {
                return false;
            }
            if (autoboxing == Autoboxing.JVM && toClass.isPrimitive() && !cls.isPrimitive() && (cls = ExtractionUtils.wrapperToPrimitive(cls)) == null) {
                return false;
            }
        }
        if (cls.equals(toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (!toClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(cls)) {
                return Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Long.TYPE.equals(cls)) {
                return Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Boolean.TYPE.equals(cls)) {
                return false;
            }
            if (Double.TYPE.equals(cls)) {
                return false;
            }
            if (Float.TYPE.equals(cls)) {
                return Double.TYPE.equals(toClass);
            }
            if (Character.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Short.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Byte.TYPE.equals(cls)) {
                return Short.TYPE.equals(toClass) || Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            return false;
        }
        return toClass.isAssignableFrom(cls);
    }

    public static Class<?> primitiveToWrapper(Class<?> cls) {
        Class<?> convertedClass = cls;
        if (cls != null && cls.isPrimitive()) {
            convertedClass = primitiveWrapperMap.get(cls);
        }
        return convertedClass;
    }

    public static Class<?> wrapperToPrimitive(Class<?> cls) {
        return wrapperPrimitiveMap.get(cls);
    }

    public static Class<?> classForName(String name, boolean initialize, ClassLoader classLoader) throws ClassNotFoundException {
        if (primitiveNameMap.containsKey(name)) {
            return primitiveNameMap.get(name);
        }
        return Class.forName(name, initialize, classLoader);
    }

    private static boolean containsTypeVariable(java.lang.reflect.Type type) {
        if (type instanceof TypeVariable) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return Arrays.stream(((ParameterizedType)type).getActualTypeArguments()).anyMatch(ExtractionUtils::containsTypeVariable);
        }
        if (type instanceof GenericArrayType) {
            return ExtractionUtils.containsTypeVariable(((GenericArrayType)type).getGenericComponentType());
        }
        return false;
    }

    private ExtractionUtils() {
    }

    static {
        primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperMap.put(Character.TYPE, Character.class);
        primitiveWrapperMap.put(Short.TYPE, Short.class);
        primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperMap.put(Long.TYPE, Long.class);
        primitiveWrapperMap.put(Double.TYPE, Double.class);
        primitiveWrapperMap.put(Float.TYPE, Float.class);
        primitiveWrapperMap.put(Void.TYPE, Void.TYPE);
        wrapperPrimitiveMap = new HashMap();
        for (Class<?> primitiveClass : primitiveWrapperMap.keySet()) {
            Class<?> wrapperClass;
            if (primitiveClass.equals(wrapperClass = primitiveWrapperMap.get(primitiveClass))) continue;
            wrapperPrimitiveMap.put(wrapperClass, primitiveClass);
        }
        primitiveNameMap = new HashMap();
        primitiveNameMap.put("int", Integer.TYPE);
        primitiveNameMap.put("boolean", Boolean.TYPE);
        primitiveNameMap.put("float", Float.TYPE);
        primitiveNameMap.put("long", Long.TYPE);
        primitiveNameMap.put("short", Short.TYPE);
        primitiveNameMap.put("byte", Byte.TYPE);
        primitiveNameMap.put("double", Double.TYPE);
        primitiveNameMap.put("char", Character.TYPE);
        primitiveNameMap.put("void", Void.TYPE);
    }

    @Internal
    public static enum Autoboxing {
        NONE,
        JVM,
        STRICT;

    }

    private static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final java.lang.reflect.Type[] actualTypeArguments;
        private final java.lang.reflect.Type rawType;
        private final java.lang.reflect.Type ownerType;

        public ParameterizedTypeImpl(java.lang.reflect.Type[] actualTypeArguments, java.lang.reflect.Type rawType, java.lang.reflect.Type ownerType) {
            this.actualTypeArguments = actualTypeArguments;
            this.rawType = rawType;
            this.ownerType = ownerType;
        }

        @Override
        public java.lang.reflect.Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        @Override
        public java.lang.reflect.Type getRawType() {
            return this.rawType;
        }

        @Override
        public java.lang.reflect.Type getOwnerType() {
            return this.ownerType;
        }

        public String toString() {
            List actualTypes = Arrays.stream(this.getActualTypeArguments()).map(java.lang.reflect.Type::getTypeName).collect(Collectors.toList());
            return this.getRawType().getTypeName() + "<" + String.join((CharSequence)", ", actualTypes) + ">";
        }
    }

    private static class GenericArrayTypeImpl
    implements GenericArrayType {
        private final java.lang.reflect.Type genericComponentType;

        public GenericArrayTypeImpl(java.lang.reflect.Type genericComponentType) {
            this.genericComponentType = genericComponentType;
        }

        @Override
        public java.lang.reflect.Type getGenericComponentType() {
            return this.genericComponentType;
        }

        @Override
        public String getTypeName() {
            return this.getGenericComponentType().getTypeName() + "[]";
        }
    }

    @Internal
    public static class AssigningConstructor {
        public final Constructor<?> constructor;
        public final List<String> parameterNames;

        private AssigningConstructor(Constructor<?> constructor, List<String> parameterNames) {
            this.constructor = constructor;
            this.parameterNames = parameterNames;
        }
    }

    private static class ParameterExtractor
    extends ClassVisitor {
        private static final int OPCODE = 589824;
        private final String methodDescriptor;
        private final Map<Integer, String> parameterNamesWithIndex = new TreeMap<Integer, String>();

        ParameterExtractor(Constructor<?> constructor) {
            super(589824);
            this.methodDescriptor = Type.getConstructorDescriptor(constructor);
        }

        ParameterExtractor(Method method) {
            super(589824);
            this.methodDescriptor = Type.getMethodDescriptor((Method)method);
        }

        List<String> getParameterNames() {
            return new ArrayList<String>(this.parameterNamesWithIndex.values());
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (descriptor.equals(this.methodDescriptor)) {
                return new MethodVisitor(589824){

                    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
                        parameterNamesWithIndex.put(index, name);
                    }
                };
            }
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }
    }
}

