/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.functions.co.CoMapFunction;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.StreamMap;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.co.CoStreamMap;
import org.apache.flink.streaming.runtime.tasks.OneInputStreamTask;
import org.apache.flink.streaming.runtime.tasks.OneInputStreamTaskTestHarness;
import org.apache.flink.streaming.runtime.tasks.StreamMockEnvironment;
import org.apache.flink.streaming.runtime.tasks.TwoInputStreamTask;
import org.apache.flink.streaming.runtime.tasks.TwoInputStreamTaskTestHarness;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;

@Timeout(value=10L, unit=TimeUnit.SECONDS)
class StreamTaskCancellationBarrierTest {
    StreamTaskCancellationBarrierTest() {
    }

    @Test
    void testDeclineCallOnCancelBarrierOneInput() throws Exception {
        OneInputStreamTaskTestHarness testHarness = new OneInputStreamTaskTestHarness(OneInputStreamTask::new, 1, 2, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO);
        testHarness.setupOutputForSingletonOperatorChain();
        StreamConfig streamConfig = testHarness.getStreamConfig();
        StreamMap mapOperator = new StreamMap((MapFunction)new IdentityMap());
        streamConfig.setStreamOperator((StreamOperator)mapOperator);
        streamConfig.setOperatorID(new OperatorID());
        StreamMockEnvironment environment = (StreamMockEnvironment)Mockito.spy((Object)testHarness.createEnvironment());
        testHarness.invoke(environment);
        testHarness.waitForTaskRunning();
        testHarness.processEvent((AbstractEvent)new CancelCheckpointMarker(2L), 0, 1);
        testHarness.processEvent((AbstractEvent)new CancelCheckpointMarker(2L), 0, 0);
        testHarness.waitForInputProcessing();
        ((StreamMockEnvironment)Mockito.verify((Object)environment, (VerificationMode)Mockito.times((int)1))).declineCheckpoint(Mockito.eq((long)2L), (CheckpointException)MockitoHamcrest.argThat((Matcher)new CheckpointExceptionMatcher(CheckpointFailureReason.CHECKPOINT_DECLINED_ON_CANCELLATION_BARRIER)));
        Object result = testHarness.getOutput().poll();
        ((ObjectAssert)Assertions.assertThat((Object)result).as("nothing emitted", new Object[0])).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)result).as("wrong type emitted", new Object[0])).isInstanceOf(CancelCheckpointMarker.class);
        ((AbstractLongAssert)Assertions.assertThat((long)((CancelCheckpointMarker)result).getCheckpointId()).as("wrong checkpoint id", new Object[0])).isEqualTo(2L);
        testHarness.endInput();
        testHarness.waitForTaskCompletion();
    }

    @Test
    void testDeclineCallOnCancelBarrierTwoInputs() throws Exception {
        TwoInputStreamTaskTestHarness testHarness = new TwoInputStreamTaskTestHarness(TwoInputStreamTask::new, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO);
        testHarness.setupOutputForSingletonOperatorChain();
        StreamConfig streamConfig = testHarness.getStreamConfig();
        CoStreamMap op = new CoStreamMap((CoMapFunction)new UnionCoMap());
        streamConfig.setStreamOperator((StreamOperator)op);
        streamConfig.setOperatorID(new OperatorID());
        StreamMockEnvironment environment = (StreamMockEnvironment)Mockito.spy((Object)testHarness.createEnvironment());
        testHarness.invoke(environment);
        testHarness.waitForTaskRunning();
        testHarness.processEvent((AbstractEvent)new CancelCheckpointMarker(2L), 0, 0);
        testHarness.processEvent((AbstractEvent)new CancelCheckpointMarker(2L), 1, 0);
        testHarness.waitForInputProcessing();
        ((StreamMockEnvironment)Mockito.verify((Object)environment, (VerificationMode)Mockito.times((int)1))).declineCheckpoint(Mockito.eq((long)2L), (CheckpointException)MockitoHamcrest.argThat((Matcher)new CheckpointExceptionMatcher(CheckpointFailureReason.CHECKPOINT_DECLINED_ON_CANCELLATION_BARRIER)));
        Object result = testHarness.getOutput().poll();
        ((ObjectAssert)Assertions.assertThat((Object)result).as("nothing emitted", new Object[0])).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)result).as("wrong type emitted", new Object[0])).isInstanceOf(CancelCheckpointMarker.class);
        ((AbstractLongAssert)Assertions.assertThat((long)((CancelCheckpointMarker)result).getCheckpointId()).as("wrong checkpoint id", new Object[0])).isEqualTo(2L);
        testHarness.endInput();
        testHarness.waitForTaskCompletion();
    }

    private static class IdentityMap
    implements MapFunction<String, String> {
        private static final long serialVersionUID = 1L;

        private IdentityMap() {
        }

        public String map(String value) throws Exception {
            return value;
        }
    }

    private static class CheckpointExceptionMatcher
    extends BaseMatcher<CheckpointException> {
        private final CheckpointFailureReason failureReason;

        private CheckpointExceptionMatcher(CheckpointFailureReason failureReason) {
            this.failureReason = failureReason;
        }

        public boolean matches(Object o) {
            return o != null && o.getClass() == CheckpointException.class && ((CheckpointException)o).getCheckpointFailureReason().equals((Object)this.failureReason);
        }

        public void describeTo(Description description) {
            description.appendText("CheckpointException - reason = " + this.failureReason);
        }
    }

    private static class UnionCoMap
    implements CoMapFunction<String, String, String> {
        private static final long serialVersionUID = 1L;

        private UnionCoMap() {
        }

        public String map1(String value) throws Exception {
            return value;
        }

        public String map2(String value) throws Exception {
            return value;
        }
    }
}

