/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.time.Duration;
import java.util.Collection;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichAggregateFunction;
import org.apache.flink.api.common.functions.RichReduceFunction;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.windowing.AllWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.ProcessAllWindowFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.windowing.assigners.EventTimeSessionWindows;
import org.apache.flink.streaming.api.windowing.assigners.SlidingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.SlidingProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.TumblingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.TumblingProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.CountEvictor;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.evictors.TimeEvictor;
import org.apache.flink.streaming.api.windowing.triggers.CountTrigger;
import org.apache.flink.streaming.api.windowing.triggers.EventTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.ProcessingTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.runtime.operators.windowing.EvictingWindowOperatorFactory;
import org.apache.flink.streaming.runtime.operators.windowing.WindowOperatorFactory;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.util.Collector;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AllWindowTranslationTest {
    AllWindowTranslationTest() {
    }

    @Test
    void testReduceWithRichReducerFails() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        Assertions.assertThatThrownBy(() -> this.lambda$testReduceWithRichReducerFails$0((DataStream)source)).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testAggregateWithRichFunctionFails() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        Assertions.assertThatThrownBy(() -> AllWindowTranslationTest.lambda$testAggregateWithRichFunctionFails$1((DataStream)source)).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testMergingAssignerWithNonMergingTriggerFails() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> env.fromData((Object[])new String[]{"Hello", "Ciao"}).windowAll((WindowAssigner)EventTimeSessionWindows.withGap((Duration)Duration.ofSeconds(5L))).trigger((Trigger)new Trigger<String, TimeWindow>(){
            private static final long serialVersionUID = 6558046711583024443L;

            public TriggerResult onElement(String element, long timestamp, TimeWindow window, Trigger.TriggerContext ctx) throws Exception {
                return null;
            }

            public TriggerResult onProcessingTime(long time, TimeWindow window, Trigger.TriggerContext ctx) throws Exception {
                return null;
            }

            public TriggerResult onEventTime(long time, TimeWindow window, Trigger.TriggerContext ctx) throws Exception {
                return null;
            }

            public boolean canMerge() {
                return false;
            }

            public void clear(TimeWindow window, Trigger.TriggerContext ctx) throws Exception {
            }
        })).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("A merging window assigner cannot be used with a trigger that does not support merging");
    }

    @Test
    void testMergingWindowsWithEvictor() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)EventTimeSessionWindows.withGap((Duration)Duration.ofSeconds(5L))).evictor((Evictor)CountEvictor.of((long)5L)).process((ProcessAllWindowFunction)new TestProcessAllWindowFunction());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(WindowOperatorFactory.class);
        WindowOperatorFactory winOperator = (WindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(EventTimeTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(EventTimeSessionWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(ListStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testReduceEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofMillis(100L))).reduce((ReduceFunction)new DummyReducer());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(WindowOperatorFactory.class);
        WindowOperatorFactory winOperator = (WindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(EventTimeTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(SlidingEventTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(ReducingStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testReduceProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingProcessingTimeWindows.of((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofMillis(100L))).reduce((ReduceFunction)new DummyReducer());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(WindowOperatorFactory.class);
        WindowOperatorFactory winOperator = (WindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(ProcessingTimeTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(SlidingProcessingTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(ReducingStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testReduceWithWindowFunctionEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Duration)Duration.ofSeconds(1L))).reduce((ReduceFunction)reducer, (AllWindowFunction)new AllWindowFunction<Tuple2<String, Integer>, Tuple3<String, String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple3<String, String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect((Object)new Tuple3((Object)((String)in.f0), (Object)((String)in.f0), (Object)((Integer)in.f1)));
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(WindowOperatorFactory.class);
        WindowOperatorFactory winOperator = (WindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(EventTimeTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(TumblingEventTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(ReducingStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testReduceWithWindowFunctionProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window = source.windowAll((WindowAssigner)TumblingProcessingTimeWindows.of((Duration)Duration.ofSeconds(1L))).reduce((ReduceFunction)new DummyReducer(), (AllWindowFunction)new AllWindowFunction<Tuple2<String, Integer>, Tuple3<String, String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple3<String, String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect((Object)new Tuple3((Object)((String)in.f0), (Object)((String)in.f0), (Object)((Integer)in.f1)));
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(WindowOperatorFactory.class);
        WindowOperatorFactory winOperator = (WindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(ProcessingTimeTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(TumblingProcessingTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(ReducingStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testReduceWithProcessWindowFunctionEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Duration)Duration.ofSeconds(1L))).reduce((ReduceFunction)reducer, (ProcessAllWindowFunction)new ProcessAllWindowFunction<Tuple2<String, Integer>, Tuple3<String, String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void process(ProcessAllWindowFunction.Context ctx, Iterable<Tuple2<String, Integer>> values, Collector<Tuple3<String, String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect((Object)new Tuple3((Object)((String)in.f0), (Object)((String)in.f0), (Object)((Integer)in.f1)));
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(WindowOperatorFactory.class);
        WindowOperatorFactory winOperator = (WindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(EventTimeTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(TumblingEventTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(ReducingStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testReduceWithProcessWindowFunctionProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window = source.windowAll((WindowAssigner)TumblingProcessingTimeWindows.of((Duration)Duration.ofSeconds(1L))).reduce((ReduceFunction)new DummyReducer(), (ProcessAllWindowFunction)new ProcessAllWindowFunction<Tuple2<String, Integer>, Tuple3<String, String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void process(ProcessAllWindowFunction.Context ctx, Iterable<Tuple2<String, Integer>> values, Collector<Tuple3<String, String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect((Object)new Tuple3((Object)((String)in.f0), (Object)((String)in.f0), (Object)((Integer)in.f1)));
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(WindowOperatorFactory.class);
        WindowOperatorFactory winOperator = (WindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(ProcessingTimeTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(TumblingProcessingTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(ReducingStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testReduceWithEvictorAndProcessFunction() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofMillis(100L))).evictor((Evictor)CountEvictor.of((long)100L)).reduce((ReduceFunction)reducer, (ProcessAllWindowFunction)new ProcessAllWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, TimeWindow>(){

            public void process(ProcessAllWindowFunction.Context context, Iterable<Tuple2<String, Integer>> elements, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : elements) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(EvictingWindowOperatorFactory.class);
        EvictingWindowOperatorFactory winOperator = (EvictingWindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(EventTimeTrigger.class);
        Assertions.assertThat((Object)winOperator.getEvictor()).isInstanceOf(CountEvictor.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(SlidingEventTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(ListStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testApplyWithPreReducerEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Duration)Duration.ofSeconds(1L))).reduce((ReduceFunction)reducer, (AllWindowFunction)new AllWindowFunction<Tuple2<String, Integer>, Tuple3<String, String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple3<String, String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect((Object)new Tuple3((Object)((String)in.f0), (Object)((String)in.f0), (Object)((Integer)in.f1)));
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(WindowOperatorFactory.class);
        WindowOperatorFactory winOperator = (WindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(EventTimeTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(TumblingEventTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(ReducingStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testAggregateEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofMillis(100L))).aggregate((AggregateFunction)new DummyAggregationFunction());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(WindowOperatorFactory.class);
        WindowOperatorFactory winOperator = (WindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(EventTimeTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(SlidingEventTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(AggregatingStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testAggregateProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingProcessingTimeWindows.of((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofMillis(100L))).aggregate((AggregateFunction)new DummyAggregationFunction());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(WindowOperatorFactory.class);
        WindowOperatorFactory winOperator = (WindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(ProcessingTimeTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(SlidingProcessingTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(AggregatingStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testAggregateWithWindowFunctionEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Duration)Duration.ofSeconds(1L))).aggregate((AggregateFunction)new DummyAggregationFunction(), (AllWindowFunction)new TestAllWindowFunction());
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(WindowOperatorFactory.class);
        WindowOperatorFactory winOperator = (WindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(EventTimeTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(TumblingEventTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(AggregatingStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testAggregateWithWindowFunctionProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window = source.windowAll((WindowAssigner)TumblingProcessingTimeWindows.of((Duration)Duration.ofSeconds(1L))).aggregate((AggregateFunction)new DummyAggregationFunction(), (AllWindowFunction)new TestAllWindowFunction());
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(WindowOperatorFactory.class);
        WindowOperatorFactory winOperator = (WindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(ProcessingTimeTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(TumblingProcessingTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(AggregatingStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testAggregateWithEvictor() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofMillis(100L))).evictor((Evictor)CountEvictor.of((long)100L)).aggregate((AggregateFunction)new DummyAggregationFunction());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(WindowOperatorFactory.class);
        WindowOperatorFactory winOperator = (WindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(EventTimeTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(SlidingEventTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(ListStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testAggregateWithEvictorAndProcessFunction() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofMillis(100L))).evictor((Evictor)CountEvictor.of((long)100L)).aggregate((AggregateFunction)new DummyAggregationFunction(), (ProcessAllWindowFunction)new ProcessAllWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, TimeWindow>(){

            public void process(ProcessAllWindowFunction.Context context, Iterable<Tuple2<String, Integer>> elements, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : elements) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(WindowOperatorFactory.class);
        WindowOperatorFactory winOperator = (WindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(EventTimeTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(SlidingEventTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(ListStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testProcessEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Duration)Duration.ofSeconds(1L))).process((ProcessAllWindowFunction)new ProcessAllWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void process(ProcessAllWindowFunction.Context ctx, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(WindowOperatorFactory.class);
        WindowOperatorFactory winOperator = (WindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(EventTimeTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(TumblingEventTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(ListStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testProcessProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)TumblingProcessingTimeWindows.of((Duration)Duration.ofSeconds(1L))).process((ProcessAllWindowFunction)new ProcessAllWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void process(ProcessAllWindowFunction.Context ctx, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(WindowOperatorFactory.class);
        WindowOperatorFactory winOperator = (WindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(ProcessingTimeTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(TumblingProcessingTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(ListStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testProcessWithEvictor() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Duration)Duration.ofSeconds(1L))).trigger((Trigger)CountTrigger.of((long)1L)).evictor((Evictor)TimeEvictor.of((Duration)Duration.ofMillis(100L))).process((ProcessAllWindowFunction)new ProcessAllWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void process(ProcessAllWindowFunction.Context ctx, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(EvictingWindowOperatorFactory.class);
        EvictingWindowOperatorFactory winOperator = (EvictingWindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(CountTrigger.class);
        Assertions.assertThat((Object)winOperator.getEvictor()).isInstanceOf(TimeEvictor.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(TumblingEventTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(ListStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testProcessWithCustomTrigger() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Duration)Duration.ofSeconds(1L))).trigger((Trigger)CountTrigger.of((long)1L)).process((ProcessAllWindowFunction)new ProcessAllWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void process(ProcessAllWindowFunction.Context ctx, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(WindowOperatorFactory.class);
        WindowOperatorFactory winOperator = (WindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(CountTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(TumblingEventTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(ListStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testApplyEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Duration)Duration.ofSeconds(1L))).apply((AllWindowFunction)new AllWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(WindowOperatorFactory.class);
        WindowOperatorFactory winOperator = (WindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(EventTimeTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(TumblingEventTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(ListStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testApplyProcessingTimeTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)TumblingProcessingTimeWindows.of((Duration)Duration.ofSeconds(1L))).apply((AllWindowFunction)new AllWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(WindowOperatorFactory.class);
        WindowOperatorFactory winOperator = (WindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(ProcessingTimeTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(TumblingProcessingTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(ListStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testReduceWithCustomTrigger() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofMillis(100L))).trigger((Trigger)CountTrigger.of((long)1L)).reduce((ReduceFunction)reducer);
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(WindowOperatorFactory.class);
        WindowOperatorFactory winOperator = (WindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(CountTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(SlidingEventTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(ReducingStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testApplyWithCustomTrigger() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Duration)Duration.ofSeconds(1L))).trigger((Trigger)CountTrigger.of((long)1L)).apply((AllWindowFunction)new AllWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(WindowOperatorFactory.class);
        WindowOperatorFactory winOperator = (WindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(CountTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(TumblingEventTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(ListStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testReduceWithEvictor() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofMillis(100L))).evictor((Evictor)CountEvictor.of((long)100L)).reduce((ReduceFunction)reducer);
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(EvictingWindowOperatorFactory.class);
        EvictingWindowOperatorFactory winOperator = (EvictingWindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(EventTimeTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(SlidingEventTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getEvictor()).isInstanceOf(CountEvictor.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(ListStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    void testApplyWithEvictor() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromData((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Duration)Duration.ofSeconds(1L))).trigger((Trigger)CountTrigger.of((long)1L)).evictor((Evictor)TimeEvictor.of((Duration)Duration.ofMillis(100L))).apply((AllWindowFunction)new AllWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        StreamOperatorFactory operator = transform.getOperatorFactory();
        Assertions.assertThat((Object)operator).isInstanceOf(EvictingWindowOperatorFactory.class);
        EvictingWindowOperatorFactory winOperator = (EvictingWindowOperatorFactory)operator;
        Assertions.assertThat((Object)winOperator.getTrigger()).isInstanceOf(CountTrigger.class);
        Assertions.assertThat((Object)winOperator.getWindowAssigner()).isInstanceOf(TumblingEventTimeWindows.class);
        Assertions.assertThat((Object)winOperator.getEvictor()).isInstanceOf(TimeEvictor.class);
        Assertions.assertThat((Object)winOperator.getStateDescriptor()).isInstanceOf(ListStateDescriptor.class);
        AllWindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    private static <K, IN, OUT> void processElementAndEnsureOutput(OneInputStreamOperatorFactory<IN, OUT> operator, KeySelector<IN, K> keySelector, TypeInformation<K> keyType, IN element) throws Exception {
        KeyedOneInputStreamOperatorTestHarness testHarness = new KeyedOneInputStreamOperatorTestHarness(operator, keySelector, keyType);
        testHarness.open();
        testHarness.setProcessingTime(0L);
        testHarness.processWatermark(Long.MIN_VALUE);
        testHarness.processElement(new StreamRecord(element, 0L));
        testHarness.setProcessingTime(Long.MAX_VALUE);
        testHarness.processWatermark(Long.MAX_VALUE);
        Assertions.assertThat((Collection)testHarness.getOutput()).hasSizeGreaterThanOrEqualTo(3);
        testHarness.close();
    }

    private static /* synthetic */ void lambda$testAggregateWithRichFunctionFails$1(DataStream source) throws Throwable {
        source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofMillis(100L))).aggregate(new DummyRichAggregationFunction());
    }

    private /* synthetic */ void lambda$testReduceWithRichReducerFails$0(DataStream source) throws Throwable {
        source.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofMillis(100L))).reduce((ReduceFunction)new RichReduceFunction<Tuple2<String, Integer>>(){
            private static final long serialVersionUID = -6448847205314995812L;

            public Tuple2<String, Integer> reduce(Tuple2<String, Integer> value1, Tuple2<String, Integer> value2) {
                return null;
            }
        });
    }

    private static class TestProcessAllWindowFunction
    extends ProcessAllWindowFunction<Tuple2<String, Integer>, Tuple3<String, String, Integer>, TimeWindow> {
        private TestProcessAllWindowFunction() {
        }

        public void process(ProcessAllWindowFunction.Context ctx, Iterable<Tuple2<String, Integer>> values, Collector<Tuple3<String, String, Integer>> out) throws Exception {
            for (Tuple2<String, Integer> in : values) {
                out.collect((Object)new Tuple3((Object)((String)in.f0), (Object)((String)in.f0), (Object)((Integer)in.f1)));
            }
        }
    }

    private static class DummyReducer
    implements ReduceFunction<Tuple2<String, Integer>> {
        private static final long serialVersionUID = 1L;

        private DummyReducer() {
        }

        public Tuple2<String, Integer> reduce(Tuple2<String, Integer> value1, Tuple2<String, Integer> value2) throws Exception {
            return value1;
        }
    }

    private static class DummyAggregationFunction
    implements AggregateFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, Tuple2<String, Integer>> {
        private DummyAggregationFunction() {
        }

        public Tuple2<String, Integer> createAccumulator() {
            return new Tuple2((Object)"", (Object)0);
        }

        public Tuple2<String, Integer> add(Tuple2<String, Integer> value, Tuple2<String, Integer> accumulator) {
            accumulator.f0 = value.f0;
            accumulator.f1 = value.f1;
            return accumulator;
        }

        public Tuple2<String, Integer> getResult(Tuple2<String, Integer> accumulator) {
            return accumulator;
        }

        public Tuple2<String, Integer> merge(Tuple2<String, Integer> a, Tuple2<String, Integer> b) {
            return a;
        }
    }

    private static class TestAllWindowFunction
    implements AllWindowFunction<Tuple2<String, Integer>, Tuple3<String, String, Integer>, TimeWindow> {
        private TestAllWindowFunction() {
        }

        public void apply(TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple3<String, String, Integer>> out) throws Exception {
            for (Tuple2<String, Integer> in : values) {
                out.collect((Object)new Tuple3((Object)((String)in.f0), (Object)((String)in.f0), (Object)((Integer)in.f1)));
            }
        }
    }

    private static class DummyRichAggregationFunction<T>
    extends RichAggregateFunction<T, T, T> {
        private DummyRichAggregationFunction() {
        }

        public T createAccumulator() {
            return null;
        }

        public T add(T value, T accumulator) {
            return accumulator;
        }

        public T getResult(T accumulator) {
            return accumulator;
        }

        public T merge(T a, T b) {
            return a;
        }
    }
}

