/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import org.apache.flink.api.common.operators.ProcessingTimeService;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.testutils.DummyEnvironment;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.Input;
import org.apache.flink.streaming.api.operators.KeyContextHandler;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.StreamTaskStateInitializer;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.RecordProcessorUtils;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.StreamTaskITCase;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.streaming.util.MockOutput;
import org.apache.flink.streaming.util.MockStreamConfig;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.clock.Clock;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RecordProcessorUtilsTest {
    RecordProcessorUtilsTest() {
    }

    @Test
    void testGetRecordProcessor() throws Exception {
        TestOperator input1 = new TestOperator();
        TestKeyContextHandlerOperator input2 = new TestKeyContextHandlerOperator(true);
        TestKeyContextHandlerOperator input3 = new TestKeyContextHandlerOperator(false);
        RecordProcessorUtils.getRecordProcessor((Input)input1).accept((Object)new StreamRecord((Object)"test"));
        Assertions.assertThat((boolean)input1.setKeyContextElementCalled).isTrue();
        Assertions.assertThat((boolean)input1.processElementCalled).isTrue();
        RecordProcessorUtils.getRecordProcessor((Input)input2).accept((Object)new StreamRecord((Object)"test"));
        Assertions.assertThat((boolean)input2.setKeyContextElementCalled).isTrue();
        Assertions.assertThat((boolean)input2.processElementCalled).isTrue();
        RecordProcessorUtils.getRecordProcessor((Input)input3).accept((Object)new StreamRecord((Object)"test"));
        Assertions.assertThat((boolean)input3.setKeyContextElementCalled).isFalse();
        Assertions.assertThat((boolean)input3.processElementCalled).isTrue();
    }

    @Test
    void testGetRecordProcessor1() throws Exception {
        TestOperator operator1 = new TestOperator();
        TestKeyContextHandlerOperator operator2 = new TestKeyContextHandlerOperator(true, true);
        TestKeyContextHandlerOperator operator3 = new TestKeyContextHandlerOperator(false, true);
        RecordProcessorUtils.getRecordProcessor1((TwoInputStreamOperator)operator1).accept((Object)new StreamRecord((Object)"test"));
        Assertions.assertThat((boolean)operator1.setKeyContextElement1Called).isTrue();
        Assertions.assertThat((boolean)operator1.processElement1Called).isTrue();
        RecordProcessorUtils.getRecordProcessor1((TwoInputStreamOperator)operator2).accept((Object)new StreamRecord((Object)"test"));
        Assertions.assertThat((boolean)operator2.setKeyContextElement1Called).isTrue();
        Assertions.assertThat((boolean)operator2.processElement1Called).isTrue();
        RecordProcessorUtils.getRecordProcessor1((TwoInputStreamOperator)operator3).accept((Object)new StreamRecord((Object)"test"));
        Assertions.assertThat((boolean)operator3.setKeyContextElement1Called).isFalse();
        Assertions.assertThat((boolean)operator3.processElement1Called).isTrue();
    }

    @Test
    void testGetRecordProcessor2() throws Exception {
        TestOperator operator1 = new TestOperator();
        TestKeyContextHandlerOperator operator2 = new TestKeyContextHandlerOperator(true, true);
        TestKeyContextHandlerOperator operator3 = new TestKeyContextHandlerOperator(true, false);
        RecordProcessorUtils.getRecordProcessor2((TwoInputStreamOperator)operator1).accept((Object)new StreamRecord((Object)"test"));
        Assertions.assertThat((boolean)operator1.setKeyContextElement2Called).isTrue();
        Assertions.assertThat((boolean)operator1.processElement2Called).isTrue();
        RecordProcessorUtils.getRecordProcessor2((TwoInputStreamOperator)operator2).accept((Object)new StreamRecord((Object)"test"));
        Assertions.assertThat((boolean)operator2.setKeyContextElement2Called).isTrue();
        Assertions.assertThat((boolean)operator2.processElement2Called).isTrue();
        RecordProcessorUtils.getRecordProcessor2((TwoInputStreamOperator)operator3).accept((Object)new StreamRecord((Object)"test"));
        Assertions.assertThat((boolean)operator3.setKeyContextElement2Called).isFalse();
        Assertions.assertThat((boolean)operator3.processElement2Called).isTrue();
    }

    @Test
    void testOverrideSetKeyContextElementForOneInputStreamOperator() throws Exception {
        NoOverrideOneInputStreamOperator noOverride = new NoOverrideOneInputStreamOperator();
        RecordProcessorUtils.getRecordProcessor((Input)noOverride).accept((Object)new StreamRecord((Object)"test"));
        Assertions.assertThat((boolean)noOverride.setCurrentKeyCalled).isFalse();
        OverrideSetKeyContextOneInputStreamOperator overrideSetKeyContext = new OverrideSetKeyContextOneInputStreamOperator();
        RecordProcessorUtils.getRecordProcessor((Input)overrideSetKeyContext).accept((Object)new StreamRecord((Object)"test"));
        Assertions.assertThat((boolean)overrideSetKeyContext.setKeyContextElementCalled).isTrue();
        OverrideSetKeyContext1OneInputStreamOperator overrideSetKeyContext1 = new OverrideSetKeyContext1OneInputStreamOperator();
        RecordProcessorUtils.getRecordProcessor((Input)overrideSetKeyContext1).accept((Object)new StreamRecord((Object)"test"));
        Assertions.assertThat((boolean)overrideSetKeyContext1.setKeyContextElement1Called).isTrue();
    }

    @Test
    void testOverrideSetKeyContextElementForTwoInputStreamOperator() throws Exception {
        NoOverrideTwoInputStreamOperator noOverride = new NoOverrideTwoInputStreamOperator();
        RecordProcessorUtils.getRecordProcessor1((TwoInputStreamOperator)noOverride).accept((Object)new StreamRecord((Object)"test"));
        RecordProcessorUtils.getRecordProcessor2((TwoInputStreamOperator)noOverride).accept((Object)new StreamRecord((Object)"test"));
        Assertions.assertThat((boolean)noOverride.setCurrentKeyCalled).isFalse();
        OverrideSetKeyContext1AndSetKeyContext2TwoInputStreamOperator override = new OverrideSetKeyContext1AndSetKeyContext2TwoInputStreamOperator();
        RecordProcessorUtils.getRecordProcessor1((TwoInputStreamOperator)override).accept((Object)new StreamRecord((Object)"test"));
        RecordProcessorUtils.getRecordProcessor2((TwoInputStreamOperator)override).accept((Object)new StreamRecord((Object)"test"));
        Assertions.assertThat((boolean)override.setKeyContextElement1Called).isTrue();
        Assertions.assertThat((boolean)override.setKeyContextElement2Called).isTrue();
    }

    private static class TestOperator
    implements Input<String>,
    TwoInputStreamOperator<String, String, String> {
        boolean setKeyContextElementCalled = false;
        boolean processElementCalled = false;
        boolean setKeyContextElement1Called = false;
        boolean processElement1Called = false;
        boolean setKeyContextElement2Called = false;
        boolean processElement2Called = false;

        private TestOperator() {
        }

        public void processElement(StreamRecord<String> element) throws Exception {
            this.processElementCalled = true;
        }

        public void processWatermark(Watermark mark) throws Exception {
        }

        public void processWatermarkStatus(WatermarkStatus watermarkStatus) throws Exception {
        }

        public void processLatencyMarker(LatencyMarker latencyMarker) throws Exception {
        }

        public void setKeyContextElement(StreamRecord<String> record) throws Exception {
            this.setKeyContextElementCalled = true;
        }

        public void notifyCheckpointComplete(long checkpointId) throws Exception {
        }

        public void setCurrentKey(Object key) {
        }

        public Object getCurrentKey() {
            return null;
        }

        public void open() throws Exception {
        }

        public void finish() throws Exception {
        }

        public void close() throws Exception {
        }

        public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        }

        public OperatorSnapshotFutures snapshotState(long checkpointId, long timestamp, CheckpointOptions checkpointOptions, CheckpointStreamFactory storageLocation) throws Exception {
            return null;
        }

        public void initializeState(StreamTaskStateInitializer streamTaskStateManager) throws Exception {
        }

        public OperatorMetricGroup getMetricGroup() {
            return null;
        }

        public OperatorID getOperatorID() {
            return null;
        }

        public void setKeyContextElement1(StreamRecord<?> record) throws Exception {
            this.setKeyContextElement1Called = true;
        }

        public void setKeyContextElement2(StreamRecord<?> record) throws Exception {
            this.setKeyContextElement2Called = true;
        }

        public void processElement1(StreamRecord<String> element) throws Exception {
            this.processElement1Called = true;
        }

        public void processElement2(StreamRecord<String> element) throws Exception {
            this.processElement2Called = true;
        }

        public void processWatermark1(Watermark mark) throws Exception {
        }

        public void processWatermark2(Watermark mark) throws Exception {
        }

        public void processLatencyMarker1(LatencyMarker latencyMarker) throws Exception {
        }

        public void processLatencyMarker2(LatencyMarker latencyMarker) throws Exception {
        }

        public void processWatermarkStatus1(WatermarkStatus watermarkStatus) throws Exception {
        }

        public void processWatermarkStatus2(WatermarkStatus watermarkStatus) throws Exception {
        }
    }

    private static class TestKeyContextHandlerOperator
    extends TestOperator
    implements KeyContextHandler {
        private final boolean hasKeyContext1;
        private final boolean hasKeyContext2;

        TestKeyContextHandlerOperator(boolean hasKeyContext) {
            this.hasKeyContext1 = hasKeyContext;
            this.hasKeyContext2 = true;
        }

        TestKeyContextHandlerOperator(boolean hasKeyContext1, boolean hasKeyContext2) {
            this.hasKeyContext1 = hasKeyContext1;
            this.hasKeyContext2 = hasKeyContext2;
        }

        public boolean hasKeyContext() {
            return this.hasKeyContext1;
        }

        public boolean hasKeyContext1() {
            return this.hasKeyContext1;
        }

        public boolean hasKeyContext2() {
            return this.hasKeyContext2;
        }
    }

    private static class NoOverrideOneInputStreamOperator
    extends NoOverrideOperator
    implements OneInputStreamOperator<String, String> {
        NoOverrideOneInputStreamOperator() throws Exception {
        }

        public void processElement(StreamRecord<String> element) throws Exception {
        }
    }

    private static class OverrideSetKeyContextOneInputStreamOperator
    extends NoOverrideOneInputStreamOperator {
        boolean setKeyContextElementCalled = false;

        OverrideSetKeyContextOneInputStreamOperator() throws Exception {
        }

        public void setKeyContextElement(StreamRecord<String> record) throws Exception {
            this.setKeyContextElementCalled = true;
        }
    }

    private static class OverrideSetKeyContext1OneInputStreamOperator
    extends NoOverrideOneInputStreamOperator {
        boolean setKeyContextElement1Called = false;

        OverrideSetKeyContext1OneInputStreamOperator() throws Exception {
        }

        public void setKeyContextElement1(StreamRecord record) throws Exception {
            this.setKeyContextElement1Called = true;
        }
    }

    private static class NoOverrideTwoInputStreamOperator
    extends NoOverrideOperator
    implements TwoInputStreamOperator<String, String, String> {
        NoOverrideTwoInputStreamOperator() throws Exception {
        }

        public void processElement1(StreamRecord<String> element) throws Exception {
        }

        public void processElement2(StreamRecord<String> element) throws Exception {
        }
    }

    private static class OverrideSetKeyContext1AndSetKeyContext2TwoInputStreamOperator
    extends NoOverrideTwoInputStreamOperator {
        boolean setKeyContextElement1Called = false;
        boolean setKeyContextElement2Called = false;

        OverrideSetKeyContext1AndSetKeyContext2TwoInputStreamOperator() throws Exception {
        }

        public void setKeyContextElement1(StreamRecord record) throws Exception {
            this.setKeyContextElement1Called = true;
        }

        public void setKeyContextElement2(StreamRecord record) throws Exception {
            this.setKeyContextElement2Called = true;
        }
    }

    private static class NoOpProcessingTimeService
    implements ProcessingTimeService {
        private NoOpProcessingTimeService() {
        }

        public Clock getClock() {
            return null;
        }

        public ScheduledFuture<?> scheduleAtFixedRate(ProcessingTimeService.ProcessingTimeCallback callback, long initialDelay, long period) {
            return null;
        }

        public ScheduledFuture<?> scheduleWithFixedDelay(ProcessingTimeService.ProcessingTimeCallback callback, long initialDelay, long period) {
            return null;
        }

        public CompletableFuture<Void> quiesce() {
            return null;
        }

        public ScheduledFuture<?> registerTimer(long timestamp, ProcessingTimeService.ProcessingTimeCallback target) {
            return null;
        }
    }

    private static class NoOverrideOperator
    extends AbstractStreamOperator<String> {
        boolean setCurrentKeyCalled = false;

        NoOverrideOperator() throws Exception {
            super(new StreamOperatorParameters(new StreamTaskITCase.NoOpStreamTask((Environment)new DummyEnvironment()), (StreamConfig)new MockStreamConfig(new Configuration(), 1), (Output)new MockOutput(new ArrayList()), () -> new NoOpProcessingTimeService(), null, null));
            Configuration configuration = new Configuration();
            KeySelector & Serializable keySelector = (KeySelector & Serializable)x -> x;
            InstantiationUtil.writeObjectToConfig((Object)keySelector, (Configuration)configuration, (String)"statePartitioner0");
            InstantiationUtil.writeObjectToConfig((Object)keySelector, (Configuration)configuration, (String)"statePartitioner1");
        }

        public boolean hasKeyContext1() {
            return false;
        }

        public boolean hasKeyContext2() {
            return false;
        }

        public void setCurrentKey(Object key) {
            this.setCurrentKeyCalled = true;
        }
    }
}

