/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb.sstmerge;

import java.io.Serializable;
import java.time.Duration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.state.rocksdb.sstmerge.RocksDBManualCompactionOptions;

public class RocksDBManualCompactionConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final long minInterval;
    public final int maxManualCompactions;
    public final MemorySize maxFileSizeToCompact;
    public final int minFilesToCompact;
    public final int maxFilesToCompact;
    public final MemorySize maxOutputFileSize;
    public final int maxAutoCompactions;

    public RocksDBManualCompactionConfig(long periodMs, int maxManualCompactions, MemorySize maxFileSizeToCompact, int minFilesToCompact, int maxFilesToCompact, MemorySize maxOutputFileSize, int maxAutoCompactions) {
        this.minInterval = periodMs;
        this.maxManualCompactions = maxManualCompactions;
        this.maxFileSizeToCompact = maxFileSizeToCompact;
        this.minFilesToCompact = minFilesToCompact;
        this.maxFilesToCompact = maxFilesToCompact;
        this.maxOutputFileSize = maxOutputFileSize;
        this.maxAutoCompactions = maxAutoCompactions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RocksDBManualCompactionConfig from(ReadableConfig config) {
        return RocksDBManualCompactionConfig.builder().setMinInterval(((Duration)config.get(RocksDBManualCompactionOptions.MIN_INTERVAL)).toMillis()).setMaxParallelCompactions((Integer)config.get(RocksDBManualCompactionOptions.MAX_PARALLEL_COMPACTIONS)).setMaxFileSizeToCompact((MemorySize)config.get(RocksDBManualCompactionOptions.MAX_FILE_SIZE_TO_COMPACT)).setMaxFilesToCompact((Integer)config.get(RocksDBManualCompactionOptions.MAX_FILES_TO_COMPACT)).setMinFilesToCompact((Integer)config.get(RocksDBManualCompactionOptions.MIN_FILES_TO_COMPACT)).setMaxOutputFileSize((MemorySize)config.get(RocksDBManualCompactionOptions.MAX_OUTPUT_FILE_SIZE)).setMaxAutoCompactions((Integer)config.get(RocksDBManualCompactionOptions.MAX_AUTO_COMPACTIONS)).build();
    }

    public static RocksDBManualCompactionConfig getDefault() {
        return RocksDBManualCompactionConfig.builder().build();
    }

    public String toString() {
        return "RocksDBManualCompactionConfig{minInterval=" + this.minInterval + ", maxManualCompactions=" + this.maxManualCompactions + ", maxFileSizeToCompact=" + this.maxFileSizeToCompact + ", minFilesToCompact=" + this.minFilesToCompact + ", maxFilesToCompact=" + this.maxFilesToCompact + ", maxOutputFileSize=" + this.maxOutputFileSize + ", maxAutoCompactions=" + this.maxAutoCompactions + "}";
    }

    public static class Builder {
        private long minInterval = ((Duration)RocksDBManualCompactionOptions.MIN_INTERVAL.defaultValue()).toMillis();
        private int maxParallelCompactions = (Integer)RocksDBManualCompactionOptions.MAX_PARALLEL_COMPACTIONS.defaultValue();
        private MemorySize maxFileSizeToCompact = (MemorySize)RocksDBManualCompactionOptions.MAX_FILE_SIZE_TO_COMPACT.defaultValue();
        private int minFilesToCompact = (Integer)RocksDBManualCompactionOptions.MIN_FILES_TO_COMPACT.defaultValue();
        private int maxFilesToCompact = (Integer)RocksDBManualCompactionOptions.MAX_FILES_TO_COMPACT.defaultValue();
        private MemorySize maxOutputFileSize = (MemorySize)RocksDBManualCompactionOptions.MAX_OUTPUT_FILE_SIZE.defaultValue();
        private int maxAutoCompactions = (Integer)RocksDBManualCompactionOptions.MAX_AUTO_COMPACTIONS.defaultValue();

        public Builder setMinInterval(long minInterval) {
            this.minInterval = minInterval;
            return this;
        }

        public Builder setMaxParallelCompactions(int maxParallelCompactions) {
            this.maxParallelCompactions = maxParallelCompactions;
            return this;
        }

        public Builder setMaxFileSizeToCompact(MemorySize maxFileSizeToCompact) {
            this.maxFileSizeToCompact = maxFileSizeToCompact;
            return this;
        }

        public Builder setMinFilesToCompact(int minFilesToCompact) {
            this.minFilesToCompact = minFilesToCompact;
            return this;
        }

        public Builder setMaxFilesToCompact(int maxFilesToCompact) {
            this.maxFilesToCompact = maxFilesToCompact;
            return this;
        }

        public Builder setMaxOutputFileSize(MemorySize maxOutputFileSize) {
            this.maxOutputFileSize = maxOutputFileSize;
            return this;
        }

        public Builder setMaxAutoCompactions(int maxAutoCompactions) {
            this.maxAutoCompactions = maxAutoCompactions;
            return this;
        }

        public RocksDBManualCompactionConfig build() {
            return new RocksDBManualCompactionConfig(this.minInterval, this.maxParallelCompactions, this.maxFileSizeToCompact, this.minFilesToCompact, this.maxFilesToCompact, this.maxOutputFileSize, this.maxAutoCompactions);
        }
    }
}

