/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.fs.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;

public abstract class DoubleListLru<K, V>
implements Iterable<Tuple2<K, V>> {
    private Node head = null;
    private Node tail = null;
    private Node middle = null;
    private int size = 0;
    private int secondSize;
    private final HashMap<K, Node> map = new HashMap();

    abstract boolean isSafeToAddFirst(V var1);

    abstract void newNodeCreated(V var1, Node var2);

    abstract void addedToFirst(V var1);

    abstract void addedToSecond(V var1);

    abstract void removedFromFirst(V var1);

    abstract void removedFromSecond(V var1);

    abstract void movedToFirst(V var1);

    abstract void movedToSecond(V var1);

    abstract boolean nodeAccessedAtSecond(V var1);

    abstract void promotedToFirst(V var1);

    public void addFirst(K key, V value) {
        if (!this.isSafeToAddFirst(value)) {
            this.addSecond(key, value);
            return;
        }
        Node newNode = new Node(key, value);
        this.newNodeCreated(value, newNode);
        this.map.put(key, newNode);
        if (this.head == null) {
            this.head = this.tail = newNode;
        } else {
            newNode.next = this.head;
            this.head.prev = newNode;
            this.head = newNode;
        }
        newNode.isBeforeMiddle = true;
        ++this.size;
        this.addedToFirst(value);
    }

    public void moveMiddleBack() {
        if (this.middle != null) {
            this.middle.isBeforeMiddle = true;
            Object theValue = this.middle.value;
            this.middle = this.middle.next;
            --this.secondSize;
            this.movedToFirst(theValue);
        }
    }

    public void moveMiddleFront() {
        if (this.middle != null && this.middle.prev != null) {
            this.middle = this.middle.prev;
            this.middle.isBeforeMiddle = false;
            ++this.secondSize;
            this.movedToSecond(this.middle.value);
        } else if (this.middle == null && this.size > 0) {
            this.middle = this.tail;
            this.middle.isBeforeMiddle = false;
            ++this.secondSize;
            this.movedToSecond(this.middle.value);
        }
    }

    public void addSecond(K key, V value) {
        Node newNode = new Node(key, value);
        this.newNodeCreated(value, newNode);
        this.map.put(key, newNode);
        if (this.head == null) {
            this.tail = this.middle = newNode;
            this.head = this.middle;
        } else if (this.middle == null) {
            newNode.prev = this.tail;
            this.tail.next = newNode;
            this.tail = newNode;
            this.middle = newNode;
        } else {
            newNode.next = this.middle;
            newNode.prev = this.middle.prev;
            if (this.middle.prev != null) {
                this.middle.prev.next = newNode;
            } else {
                this.head = newNode;
            }
            this.middle.prev = newNode;
            this.middle = newNode;
        }
        newNode.isBeforeMiddle = false;
        ++this.secondSize;
        ++this.size;
        this.addedToSecond(value);
    }

    @VisibleForTesting
    V getMiddle() {
        return this.middle != null ? (V)this.middle.value : null;
    }

    public V get(K key, boolean affectOrder) {
        Node node = this.map.get(key);
        if (node == null) {
            return null;
        }
        if (!affectOrder) {
            return node.value;
        }
        this.accessNode(node);
        return node.value;
    }

    public V remove(K key) {
        Node node = this.map.get(key);
        if (node == null) {
            return null;
        }
        if (node == this.head || node == this.tail) {
            if (node == this.head) {
                this.head = node.next;
                if (this.head != null) {
                    this.head.prev = null;
                }
            }
            if (node == this.tail) {
                this.tail = node.prev;
                if (this.tail != null) {
                    this.tail.next = null;
                }
            }
        } else {
            node.prev.next = node.next;
            node.next.prev = node.prev;
        }
        if (node == this.middle) {
            this.middle = node.next;
        }
        this.map.remove(key);
        --this.size;
        if (node.isBeforeMiddle) {
            this.removedFromFirst(node.value);
        } else {
            --this.secondSize;
            this.removedFromSecond(node.value);
        }
        return node.value;
    }

    void accessNode(Node node) {
        if (node.isBeforeMiddle) {
            this.moveToFront(node);
        } else {
            this.moveToMiddle(node);
            if (this.nodeAccessedAtSecond(node.value) && this.isSafeToAddFirst(node.value)) {
                this.moveMiddleBack();
                this.moveToFront(node);
                this.promotedToFirst(node.value);
            }
        }
    }

    private void moveToFront(Node node) {
        assert (node.isBeforeMiddle);
        if (node == this.head) {
            return;
        }
        if (node == this.tail) {
            this.tail = node.prev;
            this.tail.next = null;
        } else {
            node.prev.next = node.next;
            node.next.prev = node.prev;
        }
        node.prev = null;
        node.next = this.head;
        this.head.prev = node;
        this.head = node;
    }

    private void moveToMiddle(Node node) {
        assert (!node.isBeforeMiddle);
        if (node == this.middle) {
            return;
        }
        if (node == this.tail) {
            this.tail = node.prev;
            this.tail.next = null;
        } else {
            node.prev.next = node.next;
            node.next.prev = node.prev;
        }
        node.next = this.middle;
        node.prev = this.middle.prev;
        if (this.middle.prev != null) {
            this.middle.prev.next = node;
        } else {
            this.head = node;
        }
        this.middle.prev = node;
        this.middle = node;
    }

    public int size() {
        return this.size;
    }

    public int getSecondSize() {
        return this.secondSize;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<Tuple2<K, V>> iterator() {
        return new LruIterator();
    }

    public Iterator<Tuple2<K, V>> descendingIterator() {
        return new DecendingLruIterator();
    }

    class Node {
        K key;
        V value;
        Node prev;
        Node next;
        boolean isBeforeMiddle;

        Node(K key, V value) {
            this.key = key;
            this.value = value;
            this.isBeforeMiddle = false;
        }
    }

    private class LruIterator
    implements Iterator<Tuple2<K, V>> {
        private Node current;

        private LruIterator() {
            this.current = DoubleListLru.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Tuple2<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Tuple2 entry = Tuple2.of(this.current.key, this.current.value);
            this.current = this.current.next;
            return entry;
        }
    }

    private class DecendingLruIterator
    implements Iterator<Tuple2<K, V>> {
        private Node current;

        private DecendingLruIterator() {
            this.current = DoubleListLru.this.tail;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Tuple2<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Tuple2 entry = Tuple2.of(this.current.key, this.current.value);
            this.current = this.current.prev;
            return entry;
        }
    }
}

