/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.fs.cache;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Semaphore;
import org.apache.flink.core.fs.ByteBufferReadable;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.state.forst.fs.cache.FileBasedCache;
import org.apache.flink.state.forst.fs.cache.FileCacheEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedDataInputStream
extends FSDataInputStream
implements ByteBufferReadable {
    private static final Logger LOG = LoggerFactory.getLogger(CachedDataInputStream.class);
    private final FileCacheEntry cacheEntry;
    private volatile FSDataInputStream fsdis;
    private volatile StreamStatus streamStatus;
    private volatile long position;
    private final FSDataInputStream originalStream;
    private Semaphore semaphore;
    private final FileBasedCache fileBasedCache;
    private boolean closed = false;

    public CachedDataInputStream(FileBasedCache fileBasedCache, FileCacheEntry cacheEntry, FSDataInputStream cacheStream, FSDataInputStream originalStream) {
        this.fileBasedCache = fileBasedCache;
        this.cacheEntry = cacheEntry;
        this.fsdis = cacheStream;
        this.originalStream = originalStream;
        this.streamStatus = StreamStatus.CACHED_OPEN;
        this.semaphore = new Semaphore(0);
        LOG.trace("Create CachedDataInputStream for {} with CACHED_OPEN", (Object)cacheEntry.cachePath);
    }

    public CachedDataInputStream(FileBasedCache fileBasedCache, FileCacheEntry cacheEntry, FSDataInputStream originalStream) {
        this.fileBasedCache = fileBasedCache;
        this.cacheEntry = cacheEntry;
        this.fsdis = null;
        this.originalStream = originalStream;
        this.streamStatus = StreamStatus.CACHED_CLOSED;
        this.semaphore = new Semaphore(0);
        LOG.trace("Create CachedDataInputStream for {} with CACHED_CLOSED", (Object)cacheEntry.cachePath);
    }

    private FSDataInputStream getStream() throws IOException {
        FSDataInputStream stream;
        if (FileBasedCache.isFlinkThread()) {
            this.cacheEntry.touch();
        }
        if ((stream = this.tryGetCacheStream()) != null) {
            this.fileBasedCache.incHitCounter();
            return stream;
        }
        if (this.streamStatus == StreamStatus.CACHED_CLOSED || this.streamStatus == StreamStatus.CACHED_CLOSING) {
            if (this.streamStatus == StreamStatus.CACHED_CLOSING) {
                try {
                    this.semaphore.acquire(1);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                this.originalStream.seek(this.position);
                this.position = -1L;
                LOG.trace("Stream {} status from {} to {}", new Object[]{this.cacheEntry.cachePath, this.streamStatus, StreamStatus.CACHED_CLOSED});
                this.streamStatus = StreamStatus.CACHED_CLOSED;
            }
            this.tryReopen();
            stream = this.tryGetCacheStream();
            if (stream != null) {
                this.fileBasedCache.incHitCounter();
                return stream;
            }
            this.fileBasedCache.incMissCounter();
            return this.originalStream;
        }
        if (this.streamStatus == StreamStatus.ORIGINAL) {
            this.fileBasedCache.incMissCounter();
            return this.originalStream;
        }
        if (this.streamStatus == StreamStatus.CACHED_OPEN && (stream = this.tryGetCacheStream()) != null) {
            this.fileBasedCache.incHitCounter();
            return stream;
        }
        this.fileBasedCache.incMissCounter();
        return this.originalStream;
    }

    private FSDataInputStream tryGetCacheStream() {
        if (this.streamStatus == StreamStatus.CACHED_OPEN && this.cacheEntry.tryRetain() > 0) {
            return this.fsdis;
        }
        return null;
    }

    private void tryReopen() {
        if (this.streamStatus == StreamStatus.CACHED_CLOSED && FileBasedCache.isFlinkThread()) {
            try {
                this.fsdis = this.cacheEntry.getCacheStream();
                if (this.fsdis != null) {
                    LOG.trace("Stream {} status from {} to {}", new Object[]{this.cacheEntry.cachePath, this.streamStatus, StreamStatus.CACHED_OPEN});
                    this.fsdis.seek(this.originalStream.getPos());
                    this.streamStatus = StreamStatus.CACHED_OPEN;
                    this.cacheEntry.release();
                }
            }
            catch (IOException e) {
                LOG.warn("Reopen stream error.", (Throwable)e);
            }
        }
    }

    synchronized void closeCachedStream() throws IOException {
        if (this.streamStatus == StreamStatus.CACHED_OPEN) {
            LOG.trace("Stream {} status from {} to {}", new Object[]{this.cacheEntry.cachePath, this.streamStatus, StreamStatus.CACHED_CLOSING});
            this.streamStatus = StreamStatus.CACHED_CLOSING;
            this.position = this.fsdis.getPos();
            this.fsdis.close();
            this.fsdis = null;
            this.semaphore.release(1);
        }
    }

    private void finish() {
        if (this.streamStatus == StreamStatus.CACHED_OPEN) {
            this.cacheEntry.release();
        }
    }

    public void seek(long desired) throws IOException {
        try {
            this.getStream().seek(desired);
        }
        finally {
            this.finish();
        }
    }

    public long getPos() throws IOException {
        try {
            long l = this.getStream().getPos();
            return l;
        }
        finally {
            this.finish();
        }
    }

    public int read() throws IOException {
        try {
            int n = this.getStream().read();
            return n;
        }
        finally {
            this.finish();
        }
    }

    public int read(byte[] b) throws IOException {
        try {
            int n = this.getStream().read(b);
            return n;
        }
        finally {
            this.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int n = this.getStream().read(b, off, len);
            return n;
        }
        finally {
            this.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long n) throws IOException {
        try {
            long l = this.getStream().skip(n);
            return l;
        }
        finally {
            this.finish();
        }
    }

    public int available() throws IOException {
        try {
            int n = this.getStream().available();
            return n;
        }
        finally {
            this.finish();
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.closeCachedStream();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void mark(int readlimit) {
        try {
            this.getStream().mark(readlimit);
        }
        catch (Exception e) {
            LOG.warn("Mark error.", (Throwable)e);
        }
        finally {
            this.finish();
        }
    }

    public void reset() throws IOException {
        try {
            this.getStream().reset();
        }
        finally {
            this.finish();
        }
    }

    public boolean markSupported() {
        try {
            boolean bl = this.getStream().markSupported();
            return bl;
        }
        catch (IOException e) {
            LOG.warn("MarkSupported error.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer bb) throws IOException {
        if (bb == null) {
            throw new NullPointerException();
        }
        if (bb.remaining() == 0) {
            return 0;
        }
        try {
            FSDataInputStream stream = this.getStream();
            int n = stream instanceof ByteBufferReadable ? ((ByteBufferReadable)stream).read(bb) : CachedDataInputStream.readFullyFromFSDataInputStream(stream, bb);
            return n;
        }
        finally {
            this.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(long position, ByteBuffer bb) throws IOException {
        try {
            FSDataInputStream stream = this.getStream();
            if (stream instanceof ByteBufferReadable) {
                int n = ((ByteBufferReadable)stream).read(position, bb);
                return n;
            }
            stream.seek(position);
            int n = CachedDataInputStream.readFullyFromFSDataInputStream(stream, bb);
            return n;
        }
        finally {
            this.finish();
        }
    }

    private static int readFullyFromFSDataInputStream(FSDataInputStream originalInputStream, ByteBuffer bb) throws IOException {
        int n;
        int c = originalInputStream.read();
        if (c == -1) {
            return -1;
        }
        bb.put((byte)c);
        int len = bb.remaining() + 1;
        for (n = 1; n < len && (c = originalInputStream.read()) != -1; ++n) {
            bb.put((byte)c);
        }
        return n;
    }

    static enum StreamStatus {
        CACHED_OPEN,
        CACHED_CLOSING,
        CACHED_CLOSED,
        ORIGINAL;

    }
}

