/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog.restore;

import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.InternalKeyContext;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.runtime.state.internal.InternalValueState;
import org.apache.flink.state.changelog.StateChangeOperation;
import org.apache.flink.state.changelog.restore.KvStateChangeApplier;

class ValueStateChangeApplier<K, N, T>
extends KvStateChangeApplier<K, N> {
    private final InternalValueState<K, N, T> state;

    protected ValueStateChangeApplier(InternalKeyContext<K> keyContext, InternalValueState<K, N, T> state) {
        super(keyContext);
        this.state = state;
    }

    @Override
    protected InternalKvState<K, N, ?> getState() {
        return this.state;
    }

    @Override
    protected void applyInternal(StateChangeOperation operation, DataInputView in) throws Exception {
        switch (operation) {
            case SET: {
                this.state.update(this.state.getValueSerializer().deserialize(in));
                break;
            }
            case CLEAR: {
                this.state.clear();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown state change operation: " + operation);
            }
        }
    }
}

