/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.rest.messages.job.JobDetailsInfo;
import org.apache.flink.state.api.utils.WaitingSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.legacy.FromElementsFunction;
import org.apache.flink.streaming.api.functions.source.legacy.SourceFunction;
import org.apache.flink.streaming.api.graph.ExecutionPlan;
import org.apache.flink.test.util.AbstractTestBaseJUnit4;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.apache.flink.util.AbstractID;

public abstract class SavepointTestBase
extends AbstractTestBaseJUnit4 {
    public String takeSavepoint(StreamExecutionEnvironment executionEnvironment) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().disableClosureCleaner();
        JobGraph jobGraph = executionEnvironment.getStreamGraph().getJobGraph();
        JobID jobId = jobGraph.getJobID();
        ClusterClient client = MINI_CLUSTER_RESOURCE.getClusterClient();
        try {
            JobID jobID = (JobID)client.submitJob((ExecutionPlan)jobGraph).get();
            SavepointTestBase.waitForAllRunningOrSomeTerminal(jobID, MINI_CLUSTER_RESOURCE);
            String string = this.triggerSavepoint(client, jobID).get(5L, TimeUnit.MINUTES);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to take savepoint", e);
        }
        finally {
            client.cancel(jobId);
        }
    }

    public static void waitForAllRunningOrSomeTerminal(JobID jobID, MiniClusterWithClientResource miniClusterResource) throws Exception {
        JobDetailsInfo jobInfo;
        Set vertexStates;
        while (!(vertexStates = (jobInfo = (JobDetailsInfo)miniClusterResource.getRestClusterClient().getJobDetails(jobID).get()).getJobVertexInfos().stream().map(JobDetailsInfo.JobVertexDetailsInfo::getExecutionState).collect(Collectors.toSet())).equals(EnumSet.of(ExecutionState.RUNNING)) && !vertexStates.stream().anyMatch(ExecutionState::isTerminal)) {
            Thread.sleep(500L);
        }
        return;
    }

    public <T> SourceFunction<T> createSource(T[] data) {
        return this.createSource(Arrays.asList(data));
    }

    public <T> SourceFunction<T> createSource(Collection<T> data) {
        T first = data.iterator().next();
        if (first == null) {
            throw new IllegalArgumentException("Collection must not contain null elements");
        }
        TypeInformation typeInfo = TypeExtractor.getForObject(first);
        try {
            FromElementsFunction inner = new FromElementsFunction(typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl()), data);
            return new WaitingSource(inner, typeInfo);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private CompletableFuture<String> triggerSavepoint(ClusterClient<?> client, JobID jobID) throws RuntimeException {
        try {
            String dirPath = this.getTempDirPath(new AbstractID().toHexString());
            return client.triggerSavepoint(jobID, dirPath, SavepointFormatType.CANONICAL);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

