/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.common.eventtime.SerializableTimestampAssigner;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.StateBackendOptions;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.hashmap.HashMapStateBackend;
import org.apache.flink.state.api.OperatorIdentifier;
import org.apache.flink.state.api.OperatorTransformation;
import org.apache.flink.state.api.SavepointWriter;
import org.apache.flink.state.api.StateBootstrapTransformation;
import org.apache.flink.state.api.WindowedStateTransformation;
import org.apache.flink.state.api.utils.MaxWatermarkSource;
import org.apache.flink.state.rocksdb.EmbeddedRocksDBStateBackend;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.datastream.WindowedStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.windowing.ProcessWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.WindowFunction;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.windowing.assigners.SlidingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.TumblingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.CountEvictor;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.test.util.AbstractTestBaseJUnit4;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.Collector;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SavepointWriterWindowITCase
extends AbstractTestBaseJUnit4 {
    private static final String UID = "uid";
    private static final Collection<String> WORDS = Arrays.asList("hello", "world", "hello", "everyone");
    private static final Iterable<? extends Tuple2<String, Integer>> STANDARD_MATCHER = Arrays.asList(Tuple2.of((Object)"hello", (Object)2), Tuple2.of((Object)"world", (Object)1), Tuple2.of((Object)"everyone", (Object)1));
    private static final Iterable<? extends Tuple2<String, Integer>> EVICTOR_MATCHER = Arrays.asList(Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"world", (Object)1), Tuple2.of((Object)"everyone", (Object)1));
    private static final TypeInformation<Tuple2<String, Integer>> TUPLE_TYPE_INFO = new TypeHint<Tuple2<String, Integer>>(){}.getTypeInfo();
    private static final List<Tuple3<String, WindowBootstrap, WindowStream>> SETUP_FUNCTIONS = Arrays.asList(Tuple3.of((Object)"reduce", transformation -> transformation.reduce((ReduceFunction)new Reducer()), stream -> stream.reduce((ReduceFunction)new Reducer())), Tuple3.of((Object)"aggregate", transformation -> transformation.aggregate((AggregateFunction)new Aggregator()), stream -> stream.aggregate((AggregateFunction)new Aggregator())), Tuple3.of((Object)"apply", transformation -> transformation.apply((WindowFunction)new CustomWindowFunction()), stream -> stream.apply((WindowFunction)new CustomWindowFunction())), Tuple3.of((Object)"process", transformation -> transformation.process((ProcessWindowFunction)new CustomProcessWindowFunction()), stream -> stream.process((ProcessWindowFunction)new CustomProcessWindowFunction())));
    private static final List<Tuple3<String, StateBackend, Configuration>> STATE_BACKENDS = Arrays.asList(Tuple3.of((Object)"HashMap", (Object)new HashMapStateBackend(), (Object)new Configuration().set(StateBackendOptions.STATE_BACKEND, (Object)"hashmap")), Tuple3.of((Object)"EmbeddedRocksDB", (Object)new EmbeddedRocksDBStateBackend(), (Object)new Configuration().set(StateBackendOptions.STATE_BACKEND, (Object)"rocksdb")));
    private final WindowBootstrap windowBootstrap;
    private final WindowStream windowStream;
    private final StateBackend stateBackend;
    private final Configuration configuration;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> parameterList = new ArrayList<Object[]>();
        for (Tuple3<String, StateBackend, Configuration> stateBackend : STATE_BACKENDS) {
            for (Tuple3<String, WindowBootstrap, WindowStream> setup : SETUP_FUNCTIONS) {
                Object[] parameters = new Object[]{(String)stateBackend.f0 + ": " + (String)setup.f0, setup.f1, setup.f2, stateBackend.f1, stateBackend.f2};
                parameterList.add(parameters);
            }
        }
        return parameterList;
    }

    public SavepointWriterWindowITCase(String ignore, WindowBootstrap windowBootstrap, WindowStream windowStream, StateBackend stateBackend, Configuration configuration) {
        this.windowBootstrap = windowBootstrap;
        this.windowStream = windowStream;
        this.stateBackend = stateBackend;
        this.configuration = configuration;
    }

    @Test
    public void testTumbleWindow() throws Exception {
        String savepointPath = this.getTempDirPath(new AbstractID().toHexString());
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)this.configuration);
        env.setRuntimeMode(RuntimeExecutionMode.AUTOMATIC);
        SingleOutputStreamOperator bootstrapData = env.fromData(WORDS).map((MapFunction & Serializable)word -> Tuple2.of((Object)word, (Object)1)).returns(TUPLE_TYPE_INFO).assignTimestampsAndWatermarks(WatermarkStrategy.noWatermarks().withTimestampAssigner((SerializableTimestampAssigner & Serializable)(record, ts) -> 2L));
        WindowedStateTransformation transformation = OperatorTransformation.bootstrapWith((DataStream)bootstrapData).keyBy((KeySelector & Serializable)tuple -> (String)tuple.f0, Types.STRING).window((WindowAssigner)TumblingEventTimeWindows.of((Duration)Duration.ofMillis(5L)));
        SavepointWriter.newSavepoint((StreamExecutionEnvironment)env, (StateBackend)this.stateBackend, (int)128).withOperator(OperatorIdentifier.forUid((String)UID), this.windowBootstrap.bootstrap((WindowedStateTransformation<Tuple2<String, Integer>, String, TimeWindow>)transformation)).write(savepointPath);
        env.execute("write state");
        WindowedStream stream = env.addSource(new MaxWatermarkSource()).returns(TUPLE_TYPE_INFO).keyBy((KeySelector & Serializable)tuple -> (String)tuple.f0).window((WindowAssigner)TumblingEventTimeWindows.of((Duration)Duration.ofMillis(5L)));
        SingleOutputStreamOperator windowed = this.windowStream.window((WindowedStream<Tuple2<String, Integer>, String, TimeWindow>)stream).uid(UID);
        CloseableIterator future = windowed.collectAsync();
        this.submitJob(savepointPath, env);
        ((IterableAssert)Assertions.assertThat((Iterator)future).toIterable().as("Incorrect results from bootstrapped windows", new Object[0])).containsAll(STANDARD_MATCHER);
    }

    @Test
    public void testTumbleWindowWithEvictor() throws Exception {
        String savepointPath = this.getTempDirPath(new AbstractID().toHexString());
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)this.configuration);
        env.setRuntimeMode(RuntimeExecutionMode.AUTOMATIC);
        SingleOutputStreamOperator bootstrapData = env.fromData(WORDS).map((MapFunction & Serializable)word -> Tuple2.of((Object)word, (Object)1)).returns(TUPLE_TYPE_INFO).assignTimestampsAndWatermarks(WatermarkStrategy.noWatermarks().withTimestampAssigner((SerializableTimestampAssigner & Serializable)(record, ts) -> 2L));
        WindowedStateTransformation transformation = OperatorTransformation.bootstrapWith((DataStream)bootstrapData).keyBy((KeySelector & Serializable)tuple -> (String)tuple.f0, Types.STRING).window((WindowAssigner)TumblingEventTimeWindows.of((Duration)Duration.ofMillis(5L))).evictor((Evictor)CountEvictor.of((long)1L));
        SavepointWriter.newSavepoint((StreamExecutionEnvironment)env, (StateBackend)this.stateBackend, (int)128).withOperator(OperatorIdentifier.forUid((String)UID), this.windowBootstrap.bootstrap((WindowedStateTransformation<Tuple2<String, Integer>, String, TimeWindow>)transformation)).write(savepointPath);
        env.execute("write state");
        WindowedStream stream = env.addSource(new MaxWatermarkSource()).returns(TUPLE_TYPE_INFO).keyBy((KeySelector & Serializable)tuple -> (String)tuple.f0).window((WindowAssigner)TumblingEventTimeWindows.of((Duration)Duration.ofMillis(5L))).evictor((Evictor)CountEvictor.of((long)1L));
        SingleOutputStreamOperator windowed = this.windowStream.window((WindowedStream<Tuple2<String, Integer>, String, TimeWindow>)stream).uid(UID);
        CloseableIterator future = windowed.collectAsync();
        this.submitJob(savepointPath, env);
        ((IterableAssert)Assertions.assertThat((Iterator)future).toIterable().as("Incorrect results from bootstrapped windows", new Object[0])).containsAll(EVICTOR_MATCHER);
    }

    @Test
    public void testSlideWindow() throws Exception {
        String savepointPath = this.getTempDirPath(new AbstractID().toHexString());
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)this.configuration);
        env.setRuntimeMode(RuntimeExecutionMode.AUTOMATIC);
        SingleOutputStreamOperator bootstrapData = env.fromData(WORDS).map((MapFunction & Serializable)word -> Tuple2.of((Object)word, (Object)1), TUPLE_TYPE_INFO).assignTimestampsAndWatermarks(WatermarkStrategy.noWatermarks().withTimestampAssigner((SerializableTimestampAssigner & Serializable)(record, ts) -> 2L));
        WindowedStateTransformation transformation = OperatorTransformation.bootstrapWith((DataStream)bootstrapData).keyBy((KeySelector & Serializable)tuple -> (String)tuple.f0, Types.STRING).window((WindowAssigner)SlidingEventTimeWindows.of((Duration)Duration.ofMillis(5L), (Duration)Duration.ofMillis(1L)));
        SavepointWriter.newSavepoint((StreamExecutionEnvironment)env, (StateBackend)this.stateBackend, (int)128).withOperator(OperatorIdentifier.forUid((String)UID), this.windowBootstrap.bootstrap((WindowedStateTransformation<Tuple2<String, Integer>, String, TimeWindow>)transformation)).write(savepointPath);
        env.execute("write state");
        WindowedStream stream = env.addSource(new MaxWatermarkSource()).returns(TUPLE_TYPE_INFO).keyBy((KeySelector & Serializable)tuple -> (String)tuple.f0).window((WindowAssigner)SlidingEventTimeWindows.of((Duration)Duration.ofMillis(5L), (Duration)Duration.ofMillis(1L)));
        SingleOutputStreamOperator windowed = this.windowStream.window((WindowedStream<Tuple2<String, Integer>, String, TimeWindow>)stream).uid(UID);
        CloseableIterator future = windowed.collectAsync();
        this.submitJob(savepointPath, env);
        ((IterableAssert)Assertions.assertThat((Iterator)future).toIterable().as("Incorrect results from bootstrapped windows", new Object[0])).containsAll(STANDARD_MATCHER);
    }

    @Test
    public void testSlideWindowWithEvictor() throws Exception {
        String savepointPath = this.getTempDirPath(new AbstractID().toHexString());
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)this.configuration);
        env.setRuntimeMode(RuntimeExecutionMode.AUTOMATIC);
        SingleOutputStreamOperator bootstrapData = env.fromData(WORDS).map((MapFunction & Serializable)word -> Tuple2.of((Object)word, (Object)1)).returns(TUPLE_TYPE_INFO).assignTimestampsAndWatermarks(WatermarkStrategy.noWatermarks().withTimestampAssigner((SerializableTimestampAssigner & Serializable)(record, ts) -> 2L));
        WindowedStateTransformation transformation = OperatorTransformation.bootstrapWith((DataStream)bootstrapData).keyBy((KeySelector & Serializable)tuple -> (String)tuple.f0, Types.STRING).window((WindowAssigner)SlidingEventTimeWindows.of((Duration)Duration.ofMillis(5L), (Duration)Duration.ofMillis(1L))).evictor((Evictor)CountEvictor.of((long)1L));
        SavepointWriter.newSavepoint((StreamExecutionEnvironment)env, (StateBackend)this.stateBackend, (int)128).withOperator(OperatorIdentifier.forUid((String)UID), this.windowBootstrap.bootstrap((WindowedStateTransformation<Tuple2<String, Integer>, String, TimeWindow>)transformation)).write(savepointPath);
        env.execute("write state");
        WindowedStream stream = env.addSource(new MaxWatermarkSource()).returns(TUPLE_TYPE_INFO).keyBy((KeySelector & Serializable)tuple -> (String)tuple.f0).window((WindowAssigner)SlidingEventTimeWindows.of((Duration)Duration.ofMillis(5L), (Duration)Duration.ofMillis(1L))).evictor((Evictor)CountEvictor.of((long)1L));
        SingleOutputStreamOperator windowed = this.windowStream.window((WindowedStream<Tuple2<String, Integer>, String, TimeWindow>)stream).uid(UID);
        CloseableIterator future = windowed.collectAsync();
        this.submitJob(savepointPath, env);
        ((IterableAssert)Assertions.assertThat((Iterator)future).toIterable().as("Incorrect results from bootstrapped windows", new Object[0])).containsAll(EVICTOR_MATCHER);
    }

    private void submitJob(String savepointPath, StreamExecutionEnvironment sEnv) throws Exception {
        StreamGraph streamGraph = sEnv.getStreamGraph();
        streamGraph.setSavepointRestoreSettings(SavepointRestoreSettings.forPath((String)savepointPath, (boolean)true));
        sEnv.execute(streamGraph);
    }

    @FunctionalInterface
    private static interface WindowBootstrap {
        public StateBootstrapTransformation<Tuple2<String, Integer>> bootstrap(WindowedStateTransformation<Tuple2<String, Integer>, String, TimeWindow> var1);
    }

    @FunctionalInterface
    private static interface WindowStream {
        public SingleOutputStreamOperator<Tuple2<String, Integer>> window(WindowedStream<Tuple2<String, Integer>, String, TimeWindow> var1);
    }

    private static class CustomProcessWindowFunction
    extends ProcessWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, String, TimeWindow> {
        private CustomProcessWindowFunction() {
        }

        public void process(String s, ProcessWindowFunction.Context context, Iterable<Tuple2<String, Integer>> elements, Collector<Tuple2<String, Integer>> out) {
            Iterator<Tuple2<String, Integer>> iterator = elements.iterator();
            Tuple2<String, Integer> acc = iterator.next();
            while (iterator.hasNext()) {
                Tuple2<String, Integer> next = iterator.next();
                Tuple2<String, Integer> tuple2 = acc;
                Integer.valueOf((Integer)tuple2.f1 + (Integer)next.f1);
                tuple2.f1 = tuple2.f1;
            }
            out.collect(acc);
        }
    }

    private static class CustomWindowFunction
    implements WindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, String, TimeWindow> {
        private CustomWindowFunction() {
        }

        public void apply(String s, TimeWindow window, Iterable<Tuple2<String, Integer>> input, Collector<Tuple2<String, Integer>> out) {
            Iterator<Tuple2<String, Integer>> iterator = input.iterator();
            Tuple2<String, Integer> acc = iterator.next();
            while (iterator.hasNext()) {
                Tuple2<String, Integer> next = iterator.next();
                Tuple2<String, Integer> tuple2 = acc;
                Integer.valueOf((Integer)tuple2.f1 + (Integer)next.f1);
                tuple2.f1 = tuple2.f1;
            }
            out.collect(acc);
        }
    }

    private static class Aggregator
    implements AggregateFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, Tuple2<String, Integer>> {
        private Aggregator() {
        }

        public Tuple2<String, Integer> createAccumulator() {
            return null;
        }

        public Tuple2<String, Integer> add(Tuple2<String, Integer> value, Tuple2<String, Integer> accumulator) {
            if (accumulator == null) {
                return Tuple2.of((Object)((String)value.f0), (Object)((Integer)value.f1));
            }
            Tuple2<String, Integer> tuple2 = accumulator;
            tuple2.f1 = (Integer)tuple2.f1 + (Integer)value.f1;
            return accumulator;
        }

        public Tuple2<String, Integer> getResult(Tuple2<String, Integer> accumulator) {
            return accumulator;
        }

        public Tuple2<String, Integer> merge(Tuple2<String, Integer> a, Tuple2<String, Integer> b) {
            Tuple2<String, Integer> tuple2 = a;
            tuple2.f1 = (Integer)tuple2.f1 + (Integer)b.f1;
            return a;
        }
    }

    private static class Reducer
    implements ReduceFunction<Tuple2<String, Integer>> {
        private Reducer() {
        }

        public Tuple2<String, Integer> reduce(Tuple2<String, Integer> value1, Tuple2<String, Integer> value2) {
            return Tuple2.of((Object)((String)value1.f0), (Object)((Integer)value1.f1 + (Integer)value2.f1));
        }
    }
}

