/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api;

import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.StateBackendOptions;
import org.apache.flink.runtime.state.StateBackendLoader;
import org.apache.flink.state.api.SavepointWriter;
import org.apache.flink.state.api.utils.CustomStateBackendFactory;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SavepointWriterTest {
    SavepointWriterTest() {
    }

    @Test
    void testCustomStateBackend() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        Configuration configuration = new Configuration();
        configuration.set(StateBackendOptions.STATE_BACKEND, (Object)CustomStateBackendFactory.class.getCanonicalName());
        configuration.set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.BATCH);
        Assertions.assertThatThrownBy(() -> StateBackendLoader.fromApplicationOrConfigOrDefault(null, (Configuration)new Configuration(), (Configuration)configuration, (ClassLoader)ClassLoader.getSystemClassLoader(), null)).isInstanceOf(CustomStateBackendFactory.ExpectedException.class);
    }

    @Test
    void testCantCreateSavepointFromNothing() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SavepointWriter.newSavepoint((StreamExecutionEnvironment)env, (int)128).write("file:///tmp/path")).isInstanceOf(IllegalStateException.class)).hasMessageContaining("at least one operator to be created");
    }
}

