/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.flink.avro.shaded.org.apache.avro.Schema;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericData;
import org.apache.flink.avro.shaded.org.apache.avro.specific.SpecificData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.parquet.avro.AvroCompatRecordMaterializer;
import org.apache.parquet.avro.AvroDataSupplier;
import org.apache.parquet.avro.AvroRecordConverter;
import org.apache.parquet.avro.AvroRecordMaterializer;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.avro.SpecificDataSupplier;
import org.apache.parquet.conf.HadoopParquetConfiguration;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.util.ConfigurationUtil;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroReadSupport<T>
extends ReadSupport<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AvroReadSupport.class);
    public static final String AVRO_REQUESTED_PROJECTION = "parquet.avro.projection";
    private static final String AVRO_READ_SCHEMA = "parquet.avro.read.schema";
    static final String AVRO_SCHEMA_METADATA_KEY = "parquet.avro.schema";
    static final String OLD_AVRO_SCHEMA_METADATA_KEY = "avro.schema";
    private static final String AVRO_READ_SCHEMA_METADATA_KEY = "avro.read.schema";
    public static final String AVRO_DATA_SUPPLIER = "parquet.avro.data.supplier";
    public static final String AVRO_COMPATIBILITY = "parquet.avro.compatible";
    public static final boolean AVRO_DEFAULT_COMPATIBILITY = true;
    public static final String READ_INT96_AS_FIXED = "parquet.avro.readInt96AsFixed";
    public static final boolean READ_INT96_AS_FIXED_DEFAULT = false;
    private GenericData model = null;

    public static void setRequestedProjection(Configuration configuration, Schema requestedProjection) {
        configuration.set(AVRO_REQUESTED_PROJECTION, requestedProjection.toString());
    }

    public static void setAvroReadSchema(Configuration configuration, Schema avroReadSchema) {
        configuration.set(AVRO_READ_SCHEMA, avroReadSchema.toString());
    }

    public static void setAvroDataSupplier(Configuration configuration, Class<? extends AvroDataSupplier> clazz) {
        configuration.set(AVRO_DATA_SUPPLIER, clazz.getName());
    }

    public AvroReadSupport() {
    }

    public AvroReadSupport(GenericData model) {
        this.model = model;
    }

    @Override
    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        return this.init(new HadoopParquetConfiguration(configuration), keyValueMetaData, fileSchema);
    }

    @Override
    public ReadSupport.ReadContext init(ParquetConfiguration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        String avroReadSchema;
        MessageType projection = fileSchema;
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        String requestedProjectionString = configuration.get(AVRO_REQUESTED_PROJECTION);
        if (requestedProjectionString != null) {
            Schema avroRequestedProjection = new Schema.Parser().parse(requestedProjectionString);
            projection = new AvroSchemaConverter(configuration).convert(avroRequestedProjection);
        }
        if ((avroReadSchema = configuration.get(AVRO_READ_SCHEMA)) != null) {
            metadata.put(AVRO_READ_SCHEMA_METADATA_KEY, avroReadSchema);
        }
        if (configuration.getBoolean(AVRO_COMPATIBILITY, true)) {
            metadata.put(AVRO_COMPATIBILITY, "true");
        }
        return new ReadSupport.ReadContext(projection, metadata);
    }

    @Override
    public RecordMaterializer<T> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        return this.prepareForRead(new HadoopParquetConfiguration(configuration), keyValueMetaData, fileSchema, readContext);
    }

    @Override
    public RecordMaterializer<T> prepareForRead(ParquetConfiguration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        Map<String, String> metadata = readContext.getReadSupportMetadata();
        MessageType parquetSchema = readContext.getRequestedSchema();
        Schema avroSchema = metadata.get(AVRO_READ_SCHEMA_METADATA_KEY) != null ? new Schema.Parser().parse(metadata.get(AVRO_READ_SCHEMA_METADATA_KEY)) : (keyValueMetaData.get(AVRO_SCHEMA_METADATA_KEY) != null ? new Schema.Parser().parse(keyValueMetaData.get(AVRO_SCHEMA_METADATA_KEY)) : (keyValueMetaData.get(OLD_AVRO_SCHEMA_METADATA_KEY) != null ? new Schema.Parser().parse(keyValueMetaData.get(OLD_AVRO_SCHEMA_METADATA_KEY)) : new AvroSchemaConverter(configuration).convert(parquetSchema)));
        GenericData model = this.getDataModel(configuration, avroSchema);
        String compatEnabled = metadata.get(AVRO_COMPATIBILITY);
        if (Boolean.parseBoolean(compatEnabled)) {
            return AvroReadSupport.newCompatMaterializer(parquetSchema, avroSchema, model);
        }
        return new AvroRecordMaterializer(parquetSchema, avroSchema, model);
    }

    private static <T> RecordMaterializer<T> newCompatMaterializer(MessageType parquetSchema, Schema avroSchema, GenericData model) {
        return new AvroCompatRecordMaterializer(parquetSchema, avroSchema, model);
    }

    private GenericData getDataModel(ParquetConfiguration conf, Schema schema) {
        if (this.model != null) {
            return this.model;
        }
        if (conf.get(AVRO_DATA_SUPPLIER) == null && schema != null) {
            SpecificData modelForSchema;
            try {
                modelForSchema = AvroRecordConverter.getModelForSchema(schema);
            }
            catch (Exception e) {
                LOG.warn(String.format("Failed to derive data model for Avro schema %s. Parquet will use default SpecificData model for reading from source.", schema), (Throwable)e);
                modelForSchema = null;
            }
            if (modelForSchema != null) {
                return modelForSchema;
            }
        }
        Class<AvroDataSupplier> suppClass = conf.getClass(AVRO_DATA_SUPPLIER, SpecificDataSupplier.class, AvroDataSupplier.class);
        return ((AvroDataSupplier)ReflectionUtils.newInstance(suppClass, (Configuration)ConfigurationUtil.createHadoopConfiguration(conf))).get();
    }
}

