/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.table.gateway.rest.SqlGatewayRestEndpoint;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestEndpointTestUtils;
import org.apache.flink.table.gateway.rest.util.TestingRestClient;
import org.apache.flink.table.gateway.service.utils.SqlGatewayServiceExtension;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.apache.flink.util.Preconditions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.extension.RegisterExtension;

public abstract class RestAPIITCaseBase {
    @RegisterExtension
    @Order(value=1)
    private static final MiniClusterExtension MINI_CLUSTER = new MiniClusterExtension();
    @RegisterExtension
    @Order(value=2)
    protected static final SqlGatewayServiceExtension SQL_GATEWAY_SERVICE_EXTENSION = new SqlGatewayServiceExtension(() -> ((MiniClusterExtension)MINI_CLUSTER).getClientConfiguration());
    @Nullable
    private static TestingRestClient restClient = null;
    @Nullable
    protected static String targetAddress = null;
    @Nullable
    private static SqlGatewayRestEndpoint sqlGatewayRestEndpoint = null;
    protected static int port = 0;

    @BeforeAll
    static void start() throws Exception {
        String address = InetAddress.getLoopbackAddress().getHostAddress();
        Configuration config = SqlGatewayRestEndpointTestUtils.getBaseConfig(SqlGatewayRestEndpointTestUtils.getFlinkConfig(address, address, "0"));
        sqlGatewayRestEndpoint = new SqlGatewayRestEndpoint(config, SQL_GATEWAY_SERVICE_EXTENSION.getService());
        sqlGatewayRestEndpoint.start();
        InetSocketAddress serverAddress = (InetSocketAddress)Preconditions.checkNotNull((Object)sqlGatewayRestEndpoint.getServerAddress());
        restClient = TestingRestClient.getTestingRestClient();
        targetAddress = serverAddress.getHostName();
        port = serverAddress.getPort();
    }

    @AfterAll
    static void stop() throws Exception {
        Preconditions.checkNotNull((Object)sqlGatewayRestEndpoint);
        sqlGatewayRestEndpoint.close();
        Preconditions.checkNotNull((Object)((Object)restClient));
        restClient.shutdown(Duration.ofSeconds(3L));
    }

    public <M extends MessageHeaders<R, P, U>, U extends MessageParameters, R extends RequestBody, P extends ResponseBody> CompletableFuture<P> sendRequest(M messageHeaders, U messageParameters, R request) throws IOException {
        Preconditions.checkNotNull((Object)((Object)restClient));
        return restClient.sendRequest(targetAddress, port, messageHeaders, messageParameters, request);
    }
}

