/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.api.utils;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.table.gateway.api.endpoint.SqlGatewayEndpoint;

public class MockedSqlGatewayEndpoint
implements SqlGatewayEndpoint {
    private static final Set<String> RUNNING_ENDPOINTS = ConcurrentHashMap.newKeySet();
    private final String id;
    private final String host;
    private final int port;
    private final String description;

    public static boolean isRunning(String id) {
        return RUNNING_ENDPOINTS.contains(id);
    }

    public MockedSqlGatewayEndpoint(String id, String host, int port, String description) {
        this.id = id;
        this.host = host;
        this.port = port;
        this.description = description;
        if (RUNNING_ENDPOINTS.contains(id)) {
            throw new IllegalArgumentException("There are endpoints with the same id is running. Please specify an unique identifier.");
        }
    }

    public void start() throws Exception {
        RUNNING_ENDPOINTS.add(this.id);
    }

    public void stop() throws Exception {
        RUNNING_ENDPOINTS.remove(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MockedSqlGatewayEndpoint)) {
            return false;
        }
        MockedSqlGatewayEndpoint that = (MockedSqlGatewayEndpoint)o;
        return Objects.equals(this.id, that.id) && this.port == that.port && Objects.equals(this.host, that.host) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.host, this.port, this.description);
    }
}

