/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals.events;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals.CommitRequestManager;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals.NoopBackgroundEvent;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals.RequestManager;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals.events.AssignmentChangeApplicationEvent;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals.events.CommitApplicationEvent;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals.events.NewTopicsMetadataUpdateRequestEvent;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals.events.NoopApplicationEvent;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals.events.OffsetFetchApplicationEvent;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals.events.PollApplicationEvent;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.KafkaException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;

public class ApplicationEventProcessor {
    private final BlockingQueue<BackgroundEvent> backgroundEventQueue;
    private final Map<RequestManager.Type, Optional<RequestManager>> registry;
    private final ConsumerMetadata metadata;

    public ApplicationEventProcessor(BlockingQueue<BackgroundEvent> backgroundEventQueue, Map<RequestManager.Type, Optional<RequestManager>> requestManagerRegistry, ConsumerMetadata metadata) {
        this.backgroundEventQueue = backgroundEventQueue;
        this.registry = requestManagerRegistry;
        this.metadata = metadata;
    }

    public boolean process(ApplicationEvent event) {
        Objects.requireNonNull(event);
        switch (event.type) {
            case NOOP: {
                return this.process((NoopApplicationEvent)event);
            }
            case COMMIT: {
                return this.process((CommitApplicationEvent)event);
            }
            case POLL: {
                return this.process((PollApplicationEvent)event);
            }
            case FETCH_COMMITTED_OFFSET: {
                return this.process((OffsetFetchApplicationEvent)event);
            }
            case METADATA_UPDATE: {
                return this.process((NewTopicsMetadataUpdateRequestEvent)event);
            }
            case ASSIGNMENT_CHANGE: {
                return this.process((AssignmentChangeApplicationEvent)event);
            }
        }
        return false;
    }

    private boolean process(NoopApplicationEvent event) {
        return this.backgroundEventQueue.add(new NoopBackgroundEvent(event.message));
    }

    private boolean process(PollApplicationEvent event) {
        Optional<RequestManager> commitRequestManger = this.registry.get((Object)RequestManager.Type.COMMIT);
        if (!commitRequestManger.isPresent()) {
            return true;
        }
        CommitRequestManager manager = (CommitRequestManager)commitRequestManger.get();
        manager.updateAutoCommitTimer(event.pollTimeMs);
        return true;
    }

    private boolean process(CommitApplicationEvent event) {
        Optional<RequestManager> commitRequestManger = this.registry.get((Object)RequestManager.Type.COMMIT);
        if (!commitRequestManger.isPresent()) {
            KafkaException exception = new KafkaException("Unable to commit offset. Most likely because the group.id wasn't set");
            event.future().completeExceptionally(exception);
            return false;
        }
        CommitRequestManager manager = (CommitRequestManager)commitRequestManger.get();
        manager.addOffsetCommitRequest(event.offsets()).whenComplete((r, e) -> {
            if (e != null) {
                event.future().completeExceptionally((Throwable)e);
                return;
            }
            event.future().complete(null);
        });
        return true;
    }

    private boolean process(OffsetFetchApplicationEvent event) {
        Optional<RequestManager> commitRequestManger = this.registry.get((Object)RequestManager.Type.COMMIT);
        CompletableFuture<Map<TopicPartition, OffsetAndMetadata>> future = event.future();
        if (!commitRequestManger.isPresent()) {
            future.completeExceptionally(new KafkaException("Unable to fetch committed offset because the CommittedRequestManager is not available. Check if group.id was set correctly"));
            return false;
        }
        CommitRequestManager manager = (CommitRequestManager)commitRequestManger.get();
        manager.addOffsetFetchRequest(event.partitions()).whenComplete((r, e) -> {
            if (e != null) {
                future.completeExceptionally((Throwable)e);
                return;
            }
            future.complete((Map<TopicPartition, OffsetAndMetadata>)r);
        });
        return true;
    }

    private boolean process(NewTopicsMetadataUpdateRequestEvent event) {
        this.metadata.requestUpdateForNewTopics();
        return true;
    }

    private boolean process(AssignmentChangeApplicationEvent event) {
        Optional<RequestManager> commitRequestManger = this.registry.get((Object)RequestManager.Type.COMMIT);
        if (!commitRequestManger.isPresent()) {
            return false;
        }
        CommitRequestManager manager = (CommitRequestManager)commitRequestManger.get();
        manager.updateAutoCommitTimer(event.currentTimeMs);
        manager.maybeAutoCommit(event.offsets);
        return true;
    }
}

