/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals;

import java.util.Objects;
import java.util.Optional;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.GroupRebalanceConfig;

public class GroupState {
    public final String groupId;
    public final Optional<String> groupInstanceId;
    public Generation generation = Generation.NO_GENERATION;

    public GroupState(String groupId, Optional<String> groupInstanceId) {
        this.groupId = groupId;
        this.groupInstanceId = groupInstanceId;
    }

    public GroupState(GroupRebalanceConfig config) {
        this.groupId = config.groupId;
        this.groupInstanceId = config.groupInstanceId;
    }

    protected static class Generation {
        public static final Generation NO_GENERATION = new Generation(-1, "", null);
        public final int generationId;
        public final String memberId;
        public final String protocolName;

        public Generation(int generationId, String memberId, String protocolName) {
            this.generationId = generationId;
            this.memberId = memberId;
            this.protocolName = protocolName;
        }

        public boolean hasMemberId() {
            return !this.memberId.isEmpty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Generation that = (Generation)o;
            return this.generationId == that.generationId && Objects.equals(this.memberId, that.memberId) && Objects.equals(this.protocolName, that.protocolName);
        }

        public int hashCode() {
            return Objects.hash(this.generationId, this.memberId, this.protocolName);
        }

        public String toString() {
            return "Generation{generationId=" + this.generationId + ", memberId='" + this.memberId + '\'' + ", protocol='" + this.protocolName + '\'' + '}';
        }
    }
}

