/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.impl.producer;

import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.impl.producer.MarlinProducerResultImpl;

public class ProducerRecordJob {
    private boolean flushJob;
    private boolean flushJobDone;
    private MarlinProducerResultImpl result;
    private byte[] topic;
    private byte[] key;
    private byte[] value;
    private long timestamp;

    public ProducerRecordJob(MarlinProducerResultImpl res, byte[] k, byte[] v, long t) {
        this.flushJob = false;
        this.flushJobDone = false;
        this.result = res;
        this.key = k;
        this.value = v;
        this.timestamp = t;
    }

    public ProducerRecordJob() {
        this.flushJob = true;
        this.flushJobDone = false;
    }

    public boolean isFlushJob() {
        return this.flushJob;
    }

    public boolean getFlushJobDone() {
        return this.flushJobDone;
    }

    public void markFlushJobDone() {
        this.flushJobDone = true;
    }

    public byte[] getTopic() {
        if (this.topic == null && !this.flushJob) {
            this.topic = this.result.getTopic().getBytes();
        }
        return this.topic;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public MarlinProducerResultImpl getResult() {
        return this.result;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int estimatedSizeInBytes() {
        return (this.topic == null ? 0 : this.topic.length) + (this.key == null ? 0 : this.key.length) + (this.value == null ? 0 : this.value.length);
    }
}

