/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.impl.producer;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.impl.MarlinClient;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.impl.producer.MarlinProducerImpl;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.Callback;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.Producer;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.KafkaException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Metric;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.MetricName;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.PartitionInfo;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.SerializationException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarlinProducer<K, V>
extends MarlinClient
implements Producer<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(MarlinProducer.class);
    private final Serializer<K> _keySerializer;
    private final Serializer<V> _valueSerializer;
    private final MarlinProducerImpl _producer;

    protected MarlinProducer(ProducerConfig config, Serializer<K> keySerializer, Serializer<V> valueSerializer, MarlinProducerImpl producer) throws KafkaException {
        LOG.debug("Starting Streams producer");
        this._keySerializer = keySerializer;
        this._valueSerializer = valueSerializer;
        this._producer = producer;
    }

    public MarlinProducer(ProducerConfig config, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws KafkaException {
        LOG.debug("Starting Streams producer");
        this._keySerializer = keySerializer;
        this._valueSerializer = valueSerializer;
        this._producer = new MarlinProducerImpl(config);
    }

    @Override
    public void initTransactions() {
        throw new KafkaException("initTransactions API not implemented");
    }

    @Override
    public void beginTransaction() throws ProducerFencedException {
        throw new KafkaException("beginTransaction API not implemented");
    }

    @Override
    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) throws ProducerFencedException {
        throw new KafkaException("sendOffsetsToTransaction API not implemented");
    }

    @Override
    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) throws ProducerFencedException {
        throw new KafkaException("sendOffsetsToTransaction API not implemented");
    }

    @Override
    public void commitTransaction() throws ProducerFencedException {
        throw new KafkaException("commitTransaction API not implemented");
    }

    @Override
    public void abortTransaction() throws ProducerFencedException {
        throw new KafkaException("abortTransaction API not implemented");
    }

    @Override
    public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
        return this.send(record, null);
    }

    @Override
    public Future<RecordMetadata> send(ProducerRecord<K, V> record, Callback callback) {
        byte[] serializedValue;
        byte[] serializedKey;
        try {
            serializedKey = this._keySerializer.serialize(record.topic(), record.key());
        }
        catch (ClassCastException cce) {
            throw new SerializationException("Can't convert key of class " + record.key().getClass().getName() + " to class " + this._keySerializer.getClass() + " specified in key.serializer");
        }
        try {
            serializedValue = this._valueSerializer.serialize(record.topic(), record.value());
        }
        catch (ClassCastException cce) {
            throw new SerializationException("Can't convert value of class " + record.value().getClass().getName() + " to class " + this._valueSerializer.getClass() + " specified in value.serializer");
        }
        int partID = record.partition() == null ? -1 : record.partition();
        return this._producer.send(record, partID, serializedKey, serializedValue, callback);
    }

    @Override
    public void flush() {
        this._producer.flush();
    }

    @Override
    public List<PartitionInfo> partitionsFor(String topic) {
        return this._producer.getTopicInfo(topic);
    }

    @Override
    public Map<MetricName, ? extends Metric> metrics() {
        return this._producer.metrics();
    }

    @Override
    public void close() {
        this._producer.close();
    }

    @Override
    public void close(Duration timeout) {
        try {
            this._producer.close(timeout);
        }
        catch (InterruptedException e) {
            throw new KafkaException("Failed to close kafka producer", e);
        }
    }
}

