/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams;

import com.mapr.fs.ShimLoader;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.Admin;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.StreamDescriptor;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.TopicDescriptor;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.impl.MessageStore;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.impl.admin.MStreamDescriptor;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.impl.admin.MTopicDescriptor;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.impl.admin.MarlinAdminImpl;
import org.apache.hadoop.conf.Configuration;
import org.ojai.store.DocumentStore;

public class Streams {
    public static final String ID = "_id";
    public static final String PARTITION = "partition";
    public static final String TOPIC = "topic";
    public static final String OFFSET = "offset";
    public static final String PRODUCER = "producer";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String MAX_SCANNER_THREADS = "streams.analytics.max_scanner_threads";
    public static final String MAX_CACHE_MEMORY = "streams.analytics.cache_memory";

    public static DocumentStore getMessageStore(String streamPath) throws IOException {
        return new MessageStore(streamPath, new Configuration(), new String[0]);
    }

    public static DocumentStore getMessageStore(String streamPath, Configuration conf) throws IOException {
        return new MessageStore(streamPath, conf, (String[])null);
    }

    public static DocumentStore getMessageStore(String streamPath, String ... topics) throws IOException {
        return new MessageStore(streamPath, new Configuration(), topics);
    }

    public static DocumentStore getMessageStore(String streamPath, Configuration conf, String ... topics) throws IOException {
        return new MessageStore(streamPath, conf, topics);
    }

    public static DocumentStore getMessageStore(String streamPath, Pattern regex) throws IOException {
        return new MessageStore(streamPath, new Configuration(), regex);
    }

    public static DocumentStore getMessageStore(String streamPath, Configuration conf, Pattern regex) throws IOException {
        return new MessageStore(streamPath, conf, regex);
    }

    public static Admin newAdmin(Configuration c) throws IOException {
        return new MarlinAdminImpl(c);
    }

    public static Admin newAdmin(Configuration c, String cluster) throws IOException {
        return new MarlinAdminImpl(c, cluster);
    }

    public static StreamDescriptor newStreamDescriptor() {
        return new MStreamDescriptor();
    }

    public static TopicDescriptor newTopicDescriptor() {
        return new MTopicDescriptor();
    }

    static {
        ShimLoader.load();
    }
}

