/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.reader.deserializer;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.connector.kafka.source.reader.deserializer.KafkaRecordDeserializationSchema;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Configurable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization.Deserializer;
import org.apache.flink.util.Collector;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.TemporaryClassLoaderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaValueOnlyDeserializerWrapper<T>
implements KafkaRecordDeserializationSchema<T> {
    private static final long serialVersionUID = 5409547407386004054L;
    private static final Logger LOG = LoggerFactory.getLogger(KafkaValueOnlyDeserializerWrapper.class);
    private final Class<? extends Deserializer<T>> deserializerClass;
    private final Map<String, String> config;
    private transient Deserializer<T> deserializer;

    KafkaValueOnlyDeserializerWrapper(Class<? extends Deserializer<T>> deserializerClass, Map<String, String> config) {
        this.deserializerClass = deserializerClass;
        this.config = config;
    }

    @Override
    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        ClassLoader userCodeClassLoader = context.getUserCodeClassLoader().asClassLoader();
        try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of((ClassLoader)userCodeClassLoader);){
            this.deserializer = (Deserializer)InstantiationUtil.instantiate((String)this.deserializerClass.getName(), Deserializer.class, (ClassLoader)this.getClass().getClassLoader());
            if (this.deserializer instanceof Configurable) {
                ((Configurable)((Object)this.deserializer)).configure(this.config);
            } else {
                this.deserializer.configure(this.config, false);
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to instantiate the deserializer of class " + this.deserializerClass, e);
        }
    }

    @Override
    public void deserialize(ConsumerRecord<byte[], byte[]> record, Collector<T> collector) throws IOException {
        if (this.deserializer == null) {
            throw new IllegalStateException("The deserializer has not been created. Make sure the open() method has been invoked.");
        }
        T value = this.deserializer.deserialize(record.topic(), record.value());
        LOG.trace("Deserialized [partition: {}-{}, offset: {}, timestamp: {}, value: {}]", new Object[]{record.topic(), record.partition(), record.offset(), record.timestamp(), value});
        collector.collect(value);
    }

    public TypeInformation<T> getProducedType() {
        return TypeExtractor.createTypeInfo(Deserializer.class, this.deserializerClass, (int)0, null, null);
    }
}

