/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.sink.internal;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.kafka.sink.KafkaWriterState;
import org.apache.flink.util.Preconditions;

@Internal
public enum TransactionOwnership {
    IMPLICIT_BY_SUBTASK_ID{

        @Override
        public int[] getOwnedSubtaskIds(int currentSubtaskId, int currentParallelism, Collection<KafkaWriterState> recoveredStates) {
            if (!recoveredStates.isEmpty()) {
                this.checkForMigration(recoveredStates);
            }
            return new int[]{currentSubtaskId};
        }

        private void checkForMigration(Collection<KafkaWriterState> recoveredStates) {
            TransactionOwnership oldOwnership = recoveredStates.stream().map(KafkaWriterState::getTransactionOwnership).findFirst().orElseThrow();
            if (oldOwnership != this) {
                throw new IllegalStateException("Attempted to switch the transaction naming strategy back to INCREMENTING which may result in data loss.");
            }
        }

        @Override
        public int getTotalNumberOfOwnedSubtasks(int currentSubtaskId, int currentParallelism, Collection<KafkaWriterState> recoveredStates) {
            return currentParallelism;
        }
    }
    ,
    EXPLICIT_BY_WRITER_STATE{

        @Override
        public int[] getOwnedSubtaskIds(int currentSubtaskId, int currentParallelism, Collection<KafkaWriterState> recoveredStates) {
            if (recoveredStates.isEmpty()) {
                return new int[]{currentSubtaskId};
            }
            int[] ownedSubtaskIds = recoveredStates.stream().mapToInt(KafkaWriterState::getOwnedSubtaskId).sorted().toArray();
            this.assertKnown(ownedSubtaskIds[0]);
            int maxParallelism = recoveredStates.iterator().next().getTotalNumberOfOwnedSubtasks();
            Preconditions.checkState((currentSubtaskId < maxParallelism ? 1 : 0) != 0, (Object)"State not consecutively assigned");
            return ownedSubtaskIds;
        }

        @Override
        public int getTotalNumberOfOwnedSubtasks(int currentSubtaskId, int currentParallelism, Collection<KafkaWriterState> recoveredStates) {
            if (recoveredStates.isEmpty()) {
                return currentParallelism;
            }
            Set numSubtasks = recoveredStates.stream().map(KafkaWriterState::getTotalNumberOfOwnedSubtasks).collect(Collectors.toSet());
            Preconditions.checkState((numSubtasks.size() == 1 ? 1 : 0) != 0, (String)"Writer states not in sync %s", (Object[])new Object[]{recoveredStates});
            int totalNumberOfOwnedSubtasks = (Integer)numSubtasks.iterator().next();
            this.assertKnown(totalNumberOfOwnedSubtasks);
            if (currentParallelism >= totalNumberOfOwnedSubtasks) {
                Preconditions.checkState((recoveredStates.size() == 1 ? 1 : 0) != 0, (Object)"Not uniformly assigned");
            }
            return Math.max(totalNumberOfOwnedSubtasks, currentParallelism);
        }

        private void assertKnown(int ownershipValue) {
            Preconditions.checkState((ownershipValue != -1 ? 1 : 0) != 0, (Object)"Attempted to migrate from flink-connector-kafka 3.X directly to a naming strategy that uses the new writer state. Please first migrate to a flink-connector-kafka 4.X with INCREMENTING.");
        }
    };


    public abstract int[] getOwnedSubtaskIds(int var1, int var2, Collection<KafkaWriterState> var3);

    public abstract int getTotalNumberOfOwnedSubtasks(int var1, int var2, Collection<KafkaWriterState> var3);
}

