/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Optional;
import org.apache.commons.io.output.NullPrintStream;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemOutRedirectionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SystemOutRedirectionUtils.class);
    @VisibleForTesting
    static final String OUT_TO_LOG_TIPS = "Tips: System.out is redirected to LOG.info as configured. View the log file and search [SystemOutRedirectionUtils] for output." + System.lineSeparator();
    @VisibleForTesting
    static final String ERR_TO_LOG_TIPS = "Tips: System.err is redirected to LOG.error as configured. View the log file and search [SystemOutRedirectionUtils] for output." + System.lineSeparator();
    @VisibleForTesting
    static final String OUT_IGNORE_TIPS = "Tips: System.out will be directly ignored as configured." + System.lineSeparator();
    @VisibleForTesting
    static final String ERR_IGNORE_TIPS = "Tips: System.err will be directly ignored as configured." + System.lineSeparator();

    public static void redirectSystemOutAndError(Configuration conf) {
        TaskManagerOptions.SystemOutMode systemOutMode = (TaskManagerOptions.SystemOutMode)conf.get(TaskManagerOptions.TASK_MANAGER_SYSTEM_OUT_MODE);
        switch (systemOutMode) {
            case LOG: {
                System.out.print(OUT_TO_LOG_TIPS);
                System.err.print(ERR_TO_LOG_TIPS);
                SystemOutRedirectionUtils.redirectToCurrentLog(((MemorySize)conf.get(TaskManagerOptions.TASK_MANAGER_SYSTEM_OUT_LOG_CACHE_SIZE)).getBytes(), (Boolean)conf.get(TaskManagerOptions.TASK_MANAGER_SYSTEM_OUT_LOG_THREAD_NAME));
                break;
            }
            case IGNORE: {
                System.out.print(OUT_IGNORE_TIPS);
                System.err.print(ERR_IGNORE_TIPS);
                SystemOutRedirectionUtils.ignoreSystemOutAndError();
                break;
            }
        }
    }

    private static void ignoreSystemOutAndError() {
        System.setOut((PrintStream)new NullPrintStream());
        System.setErr((PrintStream)new NullPrintStream());
    }

    private static void redirectToCurrentLog(long byteLimitEachLine, boolean logThreadName) {
        SystemOutRedirectionUtils.redirectToLoggingRedirector(arg_0 -> ((Logger)LOG).info(arg_0), arg_0 -> ((Logger)LOG).error(arg_0), byteLimitEachLine, logThreadName);
    }

    @VisibleForTesting
    static void redirectToLoggingRedirector(LoggingRedirector outRedirector, LoggingRedirector errRedirector, long byteLimitEachLine, boolean logThreadName) {
        System.setOut(new LoggingPrintStream(outRedirector, byteLimitEachLine, logThreadName));
        System.setErr(new LoggingPrintStream(errRedirector, byteLimitEachLine, logThreadName));
    }

    @VisibleForTesting
    static interface LoggingRedirector {
        public void redirect(String var1);
    }

    private static class LoggingPrintStream
    extends PrintStream {
        private final LoggingRedirector loggingRedirector;
        private final LineContextCache helper;
        private final boolean logThreadName;

        private LoggingPrintStream(LoggingRedirector loggingRedirector, long byteLimitEachLine, boolean logThreadName) {
            super(new LineContextCache(byteLimitEachLine));
            this.helper = (LineContextCache)this.out;
            this.loggingRedirector = loggingRedirector;
            this.logThreadName = logThreadName;
        }

        @Override
        public void write(int b) {
            super.write(b);
            this.tryLogCurrentLine();
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            super.write(buf, off, len);
            this.tryLogCurrentLine();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tryLogCurrentLine() {
            LoggingPrintStream loggingPrintStream = this;
            synchronized (loggingPrintStream) {
                this.helper.tryGenerateContext().ifPresent(logContext -> {
                    if (!this.logThreadName) {
                        this.loggingRedirector.redirect((String)logContext);
                        return;
                    }
                    this.loggingRedirector.redirect(String.format("Thread Name: %s , log context: %s", Thread.currentThread().getName(), logContext));
                });
            }
        }
    }

    private static class LineContextCache
    extends ByteArrayOutputStream {
        private static final byte[] LINE_SEPARATOR_BYTES = System.lineSeparator().getBytes();
        private static final int LINE_SEPARATOR_LENGTH = LINE_SEPARATOR_BYTES.length;
        private final long byteLimitEachLine;

        private LineContextCache(long byteLimitEachLine) {
            this.byteLimitEachLine = byteLimitEachLine;
        }

        public synchronized Optional<String> tryGenerateContext() {
            if (this.isLineEnded()) {
                try {
                    Optional<String> optional = Optional.of(new String(this.buf, 0, this.count - LINE_SEPARATOR_LENGTH));
                    return optional;
                }
                finally {
                    this.reset();
                }
            }
            if ((long)this.count >= this.byteLimitEachLine) {
                try {
                    Optional<String> optional = Optional.of(new String(this.buf, 0, this.count));
                    return optional;
                }
                finally {
                    this.reset();
                }
            }
            return Optional.empty();
        }

        private synchronized boolean isLineEnded() {
            if (this.count < LINE_SEPARATOR_LENGTH) {
                return false;
            }
            if (LINE_SEPARATOR_LENGTH == 1) {
                return LINE_SEPARATOR_BYTES[0] == this.buf[this.count - 1];
            }
            for (int i = 0; i < LINE_SEPARATOR_LENGTH; ++i) {
                if (LINE_SEPARATOR_BYTES[i] == this.buf[this.count - LINE_SEPARATOR_LENGTH + i]) continue;
                return false;
            }
            return true;
        }
    }
}

