/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.internal.InternalAggregatingState;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.apache.flink.runtime.state.internal.InternalReducingState;
import org.apache.flink.runtime.state.internal.InternalValueState;
import org.apache.flink.runtime.state.metrics.LatencyTrackingAggregatingState;
import org.apache.flink.runtime.state.metrics.LatencyTrackingListState;
import org.apache.flink.runtime.state.metrics.LatencyTrackingMapState;
import org.apache.flink.runtime.state.metrics.LatencyTrackingReducingState;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.apache.flink.runtime.state.metrics.LatencyTrackingValueState;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.function.SupplierWithException;

public class LatencyTrackingStateFactory<K, N, V, S extends State, IS extends InternalKvState<K, N, ?>> {
    private final InternalKvState<K, N, ?> kvState;
    private final StateDescriptor<S, V> stateDescriptor;
    private final LatencyTrackingStateConfig latencyTrackingStateConfig;
    private final Map<StateDescriptor.Type, SupplierWithException<IS, Exception>> stateFactories;

    private LatencyTrackingStateFactory(InternalKvState<K, N, ?> kvState, StateDescriptor<S, V> stateDescriptor, LatencyTrackingStateConfig latencyTrackingStateConfig) {
        this.kvState = kvState;
        this.stateDescriptor = stateDescriptor;
        this.latencyTrackingStateConfig = latencyTrackingStateConfig;
        this.stateFactories = this.createStateFactories();
    }

    public static <K, N, V, S extends State> InternalKvState<K, N, ?> createStateAndWrapWithLatencyTrackingIfEnabled(InternalKvState<K, N, ?> kvState, StateDescriptor<S, V> stateDescriptor, LatencyTrackingStateConfig latencyTrackingStateConfig) throws Exception {
        if (latencyTrackingStateConfig.isEnabled()) {
            return new LatencyTrackingStateFactory(kvState, stateDescriptor, latencyTrackingStateConfig).createState();
        }
        return kvState;
    }

    private Map<StateDescriptor.Type, SupplierWithException<IS, Exception>> createStateFactories() {
        return Stream.of(Tuple2.of((Object)StateDescriptor.Type.VALUE, this::createValueState), Tuple2.of((Object)StateDescriptor.Type.LIST, this::createListState), Tuple2.of((Object)StateDescriptor.Type.MAP, this::createMapState), Tuple2.of((Object)StateDescriptor.Type.REDUCING, this::createReducingState), Tuple2.of((Object)StateDescriptor.Type.AGGREGATING, this::createAggregatingState)).collect(Collectors.toMap(t -> (StateDescriptor.Type)t.f0, t -> (SupplierWithException)t.f1));
    }

    private IS createState() throws Exception {
        SupplierWithException<IS, Exception> stateFactory = this.stateFactories.get(this.stateDescriptor.getType());
        if (stateFactory == null) {
            String message = String.format("State %s is not supported by %s", this.stateDescriptor.getClass(), LatencyTrackingStateFactory.class);
            throw new FlinkRuntimeException(message);
        }
        return (IS)((InternalKvState)stateFactory.get());
    }

    private IS createValueState() {
        return (IS)new LatencyTrackingValueState(this.stateDescriptor.getName(), (InternalValueState)this.kvState, this.latencyTrackingStateConfig);
    }

    private IS createListState() {
        return (IS)new LatencyTrackingListState(this.stateDescriptor.getName(), (InternalListState)this.kvState, this.latencyTrackingStateConfig);
    }

    private <UK, UV> IS createMapState() {
        return (IS)new LatencyTrackingMapState(this.stateDescriptor.getName(), (InternalMapState)this.kvState, this.latencyTrackingStateConfig);
    }

    private IS createReducingState() {
        return (IS)new LatencyTrackingReducingState(this.stateDescriptor.getName(), (InternalReducingState)this.kvState, this.latencyTrackingStateConfig);
    }

    private <IN, SV, OUT> IS createAggregatingState() {
        return (IS)new LatencyTrackingAggregatingState(this.stateDescriptor.getName(), (InternalAggregatingState)this.kvState, this.latencyTrackingStateConfig);
    }
}

