/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metainfo;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshotSerializationUtil;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoReader;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoWriter;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

public class StateMetaInfoSnapshotReadersWriters {
    public static final int CURRENT_STATE_META_INFO_SNAPSHOT_VERSION = 7;

    private StateMetaInfoSnapshotReadersWriters() {
    }

    @Nonnull
    public static StateMetaInfoWriter getWriter() {
        return CurrentWriterImpl.INSTANCE;
    }

    @Nonnull
    public static StateMetaInfoReader getReader(int readVersion) {
        Preconditions.checkArgument((readVersion <= 7 ? 1 : 0) != 0, (String)"Unsupported read version for state meta info [%s]", (Object[])new Object[]{readVersion});
        if (readVersion < 6) {
            throw new UnsupportedOperationException(String.format("No longer supported version [%d]. Please upgrade first to Flink 1.16. ", readVersion));
        }
        return CurrentReaderImpl.INSTANCE;
    }

    static class CurrentWriterImpl
    implements StateMetaInfoWriter {
        private static final CurrentWriterImpl INSTANCE = new CurrentWriterImpl();

        CurrentWriterImpl() {
        }

        @Override
        public void writeStateMetaInfoSnapshot(@Nonnull StateMetaInfoSnapshot snapshot, @Nonnull DataOutputView outputView) throws IOException {
            Map<String, String> optionsMap = snapshot.getOptionsImmutable();
            Map<String, TypeSerializerSnapshot<?>> serializerConfigSnapshotsMap = snapshot.getSerializerSnapshotsImmutable();
            outputView.writeUTF(snapshot.getName());
            outputView.writeInt(snapshot.getBackendStateType().ordinal());
            outputView.writeInt(optionsMap.size());
            for (Map.Entry<String, String> entry : optionsMap.entrySet()) {
                outputView.writeUTF(entry.getKey());
                outputView.writeUTF(entry.getValue());
            }
            outputView.writeInt(serializerConfigSnapshotsMap.size());
            for (Map.Entry<String, String> entry : serializerConfigSnapshotsMap.entrySet()) {
                String key = entry.getKey();
                outputView.writeUTF(entry.getKey());
                TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot((DataOutputView)outputView, (TypeSerializerSnapshot)((TypeSerializerSnapshot)entry.getValue()));
            }
        }
    }

    static class CurrentReaderImpl
    implements StateMetaInfoReader {
        private static final CurrentReaderImpl INSTANCE = new CurrentReaderImpl();

        CurrentReaderImpl() {
        }

        @Override
        @Nonnull
        public StateMetaInfoSnapshot readStateMetaInfoSnapshot(@Nonnull DataInputView inputView, @Nonnull ClassLoader userCodeClassLoader) throws IOException {
            String stateName = inputView.readUTF();
            StateMetaInfoSnapshot.BackendStateType stateType = StateMetaInfoSnapshot.BackendStateType.values()[inputView.readInt()];
            int numOptions = inputView.readInt();
            HashMap optionsMap = CollectionUtil.newHashMapWithExpectedSize((int)numOptions);
            for (int i = 0; i < numOptions; ++i) {
                String key = inputView.readUTF();
                String value = inputView.readUTF();
                optionsMap.put(key, value);
            }
            int numSerializerConfigSnapshots = inputView.readInt();
            HashMap serializerConfigsMap = CollectionUtil.newHashMapWithExpectedSize((int)numSerializerConfigSnapshots);
            for (int i = 0; i < numSerializerConfigSnapshots; ++i) {
                serializerConfigsMap.put(inputView.readUTF(), TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot((DataInputView)inputView, (ClassLoader)userCodeClassLoader));
            }
            return new StateMetaInfoSnapshot(stateName, stateType, optionsMap, serializerConfigsMap);
        }
    }
}

