/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.runtime.checkpoint.RescaleMappings;
import org.apache.flink.util.Preconditions;

public class InflightDataRescalingDescriptor
implements Serializable {
    public static final InflightDataRescalingDescriptor NO_RESCALE = new NoRescalingDescriptor();
    private static final long serialVersionUID = -3396674344669796295L;
    private final InflightDataGateOrPartitionRescalingDescriptor[] gateOrPartitionDescriptors;

    public InflightDataRescalingDescriptor(InflightDataGateOrPartitionRescalingDescriptor[] gateOrPartitionDescriptors) {
        this.gateOrPartitionDescriptors = (InflightDataGateOrPartitionRescalingDescriptor[])Preconditions.checkNotNull((Object)gateOrPartitionDescriptors);
    }

    public int[] getOldSubtaskIndexes(int gateOrPartitionIndex) {
        return this.gateOrPartitionDescriptors[gateOrPartitionIndex].oldSubtaskIndexes;
    }

    public RescaleMappings getChannelMapping(int gateOrPartitionIndex) {
        return this.gateOrPartitionDescriptors[gateOrPartitionIndex].rescaledChannelsMappings;
    }

    public boolean isAmbiguous(int gateOrPartitionIndex, int oldSubtaskIndex) {
        return this.gateOrPartitionDescriptors[gateOrPartitionIndex].ambiguousSubtaskIndexes.contains(oldSubtaskIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InflightDataRescalingDescriptor that = (InflightDataRescalingDescriptor)o;
        return Arrays.equals(this.gateOrPartitionDescriptors, that.gateOrPartitionDescriptors);
    }

    public int hashCode() {
        return Arrays.hashCode(this.gateOrPartitionDescriptors);
    }

    public String toString() {
        return "InflightDataRescalingDescriptor{gateOrPartitionDescriptors=" + Arrays.toString(this.gateOrPartitionDescriptors) + "}";
    }

    public static class InflightDataGateOrPartitionRescalingDescriptor
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int[] oldSubtaskIndexes;
        private final RescaleMappings rescaledChannelsMappings;
        private final Set<Integer> ambiguousSubtaskIndexes;
        private final MappingType mappingType;

        public InflightDataGateOrPartitionRescalingDescriptor(int[] oldSubtaskIndexes, RescaleMappings rescaledChannelsMappings, Set<Integer> ambiguousSubtaskIndexes, MappingType mappingType) {
            this.oldSubtaskIndexes = oldSubtaskIndexes;
            this.rescaledChannelsMappings = rescaledChannelsMappings;
            this.ambiguousSubtaskIndexes = ambiguousSubtaskIndexes;
            this.mappingType = mappingType;
        }

        public boolean isIdentity() {
            return this.mappingType == MappingType.IDENTITY;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InflightDataGateOrPartitionRescalingDescriptor that = (InflightDataGateOrPartitionRescalingDescriptor)o;
            return Arrays.equals(this.oldSubtaskIndexes, that.oldSubtaskIndexes) && Objects.equals(this.rescaledChannelsMappings, that.rescaledChannelsMappings) && Objects.equals(this.ambiguousSubtaskIndexes, that.ambiguousSubtaskIndexes) && this.mappingType == that.mappingType;
        }

        public int hashCode() {
            int result = Objects.hash(new Object[]{this.rescaledChannelsMappings, this.ambiguousSubtaskIndexes, this.mappingType});
            result = 31 * result + Arrays.hashCode(this.oldSubtaskIndexes);
            return result;
        }

        public String toString() {
            return "InflightDataGateOrPartitionRescalingDescriptor{oldSubtaskIndexes=" + Arrays.toString(this.oldSubtaskIndexes) + ", rescaledChannelsMappings=" + this.rescaledChannelsMappings + ", ambiguousSubtaskIndexes=" + this.ambiguousSubtaskIndexes + ", mappingType=" + this.mappingType + "}";
        }

        public static enum MappingType {
            IDENTITY,
            RESCALING;

        }
    }

    private static class NoRescalingDescriptor
    extends InflightDataRescalingDescriptor {
        private static final long serialVersionUID = 1L;

        public NoRescalingDescriptor() {
            super(new InflightDataGateOrPartitionRescalingDescriptor[0]);
        }

        @Override
        public int[] getOldSubtaskIndexes(int gateOrPartitionIndex) {
            return new int[0];
        }

        @Override
        public RescaleMappings getChannelMapping(int gateOrPartitionIndex) {
            return RescaleMappings.SYMMETRIC_IDENTITY;
        }

        @Override
        public boolean isAmbiguous(int gateOrPartitionIndex, int oldSubtaskIndex) {
            return false;
        }

        private Object readResolve() throws ObjectStreamException {
            return NO_RESCALE;
        }
    }
}

