/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing.declare;

import java.util.Deque;
import java.util.LinkedList;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.core.state.StateFutureUtils;
import org.apache.flink.runtime.asyncprocessing.declare.DeclarationContext;
import org.apache.flink.runtime.asyncprocessing.declare.DeclarationException;
import org.apache.flink.runtime.asyncprocessing.declare.NamedConsumer;
import org.apache.flink.runtime.asyncprocessing.declare.NamedFunction;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.flink.util.function.ThrowingConsumer;

@Experimental
public class DeclarationChain<IN>
implements ThrowingConsumer<IN, Exception> {
    private final DeclarationContext context;
    private final Deque<Transformation<?, ?>> transformations;
    private DeclarationStage<?> currentStage;

    DeclarationChain(DeclarationContext context) {
        this.context = context;
        this.transformations = new LinkedList();
    }

    public void accept(IN in) throws Exception {
        StateFuture<?> future = StateFutureUtils.completedFuture(in);
        for (Transformation<?, ?> trans : this.transformations) {
            future = trans.apply(future);
        }
    }

    public DeclarationStage<IN> firstStage() throws DeclarationException {
        if (this.currentStage != null) {
            throw new DeclarationException("Diverged declaration. Please make sure you call firstStage() once.");
        }
        DeclarationStage declarationStage = new DeclarationStage();
        this.currentStage = declarationStage;
        return declarationStage;
    }

    Transformation<?, ?> getLastTransformation() {
        return this.transformations.getLast();
    }

    @Internal
    static interface Transformation<FROM, TO> {
        public StateFuture<TO> apply(StateFuture<FROM> var1) throws Exception;

        public void withName(String var1) throws DeclarationException;

        public void declare() throws DeclarationException;
    }

    public class DeclarationStage<T> {
        private boolean afterThen = false;

        private void preCheck() throws DeclarationException {
            if (this.afterThen) {
                throw new DeclarationException("Double thenCompose called for single declaration block.");
            }
            if (DeclarationChain.this.currentStage != this) {
                throw new DeclarationException("Diverged declaration. Please make sure you are declaring on the last point.");
            }
            this.afterThen = true;
        }

        public <U> DeclarationStage<U> thenCompose(FunctionWithException<T, StateFuture<U>, Exception> action) throws DeclarationException {
            this.preCheck();
            DeclarationStage<T> next = new DeclarationStage<T>();
            ComposeTransformation<T, U> trans = new ComposeTransformation<T, U>(action);
            DeclarationChain.this.transformations.add(trans);
            DeclarationChain.this.currentStage = next;
            DeclarationChain.this.getLastTransformation().declare();
            return next;
        }

        public DeclarationStage<Void> thenAccept(ThrowingConsumer<T, Exception> action) throws DeclarationException {
            this.preCheck();
            DeclarationStage<Void> next = new DeclarationStage<Void>();
            AcceptTransformation<T> trans = new AcceptTransformation<T>(action);
            DeclarationChain.this.transformations.add(trans);
            DeclarationChain.this.currentStage = next;
            DeclarationChain.this.getLastTransformation().declare();
            return next;
        }

        public DeclarationStage<T> withName(String name) throws DeclarationException {
            DeclarationChain.this.getLastTransformation().withName(name);
            return this;
        }

        public DeclarationChain<IN> finish() throws DeclarationException {
            this.preCheck();
            DeclarationChain.this.getLastTransformation().declare();
            return DeclarationChain.this;
        }
    }

    private class AcceptTransformation<FROM>
    extends AbstractTransformation<FROM, Void> {
        ThrowingConsumer<FROM, Exception> action;
        NamedConsumer<FROM> namedFunction;

        AcceptTransformation(ThrowingConsumer<FROM, Exception> action) {
            this.action = action;
        }

        @Override
        public StateFuture<Void> apply(StateFuture<FROM> upstream) throws Exception {
            return upstream.thenAccept(this.namedFunction);
        }

        @Override
        public void declare() throws DeclarationException {
            if (this.namedFunction == null) {
                this.namedFunction = this.name == null ? DeclarationChain.this.context.declare(this.action) : DeclarationChain.this.context.declare(this.name, this.action);
            }
        }
    }

    private class ComposeTransformation<FROM, TO>
    extends AbstractTransformation<FROM, TO> {
        FunctionWithException<FROM, StateFuture<TO>, ? extends Exception> action;
        NamedFunction<FROM, StateFuture<TO>> namedFunction;

        ComposeTransformation(FunctionWithException<FROM, StateFuture<TO>, Exception> action) {
            this.action = action;
        }

        @Override
        public StateFuture<TO> apply(StateFuture<FROM> upstream) throws Exception {
            return upstream.thenCompose(this.namedFunction);
        }

        @Override
        public void declare() throws DeclarationException {
            if (this.namedFunction == null) {
                this.namedFunction = this.name == null ? DeclarationChain.this.context.declare(this.action) : DeclarationChain.this.context.declare(this.name, this.action);
            }
        }
    }

    private static abstract class AbstractTransformation<FROM, TO>
    implements Transformation<FROM, TO> {
        String name = null;

        private AbstractTransformation() {
        }

        @Override
        public void withName(String newName) throws DeclarationException {
            if (this.name != null) {
                throw new DeclarationException("Double naming");
            }
            this.name = newName;
            this.declare();
        }
    }
}

