/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.streamrecord;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamElementSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.assertj.core.api.Condition;

class StreamElementSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<StreamElement, StreamElement> {
    StreamElementSerializerUpgradeTest() {
    }

    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("stream-element-serializer", flinkVersion, StreamElementSetup.class, StreamElementVerifier.class));
        return testSpecifications;
    }

    public static final class StreamElementSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<StreamElement> {
        public TypeSerializer<StreamElement> createPriorSerializer() {
            return new StreamElementSerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        public StreamElement createTestData() {
            return new StreamRecord((Object)"key", 123456L);
        }
    }

    public static final class StreamElementVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<StreamElement> {
        public TypeSerializer<StreamElement> createUpgradedSerializer() {
            return new StreamElementSerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        public Condition<StreamElement> testDataCondition() {
            return new Condition(se -> {
                if (se instanceof StreamRecord) {
                    StreamRecord sr = (StreamRecord)se;
                    return sr.getValue().equals("key") && sr.getTimestamp() == 123456L;
                }
                return false;
            }, "a StreamRecord with value 'key' and timestamp 123456", new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<StreamElement>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }
}

