/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.streaming.api.operators.StreamMap;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.TestHarnessUtil;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StreamMapTest {
    StreamMapTest() {
    }

    @Test
    void testMap() throws Exception {
        StreamMap operator = new StreamMap((MapFunction)new Map());
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(operator);
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)1, initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)2, initialTime + 2L));
        testHarness.processWatermark(new Watermark(initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)3, initialTime + 3L));
        expectedOutput.add(new StreamRecord((Object)"+2", initialTime + 1L));
        expectedOutput.add(new StreamRecord((Object)"+3", initialTime + 2L));
        expectedOutput.add(new Watermark(initialTime + 2L));
        expectedOutput.add(new StreamRecord((Object)"+4", initialTime + 3L));
        TestHarnessUtil.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
    }

    @Test
    void testOpenClose() throws Exception {
        StreamMap operator = new StreamMap((MapFunction)new TestOpenCloseMapFunction());
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(operator);
        long initialTime = 0L;
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)"Hello", initialTime));
        testHarness.close();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)TestOpenCloseMapFunction.closeCalled).as("RichFunction methods where not called.", new Object[0])).isTrue();
        ((AbstractCollectionAssert)Assertions.assertThat(testHarness.getOutput()).as("Output contains no elements.", new Object[0])).isNotEmpty();
    }

    private static class Map
    implements MapFunction<Integer, String> {
        private static final long serialVersionUID = 1L;

        private Map() {
        }

        public String map(Integer value) throws Exception {
            return "+" + (value + 1);
        }
    }

    private static class TestOpenCloseMapFunction
    extends RichMapFunction<String, String> {
        private static final long serialVersionUID = 1L;
        public static boolean openCalled = false;
        public static boolean closeCalled = false;

        private TestOpenCloseMapFunction() {
        }

        public void open(OpenContext openContext) throws Exception {
            super.open(openContext);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)closeCalled).as("Close called before open.", new Object[0])).isFalse();
            openCalled = true;
        }

        public void close() throws Exception {
            super.close();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)openCalled).as("Open was not called before close.", new Object[0])).isTrue();
            closeCalled = true;
        }

        public String map(String value) throws Exception {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)openCalled).as("Open was not called before run.", new Object[0])).isTrue();
            return value;
        }
    }
}

