/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.runtime.state.ttl.TtlStateFactory;
import org.apache.flink.runtime.state.ttl.TtlValue;
import org.assertj.core.api.Condition;

class TtlSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<TtlValue<String>, TtlValue<String>> {
    TtlSerializerUpgradeTest() {
    }

    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("ttl-serializer", flinkVersion, TtlSerializerSetup.class, TtlSerializerVerifier.class));
        return testSpecifications;
    }

    public static final class TtlSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<TtlValue<String>> {
        public TypeSerializer<TtlValue<String>> createPriorSerializer() {
            return new TtlStateFactory.TtlSerializer((TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE);
        }

        public TtlValue<String> createTestData() {
            return new TtlValue((Object)"hello Gordon", 13L);
        }
    }

    public static final class TtlSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<TtlValue<String>> {
        public TypeSerializer<TtlValue<String>> createUpgradedSerializer() {
            return new TtlStateFactory.TtlSerializer((TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE);
        }

        public Condition<TtlValue<String>> testDataCondition() {
            return new Condition(ttlValue -> Objects.equals(ttlValue.getUserValue(), "hello Gordon") && ttlValue.getLastAccessTimestamp() == 13L, "ttlValue", new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<TtlValue<String>>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }
}

