/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.ttl.TtlAwareSerializer;
import org.apache.flink.runtime.state.ttl.TtlStateFactory;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.runtime.state.ttl.TtlValue;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TtlAwareSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<String, TtlValue<String>> {
    private static final String TEST_DATA = "hello Gordon";

    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion currentVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("ttl-aware-serializer-ttl-value", currentVersion, TtlAwareSerializerEnablingTtlSetup.class, TtlAwareSerializerDisablingTtlVerifier.class));
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("ttl-aware-serializer-string-value", currentVersion, TtlAwareSerializerDisablingTtlSetup.class, TtlAwareSerializerEnablingTtlVerifier.class));
        return testSpecifications;
    }

    @Disabled
    @ParameterizedTest(name="Test Specification = {0}")
    @MethodSource(value={"createTestSpecificationsForAllVersions"})
    void restoreSerializerIsValid(TypeSerializerUpgradeTestBase.TestSpecification<String, TtlValue<String>> testSpecification) throws Exception {
    }

    public <T> DataInputView readAndThenWriteData(DataInputView originalDataInput, TypeSerializer<T> readSerializer, TypeSerializer<T> writeSerializer, Condition<T> testDataCondition) throws IOException {
        TtlAwareSerializer reader = (TtlAwareSerializer)readSerializer;
        TtlAwareSerializer writer = (TtlAwareSerializer)writeSerializer;
        DataOutputSerializer migratedOut = new DataOutputSerializer(64);
        writer.migrateValueFromPriorSerializer(reader, () -> reader.deserialize(originalDataInput), (DataOutputView)migratedOut, TtlTimeProvider.DEFAULT);
        DataInputDeserializer inputView = new DataInputDeserializer(migratedOut.wrapAsByteBuffer());
        Object data = writer.deserialize((DataInputView)inputView);
        Assertions.assertThat((Object)data).is(testDataCondition);
        DataOutputSerializer out = new DataOutputSerializer(64);
        writeSerializer.serialize(data, (DataOutputView)out);
        return new DataInputDeserializer(out.wrapAsByteBuffer());
    }

    public static final class TtlAwareSerializerEnablingTtlSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<TtlValue<String>> {
        public TypeSerializer<TtlValue<String>> createPriorSerializer() {
            return new TtlAwareSerializer((TypeSerializer)new TtlStateFactory.TtlSerializer((TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE));
        }

        public TtlValue<String> createTestData() {
            return new TtlValue((Object)TtlAwareSerializerUpgradeTest.TEST_DATA, 13L);
        }
    }

    public static final class TtlAwareSerializerDisablingTtlVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<String> {
        public TypeSerializer<String> createUpgradedSerializer() {
            return new TtlAwareSerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        public Condition<String> testDataCondition() {
            return new Condition(value -> Objects.equals(value, TtlAwareSerializerUpgradeTest.TEST_DATA), "value", new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<String>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAfterMigration();
        }
    }

    public static final class TtlAwareSerializerDisablingTtlSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<String> {
        public TypeSerializer<String> createPriorSerializer() {
            return new TtlAwareSerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        public String createTestData() {
            return TtlAwareSerializerUpgradeTest.TEST_DATA;
        }
    }

    public static final class TtlAwareSerializerEnablingTtlVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<TtlValue<String>> {
        public TypeSerializer<TtlValue<String>> createUpgradedSerializer() {
            return new TtlAwareSerializer((TypeSerializer)new TtlStateFactory.TtlSerializer((TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE));
        }

        public Condition<TtlValue<String>> testDataCondition() {
            return new Condition(ttlValue -> Objects.equals(ttlValue.getUserValue(), TtlAwareSerializerUpgradeTest.TEST_DATA), "value", new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<TtlValue<String>>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAfterMigration();
        }
    }
}

