/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.state.CheckpointStateOutputStream;
import org.apache.flink.runtime.state.CheckpointStateToolset;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.NotDuplicatingCheckpointStateToolset;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.runtime.state.memory.MemCheckpointStreamFactory;
import org.apache.flink.runtime.state.memory.NonPersistentMetadataCheckpointStorageLocation;

public class TestingCheckpointStorageAccessCoordinatorView
implements CheckpointStorageAccess,
Serializable {
    private final HashMap<String, TestingCompletedCheckpointStorageLocation> registeredSavepoints = new HashMap();

    public void registerSavepoint(String pointer, byte[] metadata) {
        this.registeredSavepoints.put(pointer, new TestingCompletedCheckpointStorageLocation(pointer, metadata));
    }

    public boolean supportsHighlyAvailableStorage() {
        return false;
    }

    public boolean hasDefaultSavepointLocation() {
        return false;
    }

    public CompletedCheckpointStorageLocation resolveCheckpoint(String externalPointer) throws IOException {
        CompletedCheckpointStorageLocation location = this.registeredSavepoints.get(externalPointer);
        if (location != null) {
            return location;
        }
        throw new IOException("Could not find savepoint for pointer: " + externalPointer);
    }

    public void initializeBaseLocationsForCheckpoint() throws IOException {
    }

    public CheckpointStorageLocation initializeLocationForCheckpoint(long checkpointId) throws IOException {
        return new NonPersistentMetadataCheckpointStorageLocation(Integer.MAX_VALUE);
    }

    public CheckpointStorageLocation initializeLocationForSavepoint(long checkpointId, @Nullable String externalLocationPointer) throws IOException {
        return new NonPersistentMetadataCheckpointStorageLocation(Integer.MAX_VALUE);
    }

    public CheckpointStreamFactory resolveCheckpointStorageLocation(long checkpointId, CheckpointStorageLocationReference reference) {
        return new MemCheckpointStreamFactory(Integer.MAX_VALUE);
    }

    public CheckpointStateOutputStream createTaskOwnedStateStream() {
        return new MemCheckpointStreamFactory.MemoryCheckpointOutputStream(Integer.MAX_VALUE);
    }

    public CheckpointStateToolset createTaskOwnedCheckpointStateToolset() {
        return new NotDuplicatingCheckpointStateToolset();
    }

    public CheckpointStorage asCheckpointStorage() {
        return new FactoringCheckpointStorage(this);
    }

    private static final class TestingCompletedCheckpointStorageLocation
    implements CompletedCheckpointStorageLocation,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String pointer;
        private final byte[] metadata;

        TestingCompletedCheckpointStorageLocation(String pointer, byte[] metadata) {
            this.pointer = pointer;
            this.metadata = metadata;
        }

        public String getExternalPointer() {
            return this.pointer;
        }

        public StreamStateHandle getMetadataHandle() {
            return new ByteStreamStateHandle(this.pointer, this.metadata);
        }

        public void disposeStorageLocation() throws IOException {
        }
    }

    private static final class FactoringCheckpointStorage
    implements CheckpointStorage {
        private final TestingCheckpointStorageAccessCoordinatorView testingCoordinatorView;

        private FactoringCheckpointStorage(TestingCheckpointStorageAccessCoordinatorView testingCoordinatorView) {
            this.testingCoordinatorView = testingCoordinatorView;
        }

        public CompletedCheckpointStorageLocation resolveCheckpoint(String externalPointer) throws IOException {
            return this.testingCoordinatorView.resolveCheckpoint(externalPointer);
        }

        public CheckpointStorageAccess createCheckpointStorage(JobID jobId) throws IOException {
            return this.testingCoordinatorView;
        }
    }
}

