/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch;

import java.util.List;
import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.runtime.executiongraph.ResultPartitionBytes;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.scheduler.adaptivebatch.AllToAllBlockingResultInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AllToAllBlockingResultInfoTest {
    AllToAllBlockingResultInfoTest() {
    }

    @Test
    void testGetNumBytesProducedForNonBroadcast() {
        this.testGetNumBytesProduced(false, false, 192L);
    }

    @Test
    void testGetNumBytesProducedForBroadcast() {
        this.testGetNumBytesProduced(true, true, 96L);
        this.testGetNumBytesProduced(true, false, 192L);
    }

    @Test
    void testGetNumBytesProducedWithIndexRange() {
        AllToAllBlockingResultInfo resultInfo = new AllToAllBlockingResultInfo(new IntermediateDataSetID(), 2, 2, false, false);
        resultInfo.recordPartitionInfo(0, new ResultPartitionBytes(new long[]{32L, 64L}));
        resultInfo.recordPartitionInfo(1, new ResultPartitionBytes(new long[]{128L, 256L}));
        IndexRange partitionIndexRange = new IndexRange(0, 1);
        IndexRange subpartitionIndexRange = new IndexRange(0, 0);
        Assertions.assertThat((long)resultInfo.getNumBytesProduced(partitionIndexRange, subpartitionIndexRange)).isEqualTo(160L);
    }

    @Test
    void testGetAggregatedSubpartitionBytes() {
        AllToAllBlockingResultInfo resultInfo = new AllToAllBlockingResultInfo(new IntermediateDataSetID(), 2, 2, false, false);
        resultInfo.recordPartitionInfo(0, new ResultPartitionBytes(new long[]{32L, 64L}));
        resultInfo.recordPartitionInfo(1, new ResultPartitionBytes(new long[]{128L, 256L}));
        Assertions.assertThat((List)resultInfo.getAggregatedSubpartitionBytes()).containsExactly((Object[])new Long[]{160L, 320L});
    }

    @Test
    void testGetBytesWithPartialPartitionInfos() {
        AllToAllBlockingResultInfo resultInfo = new AllToAllBlockingResultInfo(new IntermediateDataSetID(), 2, 2, false, false);
        resultInfo.recordPartitionInfo(0, new ResultPartitionBytes(new long[]{32L, 64L}));
        resultInfo.onFineGrainedSubpartitionBytesNotNeeded();
        Assertions.assertThatThrownBy(() -> ((AllToAllBlockingResultInfo)resultInfo).getNumBytesProduced()).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> ((AllToAllBlockingResultInfo)resultInfo).getAggregatedSubpartitionBytes()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testRecordPartitionInfoMultiTimes() {
        AllToAllBlockingResultInfo resultInfo = new AllToAllBlockingResultInfo(new IntermediateDataSetID(), 2, 2, false, false);
        ResultPartitionBytes partitionBytes1 = new ResultPartitionBytes(new long[]{32L, 64L});
        ResultPartitionBytes partitionBytes2 = new ResultPartitionBytes(new long[]{64L, 128L});
        ResultPartitionBytes partitionBytes3 = new ResultPartitionBytes(new long[]{128L, 256L});
        ResultPartitionBytes partitionBytes4 = new ResultPartitionBytes(new long[]{256L, 512L});
        resultInfo.recordPartitionInfo(0, partitionBytes1);
        Assertions.assertThat((int)resultInfo.getNumOfRecordedPartitions()).isOne();
        resultInfo.resetPartitionInfo(0);
        Assertions.assertThat((int)resultInfo.getNumOfRecordedPartitions()).isZero();
        resultInfo.recordPartitionInfo(0, partitionBytes2);
        resultInfo.recordPartitionInfo(1, partitionBytes3);
        Assertions.assertThat((long)resultInfo.getNumBytesProduced()).isEqualTo(576L);
        Assertions.assertThat((List)resultInfo.getAggregatedSubpartitionBytes()).containsExactly((Object[])new Long[]{192L, 384L});
        Assertions.assertThat((int)resultInfo.getNumOfRecordedPartitions()).isGreaterThan(0);
        resultInfo.onFineGrainedSubpartitionBytesNotNeeded();
        Assertions.assertThat((int)resultInfo.getNumOfRecordedPartitions()).isZero();
        resultInfo.resetPartitionInfo(0);
        resultInfo.recordPartitionInfo(0, partitionBytes4);
        Assertions.assertThat((long)resultInfo.getNumBytesProduced()).isEqualTo(576L);
        Assertions.assertThat((List)resultInfo.getAggregatedSubpartitionBytes()).containsExactly((Object[])new Long[]{192L, 384L});
        Assertions.assertThat((int)resultInfo.getNumOfRecordedPartitions()).isZero();
    }

    private void testGetNumBytesProduced(boolean isBroadcast, boolean singleSubpartitionContainsAllData, long expectedBytes) {
        AllToAllBlockingResultInfo resultInfo = new AllToAllBlockingResultInfo(new IntermediateDataSetID(), 2, 2, isBroadcast, singleSubpartitionContainsAllData);
        resultInfo.recordPartitionInfo(0, new ResultPartitionBytes(new long[]{32L, 32L}));
        resultInfo.recordPartitionInfo(1, new ResultPartitionBytes(new long[]{64L, 64L}));
        Assertions.assertThat((long)resultInfo.getNumBytesProduced()).isEqualTo(expectedBytes);
    }
}

