/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.metrics.dump.MetricDump;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.metrics.AbstractMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.MessagePathParameter;
import org.apache.flink.runtime.rest.messages.MessageQueryParameter;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.job.metrics.AbstractMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.Metric;
import org.apache.flink.runtime.rest.messages.job.metrics.MetricCollectionResponseBody;
import org.apache.flink.runtime.rest.messages.job.metrics.MetricsFilterParameter;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

class AbstractMetricsHandlerTest {
    private static final String TEST_METRIC_NAME = "test_counter";
    private static final int TEST_METRIC_VALUE = 1000;
    private static final String METRICS_FILTER_QUERY_PARAM = "get";
    @Mock
    private MetricFetcher mockMetricFetcher;
    @Mock
    private DispatcherGateway mockDispatcherGateway;
    private TestMetricsHandler testMetricsHandler;

    AbstractMetricsHandlerTest() {
    }

    @BeforeEach
    void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        MetricStore metricStore = new MetricStore();
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)new QueryScopeInfo.JobManagerQueryScopeInfo(), TEST_METRIC_NAME, 1000L));
        Mockito.when((Object)this.mockMetricFetcher.getMetricStore()).thenReturn((Object)metricStore);
        this.testMetricsHandler = new TestMetricsHandler(new GatewayRetriever<DispatcherGateway>(){

            public CompletableFuture<DispatcherGateway> getFuture() {
                return CompletableFuture.completedFuture(AbstractMetricsHandlerTest.this.mockDispatcherGateway);
            }
        }, Duration.ofMillis(50L), Collections.emptyMap(), (MessageHeaders<EmptyRequestBody, MetricCollectionResponseBody, TestMessageParameters>)new TestMetricsHeaders(), this.mockMetricFetcher);
    }

    @Test
    void testListMetrics() throws Exception {
        CompletableFuture completableFuture = this.testMetricsHandler.handleRequest(HandlerRequest.create((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new TestMessageParameters(), Collections.emptyList()), (RestfulGateway)this.mockDispatcherGateway);
        Assertions.assertThat((CompletableFuture)completableFuture).isDone();
        MetricCollectionResponseBody metricCollectionResponseBody = (MetricCollectionResponseBody)completableFuture.get();
        Assertions.assertThat((Collection)metricCollectionResponseBody.getMetrics()).hasSize(1);
        Metric metric = (Metric)metricCollectionResponseBody.getMetrics().iterator().next();
        Assertions.assertThat((String)metric.getId()).isEqualTo(TEST_METRIC_NAME);
        Assertions.assertThat((String)metric.getValue()).isNull();
    }

    @Test
    void testReturnEmptyListIfNoComponentMetricStore() throws Exception {
        this.testMetricsHandler.returnComponentMetricStore = false;
        CompletableFuture completableFuture = this.testMetricsHandler.handleRequest(HandlerRequest.create((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new TestMessageParameters(), Collections.emptyList()), (RestfulGateway)this.mockDispatcherGateway);
        Assertions.assertThat((CompletableFuture)completableFuture).isDone();
        MetricCollectionResponseBody metricCollectionResponseBody = (MetricCollectionResponseBody)completableFuture.get();
        Assertions.assertThat((Collection)metricCollectionResponseBody.getMetrics()).isEmpty();
    }

    @Test
    void testGetMetrics() throws Exception {
        CompletableFuture completableFuture = this.testMetricsHandler.handleRequest(HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new TestMessageParameters(), Collections.emptyMap(), Collections.singletonMap(METRICS_FILTER_QUERY_PARAM, Collections.singletonList(TEST_METRIC_NAME)), Collections.emptyList()), (RestfulGateway)this.mockDispatcherGateway);
        Assertions.assertThat((CompletableFuture)completableFuture).isDone();
        MetricCollectionResponseBody metricCollectionResponseBody = (MetricCollectionResponseBody)completableFuture.get();
        Assertions.assertThat((Collection)metricCollectionResponseBody.getMetrics()).hasSize(1);
        Metric metric = (Metric)metricCollectionResponseBody.getMetrics().iterator().next();
        Assertions.assertThat((String)metric.getId()).isEqualTo(TEST_METRIC_NAME);
        Assertions.assertThat((String)metric.getValue()).isEqualTo(Integer.toString(1000));
    }

    @Test
    void testReturnEmptyListIfRequestedMetricIsUnknown() throws Exception {
        CompletableFuture completableFuture = this.testMetricsHandler.handleRequest(HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new TestMessageParameters(), Collections.emptyMap(), Collections.singletonMap(METRICS_FILTER_QUERY_PARAM, Collections.singletonList("unknown_metric")), Collections.emptyList()), (RestfulGateway)this.mockDispatcherGateway);
        Assertions.assertThat((CompletableFuture)completableFuture).isDone();
        MetricCollectionResponseBody metricCollectionResponseBody = (MetricCollectionResponseBody)completableFuture.get();
        Assertions.assertThat((Collection)metricCollectionResponseBody.getMetrics()).isEmpty();
    }

    private static class TestMetricsHandler
    extends AbstractMetricsHandler<TestMessageParameters> {
        private boolean returnComponentMetricStore = true;

        private TestMetricsHandler(GatewayRetriever<DispatcherGateway> leaderRetriever, Duration timeout, Map<String, String> headers, MessageHeaders<EmptyRequestBody, MetricCollectionResponseBody, TestMessageParameters> messageHeaders, MetricFetcher metricFetcher) {
            super(leaderRetriever, timeout, headers, messageHeaders, metricFetcher);
        }

        @Nullable
        protected MetricStore.ComponentMetricStore getComponentMetricStore(HandlerRequest<EmptyRequestBody> request, MetricStore metricStore) {
            return this.returnComponentMetricStore ? metricStore.getJobManagerMetricStore() : null;
        }
    }

    private static class TestMetricsHeaders
    extends AbstractMetricsHeaders<TestMessageParameters> {
        private TestMetricsHeaders() {
        }

        public TestMessageParameters getUnresolvedMessageParameters() {
            return new TestMessageParameters();
        }

        public String getTargetRestEndpointURL() {
            return "/";
        }

        public String getDescription() {
            return "";
        }
    }

    private static class TestMessageParameters
    extends MessageParameters {
        private final MetricsFilterParameter metricsFilterParameter = new MetricsFilterParameter();

        private TestMessageParameters() {
        }

        public Collection<MessagePathParameter<?>> getPathParameters() {
            return Collections.emptyList();
        }

        public Collection<MessageQueryParameter<?>> getQueryParameters() {
            return Collections.singletonList(this.metricsFilterParameter);
        }
    }
}

