/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.slotmanager.JobScopedResourceTracker;
import org.apache.flink.runtime.slots.ResourceRequirement;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class JobScopedResourceTrackerTest {
    private static final ResourceProfile PROFILE_1 = ResourceProfile.newBuilder().setCpuCores(1.0).build();
    private static final ResourceProfile PROFILE_2 = ResourceProfile.newBuilder().setCpuCores(2.0).build();

    JobScopedResourceTrackerTest() {
    }

    @Test
    void testInitialBehavior() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        Assertions.assertThat((boolean)tracker.isEmpty()).isTrue();
        Assertions.assertThat((Collection)tracker.getAcquiredResources()).isEmpty();
        Assertions.assertThat((Collection)tracker.getMissingResources()).isEmpty();
    }

    @Test
    void testLossOfUntrackedResourceThrowsException() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> tracker.notifyLostResource(ResourceProfile.UNKNOWN)).withFailMessage("If no resource were acquired, then a loss of resource should fail with an exception.", new Object[0])).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testIsEmptyForRequirementNotifications() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        tracker.notifyAcquiredResource(ResourceProfile.ANY);
        Assertions.assertThat((boolean)tracker.isEmpty()).isFalse();
        tracker.notifyLostResource(ResourceProfile.ANY);
        Assertions.assertThat((boolean)tracker.isEmpty()).isTrue();
    }

    @Test
    void testIsEmptyForResourceNotifications() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        tracker.notifyResourceRequirements(Collections.singleton(ResourceRequirement.create((ResourceProfile)ResourceProfile.UNKNOWN, (int)1)));
        Assertions.assertThat((boolean)tracker.isEmpty()).isFalse();
        tracker.notifyResourceRequirements(Collections.emptyList());
        Assertions.assertThat((boolean)tracker.isEmpty()).isTrue();
    }

    @Test
    void testRequirementsNotificationWithoutResources() {
        ResourceRequirement[][] resourceRequirements;
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        for (Object[] objectArray : resourceRequirements = new ResourceRequirement[][]{{ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)4), ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)2)}, {ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)8), ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)2)}, {ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)4), ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)2)}}) {
            tracker.notifyResourceRequirements(Arrays.asList(objectArray));
            Assertions.assertThat((boolean)tracker.isEmpty()).isFalse();
            Assertions.assertThat((Collection)tracker.getAcquiredResources()).isEmpty();
            Assertions.assertThat((Collection)tracker.getMissingResources()).containsExactlyInAnyOrder(objectArray);
        }
        tracker.notifyResourceRequirements(Collections.emptyList());
        Assertions.assertThat((Collection)tracker.getAcquiredResources()).isEmpty();
        Assertions.assertThat((Collection)tracker.getMissingResources()).isEmpty();
    }

    @Test
    void testRequirementsNotificationWithResources() {
        int x;
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        ResourceRequirement[][] resourceRequirements = new ResourceRequirement[][]{{ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)4), ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)2)}, {ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)8), ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)2)}, {ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)4), ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)2)}};
        int numAcquiredSlotsP1 = resourceRequirements[0][0].getNumberOfRequiredSlots() - 1;
        int numAcquiredSlotsP2 = resourceRequirements[0][1].getNumberOfRequiredSlots();
        for (x = 0; x < numAcquiredSlotsP1; ++x) {
            tracker.notifyAcquiredResource(PROFILE_1);
        }
        for (x = 0; x < numAcquiredSlotsP2; ++x) {
            tracker.notifyAcquiredResource(PROFILE_2);
        }
        for (ResourceRequirement[] resourceRequirement : resourceRequirements) {
            tracker.notifyResourceRequirements(Arrays.asList(resourceRequirement));
            Assertions.assertThat((Collection)tracker.getAcquiredResources()).containsExactlyInAnyOrder((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)numAcquiredSlotsP1), ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)numAcquiredSlotsP2)});
            Assertions.assertThat((Collection)tracker.getMissingResources()).containsExactlyInAnyOrder((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)(resourceRequirement[0].getNumberOfRequiredSlots() - numAcquiredSlotsP1))});
        }
        tracker.notifyResourceRequirements(Collections.emptyList());
        Assertions.assertThat((Collection)tracker.getAcquiredResources()).containsExactlyInAnyOrder((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)numAcquiredSlotsP1), ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)numAcquiredSlotsP2)});
        Assertions.assertThat((Collection)tracker.getMissingResources()).isEmpty();
    }

    @Test
    void testMatchingWithResourceExceedingRequirement() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        tracker.notifyResourceRequirements(Arrays.asList(ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)1)));
        tracker.notifyAcquiredResource(PROFILE_2);
        Assertions.assertThat((Collection)tracker.getAcquiredResources()).contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)1)});
    }

    @Test
    void testMatchingWithResourceLessThanRequirement() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        tracker.notifyResourceRequirements(Arrays.asList(ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)1)));
        tracker.notifyAcquiredResource(PROFILE_1);
        Assertions.assertThat((Collection)tracker.getAcquiredResources()).contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)1)});
        Assertions.assertThat((Collection)tracker.getMissingResources()).contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)1)});
    }

    @Test
    void testResourceNotificationsWithoutRequirements() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        tracker.notifyAcquiredResource(ResourceProfile.ANY);
        Assertions.assertThat((boolean)tracker.isEmpty()).isFalse();
        Assertions.assertThat((Collection)tracker.getAcquiredResources()).contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1)});
        Assertions.assertThat((Collection)tracker.getMissingResources()).isEmpty();
        tracker.notifyAcquiredResource(ResourceProfile.ANY);
        Assertions.assertThat((boolean)tracker.isEmpty()).isFalse();
        Assertions.assertThat((Collection)tracker.getAcquiredResources()).contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)2)});
        Assertions.assertThat((Collection)tracker.getMissingResources()).isEmpty();
        tracker.notifyLostResource(ResourceProfile.ANY);
        Assertions.assertThat((boolean)tracker.isEmpty()).isFalse();
        Assertions.assertThat((Collection)tracker.getAcquiredResources()).contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1)});
        Assertions.assertThat((Collection)tracker.getMissingResources()).isEmpty();
        tracker.notifyLostResource(ResourceProfile.ANY);
        Assertions.assertThat((boolean)tracker.isEmpty()).isTrue();
        Assertions.assertThat((Collection)tracker.getAcquiredResources()).isEmpty();
        Assertions.assertThat((Collection)tracker.getMissingResources()).isEmpty();
    }

    @Test
    void testResourceNotificationsWithRequirements() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        ResourceRequirement[] resourceRequirementsArray = new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)2), ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)1)};
        tracker.notifyResourceRequirements(Arrays.asList(resourceRequirementsArray));
        for (int x = 0; x < 2; ++x) {
            tracker.notifyAcquiredResource(PROFILE_1);
        }
        Assertions.assertThat((Collection)tracker.getAcquiredResources()).contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)2)});
        Assertions.assertThat((Collection)tracker.getMissingResources()).contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)1)});
        tracker.notifyLostResource(PROFILE_1);
        Assertions.assertThat((Collection)tracker.getAcquiredResources()).contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)1)});
        Assertions.assertThat((Collection)tracker.getMissingResources()).containsExactlyInAnyOrder((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)1), ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)1)});
    }

    @Test
    void testRequirementReductionRetainsExceedingResources() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        tracker.notifyResourceRequirements(Collections.singleton(ResourceRequirement.create((ResourceProfile)ResourceProfile.UNKNOWN, (int)1)));
        tracker.notifyAcquiredResource(ResourceProfile.ANY);
        tracker.notifyResourceRequirements(Collections.emptyList());
        Assertions.assertThat((Collection)tracker.getAcquiredResources()).contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1)});
        Assertions.assertThat((Collection)tracker.getMissingResources()).isEmpty();
        tracker.notifyResourceRequirements(Collections.singleton(ResourceRequirement.create((ResourceProfile)ResourceProfile.UNKNOWN, (int)1)));
        Assertions.assertThat((Collection)tracker.getAcquiredResources()).contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1)});
        Assertions.assertThat((Collection)tracker.getMissingResources()).isEmpty();
    }

    @Test
    void testExcessResourcesAreAssignedOnRequirementIncrease() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        tracker.notifyAcquiredResource(ResourceProfile.ANY);
        tracker.notifyResourceRequirements(Collections.singleton(ResourceRequirement.create((ResourceProfile)ResourceProfile.UNKNOWN, (int)1)));
        Assertions.assertThat((Collection)tracker.getAcquiredResources()).contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1)});
        Assertions.assertThat((Collection)tracker.getMissingResources()).isEmpty();
    }

    @Test
    void testExcessResourcesAreAssignedOnResourceLoss() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        tracker.notifyAcquiredResource(ResourceProfile.ANY);
        tracker.notifyAcquiredResource(ResourceProfile.ANY);
        tracker.notifyResourceRequirements(Collections.singleton(ResourceRequirement.create((ResourceProfile)ResourceProfile.UNKNOWN, (int)1)));
        tracker.notifyLostResource(ResourceProfile.ANY);
        Assertions.assertThat((Collection)tracker.getAcquiredResources()).contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1)});
        Assertions.assertThat((Collection)tracker.getMissingResources()).isEmpty();
    }
}

