/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils;

import java.io.IOException;
import java.util.Random;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;

public final class PairGenerator {
    private static char[] alpha = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm'};
    private final long seed;
    private final int keyMax;
    private final int valueLength;
    private final KeyMode keyMode;
    private final ValueMode valueMode;
    private Random random;
    private int counter;
    private final StringValue valueConstant;

    public PairGenerator(long seed, int keyMax, int valueLength) {
        this(seed, keyMax, valueLength, KeyMode.RANDOM, ValueMode.FIX_LENGTH);
    }

    public PairGenerator(long seed, int keyMax, int valueLength, KeyMode keyMode, ValueMode valueMode) {
        this(seed, keyMax, valueLength, keyMode, valueMode, null);
    }

    public PairGenerator(long seed, int keyMax, int valueLength, KeyMode keyMode, ValueMode valueMode, String constant) {
        this.seed = seed;
        this.keyMax = keyMax;
        this.valueLength = valueLength;
        this.keyMode = keyMode;
        this.valueMode = valueMode;
        this.random = new Random(seed);
        this.counter = 0;
        this.valueConstant = new StringValue();
        if (constant != null) {
            this.valueConstant.setValue((CharSequence)constant);
        }
    }

    public void next(Pair target) {
        int n = target.key = this.keyMode == KeyMode.SORTED ? (this.counter = this.counter + 1) : Math.abs(this.random.nextInt() % this.keyMax) + 1;
        if (this.valueMode == ValueMode.CONSTANT) {
            target.value = this.valueConstant;
        } else {
            this.randomString(target.value);
        }
    }

    public void reset() {
        this.random = new Random(this.seed);
        this.counter = 0;
    }

    private void randomString(StringValue target) {
        int length = this.valueMode == ValueMode.FIX_LENGTH ? this.valueLength : this.valueLength - this.random.nextInt(this.valueLength / 3);
        target.setLength(0);
        for (int i = 0; i < length; ++i) {
            target.append(alpha[this.random.nextInt(alpha.length)]);
        }
    }

    public static enum KeyMode {
        SORTED,
        RANDOM;

    }

    public static enum ValueMode {
        FIX_LENGTH,
        RANDOM_LENGTH,
        CONSTANT;

    }

    public static class Pair
    implements Value {
        private static final long serialVersionUID = 1L;
        private int key;
        private StringValue value = new StringValue();

        public int getKey() {
            return this.key;
        }

        public StringValue getValue() {
            return this.value;
        }

        public void write(DataOutputView out) throws IOException {
            out.writeInt(this.key);
            this.value.write(out);
        }

        public void read(DataInputView in) throws IOException {
            this.key = in.readInt();
            this.value.read(in);
        }

        public int hashCode() {
            return 31 * this.key + this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Pair) {
                Pair other = (Pair)obj;
                return other.key == this.key && other.value.equals((Object)this.value);
            }
            return false;
        }

        public String toString() {
            return String.format("(%d, %s)", this.key, this.value);
        }
    }
}

