/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.testutils.serialization.types.SerializationTestType;
import org.apache.flink.testutils.serialization.types.SerializationTestTypeFactory;
import org.apache.flink.testutils.serialization.types.Util;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PagedViewsTest {
    PagedViewsTest() {
    }

    @Test
    void testSequenceOfIntegersWithAlignedBuffers() throws Exception {
        int numInts = 1000000;
        PagedViewsTest.testSequenceOfTypes((Iterable<SerializationTestType>)Util.randomRecords((int)1000000, (SerializationTestTypeFactory)SerializationTestTypeFactory.INT), 2048);
    }

    @Test
    void testSequenceOfIntegersWithUnalignedBuffers() throws Exception {
        int numInts = 1000000;
        PagedViewsTest.testSequenceOfTypes((Iterable<SerializationTestType>)Util.randomRecords((int)1000000, (SerializationTestTypeFactory)SerializationTestTypeFactory.INT), 2047);
    }

    @Test
    void testRandomTypes() throws Exception {
        int numTypes = 100000;
        PagedViewsTest.testSequenceOfTypes((Iterable<SerializationTestType>)Util.randomRecords((int)100000), 57);
    }

    @Test
    void testReadFully() throws IOException {
        int bufferSize = 100;
        byte[] expected = new byte[bufferSize];
        new Random().nextBytes(expected);
        TestOutputView outputView = new TestOutputView(bufferSize);
        outputView.write(expected);
        outputView.close();
        TestInputView inputView = new TestInputView(outputView.segments);
        byte[] buffer = new byte[bufferSize];
        inputView.readFully(buffer);
        Assertions.assertThat((int)inputView.getCurrentPositionInSegment()).isEqualTo(bufferSize);
        Assertions.assertThat((byte[])buffer).isEqualTo((Object)expected);
    }

    @Test
    void testReadFullyAcrossSegments() throws Exception {
        int bufferSize = 100;
        int segmentSize = 30;
        byte[] expected = new byte[bufferSize];
        new Random().nextBytes(expected);
        TestOutputView outputView = new TestOutputView(segmentSize);
        outputView.write(expected);
        outputView.close();
        TestInputView inputView = new TestInputView(outputView.segments);
        byte[] buffer = new byte[bufferSize];
        inputView.readFully(buffer);
        Assertions.assertThat((int)inputView.getCurrentPositionInSegment()).isEqualTo(bufferSize % segmentSize);
        Assertions.assertThat((byte[])buffer).isEqualTo((Object)expected);
    }

    @Test
    void testReadAcrossSegments() throws Exception {
        int bufferSize = 100;
        int bytes2Write = 75;
        int segmentSize = 30;
        byte[] expected = new byte[bytes2Write];
        new Random().nextBytes(expected);
        TestOutputView outputView = new TestOutputView(segmentSize);
        outputView.write(expected);
        outputView.close();
        TestInputView inputView = new TestInputView(outputView.segments);
        byte[] buffer = new byte[bufferSize];
        int bytesRead = inputView.read(buffer);
        Assertions.assertThat((int)bytesRead).isEqualTo(bytes2Write);
        Assertions.assertThat((int)inputView.getCurrentPositionInSegment()).isEqualTo(bytes2Write % segmentSize);
        byte[] tempBuffer = new byte[bytesRead];
        System.arraycopy(buffer, 0, tempBuffer, 0, bytesRead);
        Assertions.assertThat((byte[])tempBuffer).isEqualTo((Object)expected);
    }

    @Test
    void testEmptyingInputView() throws Exception {
        int bufferSize = 100;
        int bytes2Write = 75;
        int segmentSize = 30;
        byte[] expected = new byte[bytes2Write];
        new Random().nextBytes(expected);
        TestOutputView outputView = new TestOutputView(segmentSize);
        outputView.write(expected);
        outputView.close();
        TestInputView inputView = new TestInputView(outputView.segments);
        byte[] buffer = new byte[bufferSize];
        int bytesRead = inputView.read(buffer);
        Assertions.assertThat((int)bytesRead).isEqualTo(bytes2Write);
        byte[] tempBuffer = new byte[bytesRead];
        System.arraycopy(buffer, 0, tempBuffer, 0, bytesRead);
        Assertions.assertThat((byte[])tempBuffer).isEqualTo((Object)expected);
        bytesRead = inputView.read(buffer);
        Assertions.assertThat((int)bytesRead).isEqualTo(-1);
        Assertions.assertThat((int)inputView.getCurrentPositionInSegment()).isEqualTo(bytes2Write % segmentSize);
    }

    @Test
    void testReadFullyWithNotEnoughData() throws Exception {
        int bufferSize = 100;
        int bytes2Write = 99;
        int segmentSize = 30;
        byte[] expected = new byte[bytes2Write];
        new Random().nextBytes(expected);
        TestOutputView outputView = new TestOutputView(segmentSize);
        outputView.write(expected);
        outputView.close();
        TestInputView inputView = new TestInputView(outputView.segments);
        byte[] buffer = new byte[bufferSize];
        Assertions.assertThatThrownBy(() -> inputView.readFully(buffer)).isInstanceOf(EOFException.class);
        int bytesRead = inputView.read(buffer);
        Assertions.assertThat((int)bytesRead).isEqualTo(-1);
    }

    @Test
    void testReadFullyWithOffset() throws Exception {
        int bufferSize = 100;
        int segmentSize = 30;
        byte[] expected = new byte[bufferSize];
        new Random().nextBytes(expected);
        TestOutputView outputView = new TestOutputView(segmentSize);
        outputView.write(expected);
        outputView.close();
        TestInputView inputView = new TestInputView(outputView.segments);
        byte[] buffer = new byte[2 * bufferSize];
        inputView.readFully(buffer, bufferSize, bufferSize);
        Assertions.assertThat((int)inputView.getCurrentPositionInSegment()).isEqualTo(bufferSize % segmentSize);
        byte[] tempBuffer = new byte[bufferSize];
        System.arraycopy(buffer, bufferSize, tempBuffer, 0, bufferSize);
        Assertions.assertThat((byte[])tempBuffer).isEqualTo((Object)expected);
    }

    @Test
    void testReadFullyEmptyView() {
        int segmentSize = 30;
        TestOutputView outputView = new TestOutputView(segmentSize);
        outputView.close();
        TestInputView inputView = new TestInputView(outputView.segments);
        byte[] buffer = new byte[segmentSize];
        Assertions.assertThatThrownBy(() -> inputView.readFully(buffer)).isInstanceOf(EOFException.class);
    }

    private static void testSequenceOfTypes(Iterable<SerializationTestType> sequence, int segmentSize) throws Exception {
        ArrayList<SerializationTestType> elements = new ArrayList<SerializationTestType>(512);
        TestOutputView outView = new TestOutputView(segmentSize);
        for (SerializationTestType type : sequence) {
            type.write((DataOutputView)outView);
            elements.add(type);
        }
        outView.close();
        TestInputView inView = new TestInputView(outView.segments);
        for (SerializationTestType reference : elements) {
            SerializationTestType result = (SerializationTestType)reference.getClass().newInstance();
            result.read((DataInputView)inView);
            Assertions.assertThat((Object)result).isEqualTo((Object)reference);
        }
    }

    private static final class TestOutputView
    extends AbstractPagedOutputView {
        private final List<SegmentWithPosition> segments = new ArrayList<SegmentWithPosition>();
        private final int segmentSize;

        private TestOutputView(int segmentSize) {
            super(MemorySegmentFactory.allocateUnpooledSegment((int)segmentSize), segmentSize, 0);
            this.segmentSize = segmentSize;
        }

        protected MemorySegment nextSegment(MemorySegment current, int positionInCurrent) throws IOException {
            this.segments.add(new SegmentWithPosition(current, positionInCurrent));
            return MemorySegmentFactory.allocateUnpooledSegment((int)this.segmentSize);
        }

        public void close() {
            this.segments.add(new SegmentWithPosition(this.getCurrentSegment(), this.getCurrentPositionInSegment()));
        }
    }

    private static final class TestInputView
    extends AbstractPagedInputView {
        private final List<SegmentWithPosition> segments;
        private int num;

        private TestInputView(List<SegmentWithPosition> segments) {
            super(segments.get((int)0).segment, segments.get((int)0).position, 0);
            this.segments = segments;
            this.num = 0;
        }

        protected MemorySegment nextSegment(MemorySegment current) throws IOException {
            ++this.num;
            if (this.num < this.segments.size()) {
                return this.segments.get((int)this.num).segment;
            }
            throw new EOFException();
        }

        protected int getLimitForSegment(MemorySegment segment) {
            return this.segments.get((int)this.num).position;
        }
    }

    private static final class SegmentWithPosition {
        private final MemorySegment segment;
        private final int position;

        SegmentWithPosition(MemorySegment segment, int position) {
            this.segment = segment;
            this.position = position;
        }
    }
}

