/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraph;
import org.apache.flink.runtime.executiongraph.TestingDefaultExecutionGraphBuilder;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.scheduler.SchedulerBase;
import org.apache.flink.runtime.util.JobVertexConnectionUtils;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class VertexSlotSharingTest {
    @RegisterExtension
    static final TestExecutorExtension<ScheduledExecutorService> EXECUTOR_RESOURCE = TestingUtils.defaultExecutorExtension();

    VertexSlotSharingTest() {
    }

    @Test
    void testAssignSlotSharingGroup() {
        try {
            JobVertex v1 = new JobVertex("v1");
            JobVertex v2 = new JobVertex("v2");
            JobVertex v3 = new JobVertex("v3");
            JobVertex v4 = new JobVertex("v4");
            JobVertex v5 = new JobVertex("v5");
            v1.setParallelism(4);
            v2.setParallelism(5);
            v3.setParallelism(7);
            v4.setParallelism(1);
            v5.setParallelism(11);
            v1.setInvokableClass(AbstractInvokable.class);
            v2.setInvokableClass(AbstractInvokable.class);
            v3.setInvokableClass(AbstractInvokable.class);
            v4.setInvokableClass(AbstractInvokable.class);
            v5.setInvokableClass(AbstractInvokable.class);
            JobVertexConnectionUtils.connectNewDataSetAsInput(v2, v1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            JobVertexConnectionUtils.connectNewDataSetAsInput(v5, v4, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            SlotSharingGroup jg1 = new SlotSharingGroup();
            v2.setSlotSharingGroup(jg1);
            v3.setSlotSharingGroup(jg1);
            SlotSharingGroup jg2 = new SlotSharingGroup();
            v4.setSlotSharingGroup(jg2);
            v5.setSlotSharingGroup(jg2);
            ArrayList<JobVertex> vertices = new ArrayList<JobVertex>(Arrays.asList(v1, v2, v3, v4, v5));
            DefaultExecutionGraph eg = TestingDefaultExecutionGraphBuilder.newBuilder().setVertexParallelismStore(SchedulerBase.computeVertexParallelismStore(vertices)).build((ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor());
            eg.attachJobGraph(vertices, UnregisteredMetricGroups.createUnregisteredJobManagerJobMetricGroup());
            Assertions.assertThat((Object)eg.getJobVertex(v1.getID()).getSlotSharingGroup()).isNotEqualTo((Object)eg.getJobVertex(v2.getID()).getSlotSharingGroup());
            SlotSharingGroup group1 = eg.getJobVertex(v2.getID()).getSlotSharingGroup();
            Assertions.assertThat((Object)group1).isNotNull();
            Assertions.assertThat((Object)eg.getJobVertex(v3.getID()).getSlotSharingGroup()).isEqualTo((Object)group1);
            Assertions.assertThat((Collection)group1.getJobVertexIds()).hasSize(2);
            Assertions.assertThat((boolean)group1.getJobVertexIds().contains(v2.getID())).isTrue();
            Assertions.assertThat((boolean)group1.getJobVertexIds().contains(v3.getID())).isTrue();
            SlotSharingGroup group2 = eg.getJobVertex(v4.getID()).getSlotSharingGroup();
            Assertions.assertThat((Object)group2).isNotNull();
            Assertions.assertThat((Object)eg.getJobVertex(v5.getID()).getSlotSharingGroup()).isEqualTo((Object)group2);
            Assertions.assertThat((Collection)group1.getJobVertexIds()).hasSize(2);
            Assertions.assertThat((boolean)group2.getJobVertexIds().contains(v4.getID())).isTrue();
            Assertions.assertThat((boolean)group2.getJobVertexIds().contains(v5.getID())).isTrue();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }
}

