/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CheckpointStatsCounts;
import org.apache.flink.runtime.checkpoint.CheckpointStatsHistory;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStatsSummary;
import org.apache.flink.runtime.checkpoint.RestoredCheckpointStats;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class CheckpointStatsSnapshotTest {
    @Test
    void testIsJavaSerializable() throws Exception {
        CheckpointStatsCounts counts = new CheckpointStatsCounts();
        counts.incrementInProgressCheckpoints();
        counts.incrementInProgressCheckpoints();
        counts.incrementInProgressCheckpoints();
        counts.incrementCompletedCheckpoints();
        counts.incrementFailedCheckpoints();
        counts.incrementRestoredCheckpoints();
        CompletedCheckpointStatsSummary summary = new CompletedCheckpointStatsSummary();
        summary.updateSummary(this.createCompletedCheckpointsStats(12398L, 9919L));
        summary.updateSummary(this.createCompletedCheckpointsStats(2221L, 3333L));
        CheckpointStatsHistory history = new CheckpointStatsHistory(1);
        RestoredCheckpointStats restored = new RestoredCheckpointStats(1L, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), 99119L, null, 42L);
        CheckpointStatsSnapshot snapshot = new CheckpointStatsSnapshot(counts, summary.createSnapshot(), history, restored);
        CheckpointStatsSnapshot copy = (CheckpointStatsSnapshot)CommonTestUtils.createCopySerializable((Serializable)snapshot);
        Assertions.assertThat((long)copy.getCounts().getNumberOfCompletedCheckpoints()).isEqualTo(counts.getNumberOfCompletedCheckpoints());
        Assertions.assertThat((long)copy.getCounts().getNumberOfFailedCheckpoints()).isEqualTo(counts.getNumberOfFailedCheckpoints());
        Assertions.assertThat((int)copy.getCounts().getNumberOfInProgressCheckpoints()).isEqualTo(counts.getNumberOfInProgressCheckpoints());
        Assertions.assertThat((long)copy.getCounts().getNumberOfRestoredCheckpoints()).isEqualTo(counts.getNumberOfRestoredCheckpoints());
        Assertions.assertThat((long)copy.getCounts().getTotalNumberOfCheckpoints()).isEqualTo(counts.getTotalNumberOfCheckpoints());
        Assertions.assertThat((long)copy.getSummaryStats().getStateSizeStats().getSum()).isEqualTo(summary.getStateSizeStats().getSum());
        Assertions.assertThat((long)copy.getSummaryStats().getEndToEndDurationStats().getSum()).isEqualTo(summary.getEndToEndDurationStats().getSum());
        Assertions.assertThat((long)copy.getLatestRestoredCheckpoint().getCheckpointId()).isEqualTo(restored.getCheckpointId());
    }

    private CompletedCheckpointStats createCompletedCheckpointsStats(long stateSize, long endToEndDuration) {
        CompletedCheckpointStats completed = (CompletedCheckpointStats)Mockito.mock(CompletedCheckpointStats.class);
        Mockito.when((Object)completed.getStateSize()).thenReturn((Object)stateSize);
        Mockito.when((Object)completed.getEndToEndDuration()).thenReturn((Object)endToEndDuration);
        return completed;
    }
}

