/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.util.OperatingSystem;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

@Tag(value="org.apache.flink.testutils.junit.FailsInGHAContainerWithRootUser")
class BlobUtilsNonWritableTest {
    private static final String CANNOT_CREATE_THIS = "cannot-create-this";
    @TempDir
    private Path tempDir;

    BlobUtilsNonWritableTest() {
    }

    @BeforeEach
    void before() {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)OperatingSystem.isWindows()).as("setWritable doesn't work on Windows", new Object[0])).isFalse();
        Assertions.assertThat((boolean)this.tempDir.toFile().setExecutable(true, false)).isTrue();
        Assertions.assertThat((boolean)this.tempDir.toFile().setReadable(true, false)).isTrue();
        Assertions.assertThat((boolean)this.tempDir.toFile().setWritable(false, false)).isTrue();
    }

    @Test
    void testExceptionOnCreateStorageDirectoryFailure() {
        Configuration config = new Configuration();
        config.set(BlobServerOptions.STORAGE_DIRECTORY, (Object)this.getStorageLocationFile().getAbsolutePath());
        Assertions.assertThatThrownBy(() -> BlobUtils.createBlobStorageDirectory((Configuration)config, null)).isInstanceOf(IOException.class);
    }

    @Test
    void testExceptionOnCreateCacheDirectoryFailureNoJob() {
        Assertions.assertThatThrownBy(() -> BlobUtils.getStorageLocation((File)this.getStorageLocationFile(), null, (BlobKey)new TransientBlobKey())).isInstanceOf(IOException.class);
    }

    @Test
    void testExceptionOnCreateCacheDirectoryFailureForJobTransient() {
        Assertions.assertThatThrownBy(() -> BlobUtils.getStorageLocation((File)this.getStorageLocationFile(), (JobID)new JobID(), (BlobKey)new TransientBlobKey())).isInstanceOf(IOException.class);
    }

    @Test
    void testExceptionOnCreateCacheDirectoryFailureForJobPermanent() {
        Assertions.assertThatThrownBy(() -> BlobUtils.getStorageLocation((File)this.getStorageLocationFile(), (JobID)new JobID(), (BlobKey)new PermanentBlobKey())).isInstanceOf(IOException.class);
    }

    private File getStorageLocationFile() {
        return this.tempDir.resolve(CANNOT_CREATE_THIS).toFile();
    }
}

