/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.pekko;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rpc.pekko.PekkoUtils;
import org.apache.flink.util.Preconditions;
import org.apache.pekko.actor.ActorSystem;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ActorSystemExtension
implements BeforeEachCallback,
AfterEachCallback {
    private final Configuration configuration;
    private ActorSystem actorSystem;

    private ActorSystemExtension(Configuration configuration) {
        this.configuration = configuration;
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        Preconditions.checkState((this.actorSystem == null ? 1 : 0) != 0, (Object)"ActorSystem must not be initialized when calling before.");
        this.actorSystem = PekkoUtils.createLocalActorSystem((Configuration)this.configuration);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        Preconditions.checkState((this.actorSystem != null ? 1 : 0) != 0, (Object)"ActorSystem must be initialized when calling after.");
        PekkoUtils.terminateActorSystem((ActorSystem)this.actorSystem).join();
    }

    public ActorSystem getActorSystem() {
        return this.actorSystem;
    }

    public static ActorSystemExtension defaultConfiguration() {
        return new ActorSystemExtension(new Configuration());
    }

    public static ActorSystemExtension withConfiguration(Configuration configuration) {
        return new ActorSystemExtension(configuration);
    }
}

