/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.client.state;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.queryablestate.client.state.ImmutableValueState;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ImmutableValueStateTest {
    private final ValueStateDescriptor<Long> valueStateDesc = new ValueStateDescriptor("test", (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
    private ValueState<Long> valueState;

    ImmutableValueStateTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        if (!this.valueStateDesc.isSerializerInitialized()) {
            this.valueStateDesc.initializeSerializerUnlessSet(new ExecutionConfig());
        }
        this.valueState = (ValueState)ImmutableValueState.createState(this.valueStateDesc, (byte[])ByteBuffer.allocate(8).putLong(42L).array());
    }

    @Test
    void testUpdate() throws IOException {
        long value = (Long)this.valueState.value();
        Assertions.assertThat((long)value).isEqualTo(42L);
        Assertions.assertThatThrownBy(() -> this.valueState.update((Object)54L)).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testClear() throws IOException {
        long value = (Long)this.valueState.value();
        Assertions.assertThat((long)value).isEqualTo(42L);
        Assertions.assertThatThrownBy(() -> this.valueState.clear()).isInstanceOf(UnsupportedOperationException.class);
    }
}

