/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.util.Objects;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedFieldReference;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.legacy.sources.tsextractors.TimestampExtractor;
import org.apache.flink.table.sources.wmstrategies.PunctuatedWatermarkAssigner;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class TestingDescriptors {

    public static class CustomExtractor
    extends TimestampExtractor {
        private final String field;

        public CustomExtractor(String field) {
            this.field = field;
        }

        public CustomExtractor() {
            this("ts");
        }

        public String[] getArgumentFields() {
            return new String[]{this.field};
        }

        public void validateArgumentFields(TypeInformation<?>[] argumentFieldTypes) {
            if (argumentFieldTypes[0] != Types.SQL_TIMESTAMP) {
                throw new ValidationException(String.format("Field 'ts' must be of type Timestamp but is of type %s.", argumentFieldTypes[0]));
            }
        }

        public Expression getExpression(ResolvedFieldReference[] fieldAccesses) {
            ResolvedFieldReference fieldAccess = fieldAccesses[0];
            Preconditions.checkState((fieldAccess.resultType() == Types.SQL_TIMESTAMP ? 1 : 0) != 0);
            FieldReferenceExpression fieldReferenceExpr = new FieldReferenceExpression(fieldAccess.name(), TypeConversions.fromLegacyInfoToDataType((TypeInformation)fieldAccess.resultType()), 0, fieldAccess.fieldIndex());
            return ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.CAST, (Expression[])new Expression[]{fieldReferenceExpr, ApiExpressionUtils.typeLiteral((DataType)DataTypes.BIGINT())});
        }

        public boolean equals(Object o) {
            if (o instanceof CustomExtractor) {
                return this.field.equals(((CustomExtractor)((Object)o)).field);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.field);
        }
    }

    public static class CustomAssigner
    extends PunctuatedWatermarkAssigner {
        public Watermark getWatermark(Row row, long timestamp) {
            throw new UnsupportedOperationException();
        }
    }
}

