/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils.serializers.python;

import java.sql.Timestamp;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.runtime.typeutils.serializers.python.TimestampSerializer;

abstract class TimestampSerializerTest
extends SerializerTestBase<Timestamp> {
    TimestampSerializerTest() {
    }

    protected TypeSerializer<Timestamp> createSerializer() {
        return new TimestampSerializer(this.getPrecision());
    }

    protected int getLength() {
        return this.getPrecision() <= 3 ? 8 : 12;
    }

    protected Class<Timestamp> getTypeClass() {
        return Timestamp.class;
    }

    abstract int getPrecision();

    protected Timestamp[] getTestData() {
        return new Timestamp[]{Timestamp.valueOf("2018-03-11 03:00:00.123")};
    }

    static final class TimestampSerializerTest8
    extends TimestampSerializerTest {
        TimestampSerializerTest8() {
        }

        @Override
        protected int getPrecision() {
            return 8;
        }
    }

    static final class TimestampSerializerTest6
    extends TimestampSerializerTest {
        TimestampSerializerTest6() {
        }

        @Override
        protected int getPrecision() {
            return 6;
        }
    }

    static final class TimestampSerializerTest3
    extends TimestampSerializerTest {
        TimestampSerializerTest3() {
        }

        @Override
        protected int getPrecision() {
            return 3;
        }
    }

    static final class TimestampSerializerTest0
    extends TimestampSerializerTest {
        TimestampSerializerTest0() {
        }

        @Override
        protected int getPrecision() {
            return 0;
        }
    }
}

