/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.python.aggregate.arrow.batch;

import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.python.PythonFunctionRunner;
import org.apache.flink.python.PythonOptions;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.python.PythonFunctionInfo;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.operators.python.aggregate.arrow.AbstractArrowPythonAggregateFunctionOperator;
import org.apache.flink.table.runtime.operators.python.aggregate.arrow.batch.AbstractBatchArrowPythonAggregateFunctionOperatorTest;
import org.apache.flink.table.runtime.operators.python.aggregate.arrow.batch.BatchArrowPythonGroupAggregateFunctionOperator;
import org.apache.flink.table.runtime.utils.PassThroughPythonAggregateFunctionRunner;
import org.apache.flink.table.runtime.utils.PythonTestUtils;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.junit.jupiter.api.Test;

class BatchArrowPythonGroupAggregateFunctionOperatorTest
extends AbstractBatchArrowPythonAggregateFunctionOperatorTest {
    BatchArrowPythonGroupAggregateFunctionOperatorTest() {
    }

    @Test
    void testGroupAggregateFunction() throws Exception {
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.getTestHarness(new Configuration());
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)this.newRow(true, "c1", "c2", 0L), initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)this.newRow(true, "c1", "c4", 1L), initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)this.newRow(true, "c2", "c6", 2L), initialTime + 3L));
        testHarness.close();
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 0L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", 2L)));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
    }

    @Test
    void testFinishBundleTriggeredByCount() throws Exception {
        Configuration conf = new Configuration();
        conf.set(PythonOptions.MAX_BUNDLE_SIZE, (Object)2);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.getTestHarness(conf);
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)this.newRow(true, "c1", "c2", 0L), initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)this.newRow(true, "c1", "c2", 1L), initialTime + 2L));
        this.assertOutputEquals("FinishBundle should not be triggered.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(new StreamRecord((Object)this.newRow(true, "c2", "c6", 2L), initialTime + 2L));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 0L)));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.close();
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", 2L)));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
    }

    @Test
    void testFinishBundleTriggeredByTime() throws Exception {
        Configuration conf = new Configuration();
        conf.set(PythonOptions.MAX_BUNDLE_SIZE, (Object)10);
        conf.set(PythonOptions.MAX_BUNDLE_TIME_MILLS, (Object)1000L);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.getTestHarness(conf);
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)this.newRow(true, "c1", "c2", 0L), initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)this.newRow(true, "c1", "c2", 1L), initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)this.newRow(true, "c2", "c6", 2L), initialTime + 2L));
        this.assertOutputEquals("FinishBundle should not be triggered.", expectedOutput, testHarness.getOutput());
        testHarness.setProcessingTime(1000L);
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 0L)));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.close();
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", 2L)));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
    }

    @Override
    public LogicalType[] getOutputLogicalType() {
        return new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType()};
    }

    @Override
    public RowType getInputType() {
        return new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new VarCharType()), new RowType.RowField("f2", (LogicalType)new VarCharType()), new RowType.RowField("f3", (LogicalType)new BigIntType())));
    }

    @Override
    public RowType getOutputType() {
        return new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new VarCharType()), new RowType.RowField("f2", (LogicalType)new BigIntType())));
    }

    @Override
    public AbstractArrowPythonAggregateFunctionOperator getTestOperator(Configuration config, PythonFunctionInfo[] pandasAggregateFunctions, RowType inputType, RowType outputType, int[] groupingSet, int[] udafInputOffsets) {
        RowType udfInputType = (RowType)Projection.of((int[])udafInputOffsets).project((LogicalType)inputType);
        RowType udfOutputType = (RowType)Projection.range((int)groupingSet.length, (int)outputType.getFieldCount()).project((LogicalType)outputType);
        return new PassThroughBatchArrowPythonGroupAggregateFunctionOperator(config, pandasAggregateFunctions, inputType, udfInputType, udfOutputType, ProjectionCodeGenerator.generateProjection((CodeGeneratorContext)new CodeGeneratorContext((ReadableConfig)new Configuration(), Thread.currentThread().getContextClassLoader()), (String)"UdafInputProjection", (RowType)inputType, (RowType)udfInputType, (int[])udafInputOffsets), ProjectionCodeGenerator.generateProjection((CodeGeneratorContext)new CodeGeneratorContext((ReadableConfig)new Configuration(), Thread.currentThread().getContextClassLoader()), (String)"GroupKey", (RowType)inputType, (RowType)((RowType)Projection.of((int[])groupingSet).project((LogicalType)inputType)), (int[])groupingSet), ProjectionCodeGenerator.generateProjection((CodeGeneratorContext)new CodeGeneratorContext((ReadableConfig)new Configuration(), Thread.currentThread().getContextClassLoader()), (String)"GroupSet", (RowType)inputType, (RowType)((RowType)Projection.of((int[])groupingSet).project((LogicalType)inputType)), (int[])groupingSet));
    }

    private static class PassThroughBatchArrowPythonGroupAggregateFunctionOperator
    extends BatchArrowPythonGroupAggregateFunctionOperator {
        PassThroughBatchArrowPythonGroupAggregateFunctionOperator(Configuration config, PythonFunctionInfo[] pandasAggFunctions, RowType inputType, RowType udfInputType, RowType udfOutputType, GeneratedProjection inputGeneratedProjection, GeneratedProjection groupKeyGeneratedProjection, GeneratedProjection groupSetGeneratedProjection) {
            super(config, pandasAggFunctions, inputType, udfInputType, udfOutputType, inputGeneratedProjection, groupKeyGeneratedProjection, groupSetGeneratedProjection);
        }

        public PythonFunctionRunner createPythonFunctionRunner() {
            return new PassThroughPythonAggregateFunctionRunner(this.getContainingTask().getEnvironment(), this.getRuntimeContext().getTaskInfo().getTaskName(), PythonTestUtils.createTestProcessEnvironmentManager(), this.udfInputType, this.udfOutputType, this.getFunctionUrn(), this.createUserDefinedFunctionsProto(), PythonTestUtils.createMockFlinkMetricContainer(), false);
        }
    }
}

