/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.utils;

import java.time.Duration;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.fnexecution.v1.FlinkFnApi;
import org.apache.flink.python.util.ProtoUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ProtoUtilsTest {
    ProtoUtilsTest() {
    }

    @Test
    void testParseStateTtlConfigFromProto() {
        FlinkFnApi.StateDescriptor.StateTTLConfig.CleanupStrategies cleanupStrategiesProto = FlinkFnApi.StateDescriptor.StateTTLConfig.CleanupStrategies.newBuilder().setIsCleanupInBackground(true).addStrategies(FlinkFnApi.StateDescriptor.StateTTLConfig.CleanupStrategies.MapStrategiesEntry.newBuilder().setStrategy(FlinkFnApi.StateDescriptor.StateTTLConfig.CleanupStrategies.Strategies.FULL_STATE_SCAN_SNAPSHOT).setEmptyStrategy(FlinkFnApi.StateDescriptor.StateTTLConfig.CleanupStrategies.EmptyCleanupStrategy.EMPTY_STRATEGY)).addStrategies(FlinkFnApi.StateDescriptor.StateTTLConfig.CleanupStrategies.MapStrategiesEntry.newBuilder().setStrategy(FlinkFnApi.StateDescriptor.StateTTLConfig.CleanupStrategies.Strategies.INCREMENTAL_CLEANUP).setIncrementalCleanupStrategy(FlinkFnApi.StateDescriptor.StateTTLConfig.CleanupStrategies.IncrementalCleanupStrategy.newBuilder().setCleanupSize(10).setRunCleanupForEveryRecord(true).build())).addStrategies(FlinkFnApi.StateDescriptor.StateTTLConfig.CleanupStrategies.MapStrategiesEntry.newBuilder().setStrategy(FlinkFnApi.StateDescriptor.StateTTLConfig.CleanupStrategies.Strategies.ROCKSDB_COMPACTION_FILTER).setRocksdbCompactFilterCleanupStrategy(FlinkFnApi.StateDescriptor.StateTTLConfig.CleanupStrategies.RocksdbCompactFilterCleanupStrategy.newBuilder().setQueryTimeAfterNumEntries(1000L).build())).build();
        FlinkFnApi.StateDescriptor.StateTTLConfig stateTTLConfigProto = FlinkFnApi.StateDescriptor.StateTTLConfig.newBuilder().setTtl(1000L).setUpdateType(FlinkFnApi.StateDescriptor.StateTTLConfig.UpdateType.OnCreateAndWrite).setStateVisibility(FlinkFnApi.StateDescriptor.StateTTLConfig.StateVisibility.NeverReturnExpired).setCleanupStrategies(cleanupStrategiesProto).build();
        StateTtlConfig stateTTLConfig = ProtoUtils.parseStateTtlConfigFromProto((FlinkFnApi.StateDescriptor.StateTTLConfig)stateTTLConfigProto);
        Assertions.assertThat((Comparable)stateTTLConfig.getUpdateType()).isEqualTo((Object)StateTtlConfig.UpdateType.OnCreateAndWrite);
        Assertions.assertThat((Comparable)stateTTLConfig.getStateVisibility()).isEqualTo((Object)StateTtlConfig.StateVisibility.NeverReturnExpired);
        Assertions.assertThat((Duration)stateTTLConfig.getTimeToLive()).isEqualTo((Object)Duration.ofMillis(1000L));
        Assertions.assertThat((Comparable)stateTTLConfig.getTtlTimeCharacteristic()).isEqualTo((Object)StateTtlConfig.TtlTimeCharacteristic.ProcessingTime);
        StateTtlConfig.CleanupStrategies cleanupStrategies = stateTTLConfig.getCleanupStrategies();
        Assertions.assertThat((boolean)cleanupStrategies.isCleanupInBackground()).isTrue();
        Assertions.assertThat((boolean)cleanupStrategies.inFullSnapshot()).isTrue();
        StateTtlConfig.IncrementalCleanupStrategy incrementalCleanupStrategy = cleanupStrategies.getIncrementalCleanupStrategy();
        Assertions.assertThat((Object)incrementalCleanupStrategy).isNotNull();
        Assertions.assertThat((int)incrementalCleanupStrategy.getCleanupSize()).isEqualTo(10);
        Assertions.assertThat((boolean)incrementalCleanupStrategy.runCleanupForEveryRecord()).isTrue();
        StateTtlConfig.RocksdbCompactFilterCleanupStrategy rocksdbCompactFilterCleanupStrategy = cleanupStrategies.getRocksdbCompactFilterCleanupStrategy();
        Assertions.assertThat((Object)rocksdbCompactFilterCleanupStrategy).isNotNull();
        Assertions.assertThat((long)rocksdbCompactFilterCleanupStrategy.getQueryTimeAfterNumEntries()).isEqualTo(1000L);
        Assertions.assertThat((Duration)rocksdbCompactFilterCleanupStrategy.getPeriodicCompactionTime()).isEqualTo((Object)Duration.ofDays(30L));
    }
}

